/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands;

import org.aesh.command.Command;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;
import org.infinispan.commons.util.Util;

public abstract class CliCommand
implements Command<ContextAwareCommandInvocation> {
    public static final String CACHE = "cache";
    public static final String COUNTER = "counter";
    public static final String FILE = "file";
    public static final String KEY = "key";
    public static final String NAME = "name";
    public static final String NAMES = "names";
    public static final String PATH = "path";
    public static final String QUIET = "quiet";
    public static final String TYPE = "type";
    public static final String VALUE = "value";

    public CommandResult execute(ContextAwareCommandInvocation invocation) throws CommandException {
        if (this.isHelp()) {
            invocation.println(invocation.getHelpInfo());
            return CommandResult.SUCCESS;
        }
        try {
            return this.exec(invocation);
        }
        catch (CommandException e) {
            invocation.getShell().writeln("\u001b[0;33m" + e.getLocalizedMessage() + "\u001b[0;39m");
            return CommandResult.FAILURE;
        }
        catch (Throwable e) {
            Throwable cause = Util.getRootCause((Throwable)e);
            invocation.getShell().writeln("\u001b[0;31m" + cause.getClass().getName() + ": " + cause.getLocalizedMessage() + "\u001b[0;39m");
            return CommandResult.FAILURE;
        }
    }

    protected abstract boolean isHelp();

    protected abstract CommandResult exec(ContextAwareCommandInvocation var1) throws CommandException;

    public int nesting() {
        return 0;
    }
}

