/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands;

import java.util.Collections;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandResult;
import org.aesh.command.GroupCommandDefinition;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.infinispan.cli.activators.ConnectionActivator;
import org.infinispan.cli.commands.CliCommand;
import org.infinispan.cli.commands.CommandInputLine;
import org.infinispan.cli.completers.CacheCompleter;
import org.infinispan.cli.completers.CounterCompleter;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;

@GroupCommandDefinition(name="drop", description="Drops a cache or a counter", activator=ConnectionActivator.class, groupCommands={Cache.class, Counter.class})
public class Drop
extends CliCommand {
    public static final String CMD = "drop";
    @Option(shortName=104, hasValue=false, overrideRequired=true)
    protected boolean help;

    @Override
    public boolean isHelp() {
        return this.help;
    }

    @Override
    public CommandResult exec(ContextAwareCommandInvocation invocation) {
        invocation.println(invocation.getHelpInfo());
        return CommandResult.FAILURE;
    }

    @CommandDefinition(name="counter", description="Drop a counter", activator=ConnectionActivator.class)
    public static class Counter
    extends CliCommand {
        public static final String CMD = "counter";
        @Argument(required=true, completer=CounterCompleter.class, description="The counter name")
        String name;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        public CommandResult exec(ContextAwareCommandInvocation invocation) {
            if (this.help) {
                invocation.println(invocation.getHelpInfo());
            }
            CommandInputLine cmd = new CommandInputLine(Drop.CMD).arg("type", CMD).arg("name", this.name);
            return invocation.execute(Collections.singletonList(cmd));
        }
    }

    @CommandDefinition(name="cache", description="Drop a cache", activator=ConnectionActivator.class)
    public static class Cache
    extends CliCommand {
        public static final String CMD = "cache";
        @Argument(required=true, completer=CacheCompleter.class, description="The cache name")
        String name;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        public CommandResult exec(ContextAwareCommandInvocation invocation) {
            if (this.help) {
                invocation.println(invocation.getHelpInfo());
            }
            CommandInputLine cmd = new CommandInputLine(Drop.CMD).arg("type", CMD).arg("name", this.name);
            return invocation.execute(cmd);
        }
    }
}

