/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandResult;
import org.aesh.command.GroupCommandDefinition;
import org.aesh.command.impl.completer.FileOptionCompleter;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.aesh.command.option.OptionList;
import org.aesh.io.FileResource;
import org.aesh.io.Resource;
import org.infinispan.cli.activators.ConnectionActivator;
import org.infinispan.cli.commands.CliCommand;
import org.infinispan.cli.commands.CommandInputLine;
import org.infinispan.cli.completers.BackupCompleter;
import org.infinispan.cli.completers.CacheCompleter;
import org.infinispan.cli.completers.CacheConfigurationCompleter;
import org.infinispan.cli.completers.CounterCompleter;
import org.infinispan.cli.completers.SchemaCompleter;
import org.infinispan.cli.completers.TaskCompleter;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;
import org.infinispan.cli.logging.Messages;

@GroupCommandDefinition(name="backup", description="Manages container backup creation and restoration", activator=ConnectionActivator.class, groupCommands={Create.class, Delete.class, Get.class, ListBackups.class, Restore.class})
public class Backup
extends CliCommand {
    public static final String CMD = "backup";
    public static final String CACHES = "caches";
    public static final String CACHE_CONFIGS = "cache-configs";
    public static final String COUNTERS = "counters";
    public static final String PROTO_SCHEMAS = "proto-schemas";
    public static final String SCRIPTS = "scripts";
    public static final String[] ALL_RESOURCE_TYPES = new String[]{"caches", "cache-configs", "counters", "proto-schemas", "scripts"};
    @Option(shortName=104, hasValue=false, overrideRequired=true)
    protected boolean help;

    @Override
    public boolean isHelp() {
        return this.help;
    }

    @Override
    public CommandResult exec(ContextAwareCommandInvocation invocation) {
        invocation.println(invocation.getHelpInfo());
        return CommandResult.FAILURE;
    }

    public static Map<String, List<String>> createResourceMap(CommandInputLine cmd) {
        HashMap<String, List<String>> resourceMap = new HashMap<String, List<String>>();
        for (String resource : ALL_RESOURCE_TYPES) {
            if (!cmd.hasArg(resource)) continue;
            resourceMap.put(resource, (List)cmd.argAs(resource));
        }
        return resourceMap;
    }

    private static abstract class AbstractResourceCommand
    extends AbstractBackupCommand {
        final String type;
        @OptionList(description="Comma separated list of caches to include, '*' indicates all available", completer=CacheCompleter.class, name="caches")
        List<String> caches;
        @OptionList(description="Comma separated list of cache configurations to include, '*' indicates all available", completer=CacheConfigurationCompleter.class, name="cache-configs")
        List<String> cacheConfigs;
        @OptionList(description="Comma separated list of counters to include, '*' indicates all available", completer=CounterCompleter.class, name="counters")
        List<String> counters;
        @OptionList(description="Comma separated list of proto schemas to include, '*' indicates all available", completer=SchemaCompleter.class, name="proto-schemas")
        List<String> protoSchemas;
        @OptionList(description="Comma separated list of scripts to include, '*' indicates all available", completer=TaskCompleter.class, name="scripts")
        List<String> scripts;

        AbstractResourceCommand(String type) {
            this.type = type;
        }

        @Override
        protected CommandResult exec(ContextAwareCommandInvocation invocation) {
            CommandInputLine cmd = new CommandInputLine(Backup.CMD).arg("type", this.type).optionalArg(Backup.CACHES, this.caches).optionalArg(Backup.CACHE_CONFIGS, this.cacheConfigs).optionalArg(Backup.COUNTERS, this.counters).optionalArg(Backup.PROTO_SCHEMAS, this.protoSchemas).optionalArg(Backup.SCRIPTS, this.scripts);
            this.additionalArgs(cmd);
            return invocation.execute(cmd);
        }

        abstract void additionalArgs(CommandInputLine var1);
    }

    private static abstract class AbstractBackupCommand
    extends CliCommand {
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        private AbstractBackupCommand() {
        }

        @Override
        public boolean isHelp() {
            return this.help;
        }
    }

    @CommandDefinition(name="restore", description="Restore a backup", activator=ConnectionActivator.class)
    public static class Restore
    extends AbstractResourceCommand {
        public static final String CMD = "restore";
        public static final String UPLOAD_BACKUP = "upload-backup";
        @Argument(description="The path of the backup file ", completer=FileOptionCompleter.class, required=true)
        Resource path;
        @Option(shortName=110, description="Defines a name for the restore request.")
        String name;
        @Option(shortName=117, description="Indicates that the path is a local file which must be uploaded to the server", hasValue=false, name="upload-backup")
        boolean upload;

        public Restore() {
            super(CMD);
        }

        @Override
        protected void additionalArgs(CommandInputLine cmd) {
            if (!this.upload && !((FileResource)this.path).getFile().isAbsolute()) {
                throw Messages.MSG.backupAbsolutePathRequired();
            }
            cmd.arg("path", this.path).optionalArg(UPLOAD_BACKUP, this.upload).option("name", this.name);
        }
    }

    @CommandDefinition(name="create", description="Create a backup on the server", activator=ConnectionActivator.class)
    public static class Create
    extends AbstractResourceCommand {
        public static final String CMD = "create";
        public static final String DIR = "dir";
        @Option(shortName=100, description="The directory on the server to be used for creating and storing the backup")
        String dir;
        @Option(shortName=110, description="The name of the backup")
        String name;

        public Create() {
            super(CMD);
        }

        @Override
        protected void additionalArgs(CommandInputLine cmd) {
            cmd.option(DIR, this.dir).option("name", this.name);
        }
    }

    @CommandDefinition(name="ls", description="List all backups on the server", activator=ConnectionActivator.class)
    public static class ListBackups
    extends AbstractBackupCommand {
        public static final String CMD = "ls";

        @Override
        protected CommandResult exec(ContextAwareCommandInvocation invocation) {
            return invocation.execute(new CommandInputLine(Backup.CMD).arg("type", CMD));
        }
    }

    @CommandDefinition(name="get", description="Get a backup from the server", activator=ConnectionActivator.class)
    public static class Get
    extends AbstractBackupCommand {
        public static final String CMD = "get";
        public static final String NO_CONTENT = "no-content";
        @Argument(description="The name of the backup", completer=BackupCompleter.class, required=true)
        String name;
        @Option(description="No content is downloaded, but the command only returns once the backup has finished", hasValue=false, name="no-content")
        boolean noContent;

        @Override
        protected CommandResult exec(ContextAwareCommandInvocation invocation) {
            return invocation.execute(new CommandInputLine(Backup.CMD).arg("type", CMD).arg("name", this.name).option(NO_CONTENT, this.noContent));
        }
    }

    @CommandDefinition(name="delete", description="Delete a backup on the server", activator=ConnectionActivator.class)
    public static class Delete
    extends AbstractBackupCommand {
        public static final String CMD = "delete";
        @Argument(description="The name of the backup", completer=BackupCompleter.class, required=true)
        String name;

        @Override
        protected CommandResult exec(ContextAwareCommandInvocation invocation) {
            return invocation.execute(new CommandInputLine(Backup.CMD).arg("type", CMD).arg("name", this.name));
        }
    }
}

