/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands.kubernetes;

import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandResult;
import org.aesh.command.GroupCommandDefinition;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.infinispan.cli.commands.CliCommand;
import org.infinispan.cli.commands.kubernetes.Kube;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;
import org.infinispan.cli.impl.KubernetesContextImpl;

@GroupCommandDefinition(name="get", description="Displays resources", groupCommands={Clusters.class})
public class Get
extends CliCommand {
    public static final String CMD = "get";
    @Option(shortName=104, hasValue=false, overrideRequired=true)
    protected boolean help;

    @Override
    public boolean isHelp() {
        return this.help;
    }

    @Override
    public CommandResult exec(ContextAwareCommandInvocation invocation) {
        return CommandResult.FAILURE;
    }

    @CommandDefinition(name="clusters", description="Get clusters")
    public static class Clusters
    extends CliCommand {
        public static final String CMD = "clusters";
        @Option(shortName=110, description="Select the namespace")
        String namespace;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;
        @Option(shortName=115, hasValue=false)
        protected boolean secrets;
        @Argument
        String name;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        public CommandResult exec(ContextAwareCommandInvocation invocation) {
            KubernetesClient client = ((KubernetesContextImpl)invocation.getContext()).getKubernetesClient();
            this.namespace = Kube.getNamespaceOrDefault(client, this.namespace);
            Map resource = client.customResource(Kube.INFINISPAN_CLUSTER_CRD).list();
            List items = (List)Kube.get(resource, "items");
            PrintStream out = invocation.getShellOutput();
            out.printf("%-32s %-16s %-9s %-16s%n", "NAME", "NAMESPACE", "STATUS", "SECRETS");
            items.forEach(item -> {
                String n = (String)Kube.get(item, "metadata.name");
                String ns = (String)Kube.get(item, "metadata.namespace");
                List pods = ((PodList)((FilterWatchListDeletable)((NonNamespaceOperation)client.pods().inNamespace(ns)).withLabel("infinispan_cr", n)).list()).getItems();
                long running = pods.stream().map(p -> p.getStatus()).filter(s -> "Running".equalsIgnoreCase(s.getPhase())).count();
                out.printf("%-32s %-16s %-9s", n, ns, running + "/" + pods.size());
                if (this.secrets) {
                    String secretName = (String)Kube.get(item, "spec.security.endpointSecretName");
                    Secret secret = Kube.getSecret(client, ns, secretName);
                    Kube.decodeIdentitiesSecret(secret, (u, p) -> out.printf("%n%-60s%-16s %-16s", "", u, p));
                    out.println();
                } else {
                    out.printf(" %-16s%n", "******");
                }
            });
            return CommandResult.SUCCESS;
        }
    }
}

