/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands.kubernetes;

import io.fabric8.kubernetes.client.KubernetesClient;
import java.io.IOException;
import java.util.Map;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandResult;
import org.aesh.command.option.Option;
import org.infinispan.cli.commands.CliCommand;
import org.infinispan.cli.commands.kubernetes.Kube;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;
import org.infinispan.cli.impl.KubernetesContextImpl;

@CommandDefinition(name="uninstall", description="Uninstalls the operator")
public class Uninstall
extends CliCommand {
    public static final String CMD = "uninstall";
    @Option(shortName=110, description="Select the namespace")
    String namespace;
    @Option(shortName=104, hasValue=false, overrideRequired=true)
    protected boolean help;

    @Override
    public boolean isHelp() {
        return this.help;
    }

    @Override
    public CommandResult exec(ContextAwareCommandInvocation invocation) {
        KubernetesClient client = ((KubernetesContextImpl)invocation.getContext()).getKubernetesClient();
        this.namespace = Kube.getNamespaceOrDefault(client, this.namespace);
        try {
            Map deleted = client.customResource(Kube.OPERATOR_SUBSCRIPTION_CRD).delete(this.namespace, "infinispan");
            return deleted != null && deleted.isEmpty() ? CommandResult.SUCCESS : CommandResult.FAILURE;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

