/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.List;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandResult;
import org.aesh.command.impl.completer.FileOptionCompleter;
import org.aesh.command.option.Arguments;
import org.aesh.command.option.Option;
import org.aesh.io.Resource;
import org.infinispan.cli.commands.CliCommand;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;
import org.infinispan.commons.util.StringPropertyReplacer;

@CommandDefinition(name="run", description="Reads and executes commands from one or more files")
public class Run
extends CliCommand {
    @Arguments(required=true, completer=FileOptionCompleter.class)
    private List<Resource> arguments;
    @Option(shortName=104, hasValue=false, overrideRequired=true)
    protected boolean help;

    @Override
    public boolean isHelp() {
        return this.help;
    }

    @Override
    public CommandResult exec(ContextAwareCommandInvocation invocation) {
        if (this.arguments != null && this.arguments.size() > 0) {
            for (Resource resource : this.arguments) {
                try (BufferedReader br = new BufferedReader("-".equals(resource.getName()) ? new InputStreamReader(System.in) : new InputStreamReader(resource.read()));){
                    String line = br.readLine();
                    while (line != null) {
                        if (!line.startsWith("#")) {
                            invocation.executeCommand("batch " + StringPropertyReplacer.replaceProperties((String)line));
                        }
                        line = br.readLine();
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return CommandResult.SUCCESS;
    }
}

