/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands.rest;

import java.util.concurrent.CompletionStage;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandResult;
import org.aesh.command.GroupCommandDefinition;
import org.aesh.command.option.Option;
import org.infinispan.cli.activators.ConnectionActivator;
import org.infinispan.cli.commands.CliCommand;
import org.infinispan.cli.commands.rest.RestCliCommand;
import org.infinispan.cli.completers.CacheCompleter;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;
import org.infinispan.cli.resources.Resource;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestResponse;

@GroupCommandDefinition(name="site", description="Manages backup sites", activator=ConnectionActivator.class, groupCommands={Status.class, BringOnline.class, TakeOffline.class, PushSiteState.class, CancelPushState.class, CancelReceiveState.class, PushSiteStatus.class, ClearPushStateStatus.class})
public class Site
extends CliCommand {
    @Option(shortName=104, hasValue=false, overrideRequired=true)
    protected boolean help;

    @Override
    public boolean isHelp() {
        return this.help;
    }

    @Override
    public CommandResult exec(ContextAwareCommandInvocation invocation) {
        invocation.println(invocation.getHelpInfo());
        return CommandResult.FAILURE;
    }

    @CommandDefinition(name="clear-push-site-status", description="Clears the push state status", activator=ConnectionActivator.class)
    public static class ClearPushStateStatus
    extends RestCliCommand {
        @Option(required=true, completer=CacheCompleter.class)
        String cache;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, Resource resource) {
            return client.cache(this.cache).clearPushStateStatus();
        }
    }

    @CommandDefinition(name="push-site-status", description="Shows the status of pushing to a site", activator=ConnectionActivator.class)
    public static class PushSiteStatus
    extends RestCliCommand {
        @Option(required=true, completer=CacheCompleter.class)
        String cache;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, Resource resource) {
            return client.cache(this.cache).pushStateStatus();
        }
    }

    @CommandDefinition(name="cancel-receive-state", description="Cancels receiving state to a site", activator=ConnectionActivator.class)
    public static class CancelReceiveState
    extends RestCliCommand {
        @Option(required=true, completer=CacheCompleter.class)
        String cache;
        @Option(required=true)
        String site;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, Resource resource) {
            return client.cache(this.cache).cancelReceiveState(this.site);
        }
    }

    @CommandDefinition(name="cancel-push-state", description="Cacncels pushing state to a site", activator=ConnectionActivator.class)
    public static class CancelPushState
    extends RestCliCommand {
        @Option(required=true, completer=CacheCompleter.class)
        String cache;
        @Option(required=true)
        String site;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, Resource resource) {
            return client.cache(this.cache).cancelPushState(this.site);
        }
    }

    @CommandDefinition(name="push-site-state", description="Starts pushing state to a site", activator=ConnectionActivator.class)
    public static class PushSiteState
    extends RestCliCommand {
        @Option(required=true, completer=CacheCompleter.class)
        String cache;
        @Option(required=true)
        String site;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, Resource resource) {
            return client.cache(this.cache).pushSiteState(this.site);
        }
    }

    @CommandDefinition(name="take-offline", description="Takes a site offline", activator=ConnectionActivator.class)
    public static class TakeOffline
    extends RestCliCommand {
        @Option(required=true, completer=CacheCompleter.class)
        String cache;
        @Option(required=true)
        String site;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, Resource resource) {
            return client.cache(this.cache).takeSiteOffline(this.site);
        }
    }

    @CommandDefinition(name="bring-online", description="Brings a site online", activator=ConnectionActivator.class)
    public static class BringOnline
    extends RestCliCommand {
        @Option(required=true, completer=CacheCompleter.class)
        String cache;
        @Option(required=true)
        String site;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, Resource resource) {
            return client.cache(this.cache).bringSiteOnline(this.site);
        }
    }

    @CommandDefinition(name="status", description="Shows site status", activator=ConnectionActivator.class)
    public static class Status
    extends RestCliCommand {
        @Option(required=true, completer=CacheCompleter.class)
        String cache;
        @Option
        String site;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, Resource resource) {
            return this.site == null ? client.cache(this.cache).xsiteBackups() : client.cache(this.cache).backupStatus(this.site);
        }
    }
}

