/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands;

import java.util.List;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.GroupCommandDefinition;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.aesh.command.option.OptionList;
import org.infinispan.cli.commands.CliCommand;
import org.infinispan.cli.completers.EncryptionAlgorithmCompleter;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;
import org.infinispan.cli.logging.Messages;
import org.infinispan.cli.user.UserTool;
import org.infinispan.commons.dataconversion.internal.Json;

@GroupCommandDefinition(name="user", description="User operations", groupCommands={Create.class, Describe.class, Remove.class, Password.class, Groups.class, Ls.class, Encrypt.class})
public class User
extends CliCommand {
    @Option(shortName=104, hasValue=false, overrideRequired=true)
    protected boolean help;

    @Override
    public boolean isHelp() {
        return this.help;
    }

    @Override
    public CommandResult exec(ContextAwareCommandInvocation invocation) {
        invocation.println(invocation.getHelpInfo());
        return CommandResult.FAILURE;
    }

    @CommandDefinition(name="encrypt-all", description="Encrypts all of the passwords in a property file.")
    public static class Encrypt
    extends CliCommand {
        @Option(description="The path of the users.properties file", name="users-file", shortName=102)
        String usersFile;
        @Option(description="The path of the groups.properties file", name="groups-file", shortName=119)
        String groupsFile;
        @Option(description="The server root", defaultValue={"server"}, name="server-root", shortName=115)
        String serverRoot;
        @OptionList(description="The algorithms used to encrypt the password", shortName=97, completer=EncryptionAlgorithmCompleter.class)
        List<String> algorithms;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        public CommandResult exec(ContextAwareCommandInvocation invocation) {
            UserTool userTool = new UserTool(this.serverRoot, this.usersFile, this.groupsFile);
            userTool.encryptAll(this.algorithms);
            return CommandResult.SUCCESS;
        }
    }

    @CommandDefinition(name="ls", description="Lists all users/groups")
    public static class Ls
    extends CliCommand {
        @Option(description="Whether to list all unique groups instead of users", shortName=103, hasValue=false)
        boolean groups;
        @Option(description="The path of the users.properties file", name="users-file", shortName=102)
        String usersFile;
        @Option(description="The path of the groups.properties file", name="groups-file", shortName=119)
        String groupsFile;
        @Option(description="The server root", defaultValue={"server"}, name="server-root", shortName=115)
        String serverRoot;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        public CommandResult exec(ContextAwareCommandInvocation invocation) throws CommandException {
            UserTool userTool = new UserTool(this.serverRoot, this.usersFile, this.groupsFile);
            List<String> items = this.groups ? userTool.listGroups() : userTool.listUsers();
            invocation.getShell().writeln(Json.make(items).toString());
            return CommandResult.SUCCESS;
        }
    }

    @CommandDefinition(name="groups", description="Sets a user's groups")
    public static class Groups
    extends CliCommand {
        @Argument(description="The username for the user", required=true)
        String username;
        @OptionList(description="The groups the user should belong to", shortName=103, required=true)
        List<String> groups;
        @Option(description="The path of the users.properties file", name="users-file", shortName=102)
        String usersFile;
        @Option(description="The path of the groups.properties file", name="groups-file", shortName=119)
        String groupsFile;
        @Option(description="The server root", defaultValue={"server"}, name="server-root", shortName=115)
        String serverRoot;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        public CommandResult exec(ContextAwareCommandInvocation invocation) throws CommandException {
            UserTool userTool = new UserTool(this.serverRoot, this.usersFile, this.groupsFile);
            userTool.modifyUser(this.username, null, null, UserTool.Encryption.DEFAULT, this.groups, null);
            return CommandResult.SUCCESS;
        }
    }

    @CommandDefinition(name="password", description="Changes a user's password")
    public static class Password
    extends CliCommand {
        @Argument(description="The username for the user", required=true)
        String username;
        @Option(description="The password for the user", shortName=112)
        String password;
        @Option(description="The realm ", defaultValue={"default"}, shortName=114)
        String realm;
        @OptionList(description="The algorithms used to encrypt the password", shortName=97, completer=EncryptionAlgorithmCompleter.class)
        List<String> algorithms;
        @Option(description="Whether the password should be stored in plain text", name="plain-text", hasValue=false)
        boolean plainText;
        @Option(description="The path of the users.properties file", name="users-file", shortName=102)
        String usersFile;
        @Option(description="The path of the groups.properties file", name="groups-file", shortName=119)
        String groupsFile;
        @Option(description="The server root", defaultValue={"server"}, name="server-root", shortName=115)
        String serverRoot;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        public CommandResult exec(ContextAwareCommandInvocation invocation) {
            if (this.password == null) {
                try {
                    this.password = invocation.getPasswordInteractively(Messages.MSG.userToolPassword(), Messages.MSG.userToolPasswordConfirm());
                }
                catch (InterruptedException e) {
                    return CommandResult.FAILURE;
                }
            }
            UserTool userTool = new UserTool(this.serverRoot, this.usersFile, this.groupsFile);
            userTool.modifyUser(this.username, this.password, this.realm, UserTool.Encryption.valueOf(this.plainText), null, this.algorithms);
            return CommandResult.SUCCESS;
        }
    }

    @CommandDefinition(name="remove", description="Removes a user", aliases={"rm"})
    public static class Remove
    extends CliCommand {
        @Argument(description="The username for the user", required=true)
        String username;
        @Option(description="The path of the users.properties file", name="users-file", shortName=102)
        String usersFile;
        @Option(description="The path of the groups.properties file", name="groups-file", shortName=119)
        String groupsFile;
        @Option(description="The server root", defaultValue={"server"}, name="server-root", shortName=115)
        String serverRoot;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        public CommandResult exec(ContextAwareCommandInvocation invocation) throws CommandException {
            UserTool userTool = new UserTool(this.serverRoot, this.usersFile, this.groupsFile);
            userTool.removeUser(this.username);
            return CommandResult.SUCCESS;
        }
    }

    @CommandDefinition(name="describe", description="Describes a user")
    public static class Describe
    extends CliCommand {
        @Argument(description="The username for the user", required=true)
        String username;
        @Option(description="The path of the users.properties file", name="users-file", shortName=102)
        String usersFile;
        @Option(description="The path of the groups.properties file", name="groups-file", shortName=119)
        String groupsFile;
        @Option(description="The server root", defaultValue={"server"}, name="server-root", shortName=115)
        String serverRoot;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        public CommandResult exec(ContextAwareCommandInvocation invocation) throws CommandException {
            UserTool userTool = new UserTool(this.serverRoot, this.usersFile, this.groupsFile);
            invocation.getShell().writeln(userTool.describeUser(this.username));
            return CommandResult.SUCCESS;
        }
    }

    @CommandDefinition(name="create", description="Creates a user", aliases={"add"})
    public static class Create
    extends CliCommand {
        @Argument(description="The username for the user")
        String username;
        @Option(description="The password for the user", shortName=112)
        String password;
        @Option(description="The realm ", defaultValue={"default"}, shortName=114)
        String realm;
        @OptionList(description="The algorithms used to encrypt the password", shortName=97, completer=EncryptionAlgorithmCompleter.class)
        List<String> algorithms;
        @OptionList(description="The groups the user should belong to", shortName=103)
        List<String> groups;
        @Option(description="Whether the password should be stored in plain text (not recommended)", name="plain-text", hasValue=false)
        boolean plainText;
        @Option(description="The path of the users.properties file", name="users-file", shortName=102)
        String usersFile;
        @Option(description="The path of the groups.properties file", name="groups-file", shortName=119)
        String groupsFile;
        @Option(description="The server root", defaultValue={"server"}, name="server-root", shortName=115)
        String serverRoot;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        public CommandResult exec(ContextAwareCommandInvocation invocation) throws CommandException {
            UserTool userTool = new UserTool(this.serverRoot, this.usersFile, this.groupsFile);
            try {
                while (this.username == null || this.username.isEmpty()) {
                    this.username = invocation.getShell().readLine(Messages.MSG.userToolUsername());
                }
            }
            catch (InterruptedException e) {
                return CommandResult.FAILURE;
            }
            if (this.password == null) {
                try {
                    this.password = invocation.getPasswordInteractively(Messages.MSG.userToolPassword(), Messages.MSG.userToolPasswordConfirm());
                }
                catch (InterruptedException e) {
                    return CommandResult.FAILURE;
                }
            }
            userTool.createUser(this.username, this.password, this.realm, UserTool.Encryption.valueOf(this.plainText), this.groups, this.algorithms);
            return CommandResult.SUCCESS;
        }
    }
}

