/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.man.AeshFileDisplayer;
import org.aesh.command.man.FileParser;
import org.aesh.command.man.TerminalPage;
import org.aesh.command.man.parser.ManFileParser;
import org.aesh.command.option.Arguments;
import org.aesh.command.settings.ManProvider;
import org.aesh.command.shell.Shell;
import org.aesh.readline.terminal.formatting.TerminalString;
import org.aesh.readline.util.Parser;
import org.aesh.terminal.utils.ANSI;
import org.aesh.terminal.utils.Config;
import org.infinispan.cli.completers.HelpCompleter;
import org.infinispan.cli.impl.CliManProvider;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;

@CommandDefinition(name="help", description="Displays help for commands")
public class Help
extends AeshFileDisplayer {
    @Arguments(completer=HelpCompleter.class)
    private final List<String> manPages;
    private final ManFileParser fileParser;
    private final ManProvider manProvider = new CliManProvider();

    public Help() {
        this.manPages = new ArrayList<String>();
        this.fileParser = new ManFileParser();
    }

    public FileParser getFileParser() {
        return this.fileParser;
    }

    public void displayBottom() throws IOException {
        if (this.getSearchStatus() == TerminalPage.Search.SEARCHING) {
            this.clearBottomLine();
            this.writeToConsole("/" + this.getSearchWord());
        } else if (this.getSearchStatus() == TerminalPage.Search.NOT_FOUND) {
            this.clearBottomLine();
            this.writeToConsole(ANSI.INVERT_BACKGROUND + "Pattern not found (press RETURN)" + "\u001b[0;39m");
        } else if (this.getSearchStatus() == TerminalPage.Search.NO_SEARCH || this.getSearchStatus() == TerminalPage.Search.RESULT) {
            this.writeToConsole(ANSI.INVERT_BACKGROUND);
            this.writeToConsole("Manual page " + this.fileParser.getName() + " line " + this.getTopVisibleRow() + " (press h for help or q to quit)" + "\u001b[0;39m");
        }
    }

    public CommandResult execute(CommandInvocation commandInvocation) throws CommandException, InterruptedException {
        Shell shell = commandInvocation.getShell();
        if (this.manPages == null || this.manPages.size() == 0) {
            shell.writeln("Call `help <command>` where command is one of:");
            List commandNames = ((ContextAwareCommandInvocation)commandInvocation).getContext().getRegistry().getAllCommandNames().stream().map(n -> new TerminalString(n)).collect(Collectors.toList());
            shell.write(Parser.formatDisplayListTerminalString(commandNames, (int)shell.size().getHeight(), (int)shell.size().getWidth()));
            shell.writeln("");
            return CommandResult.SUCCESS;
        }
        if (this.manPages.size() <= 0) {
            shell.write("No manual entry for " + this.manPages.get(0) + Config.getLineSeparator());
            return CommandResult.SUCCESS;
        }
        if (this.manProvider == null) {
            shell.write("No manual provider defined");
            return CommandResult.SUCCESS;
        }
        InputStream inputStream = this.manProvider.getManualDocument(this.manPages.get(0));
        if (inputStream != null) {
            this.setCommandInvocation(commandInvocation);
            try {
                this.fileParser.setInput(inputStream);
                this.afterAttach();
            }
            catch (IOException ex) {
                throw new CommandException((Throwable)ex);
            }
        }
        return CommandResult.SUCCESS;
    }
}

