/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.benchmark;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.rest.RestCacheClient;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.RestURI;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.util.Util;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.infra.Blackhole;

@State(value=Scope.Thread)
public class HttpBenchmark {
    private static final long BIG_DELAY_NANOS = TimeUnit.DAYS.toNanos(1L);
    RestClient client;
    RestCacheClient cache;
    @Param(value={"http://127.0.0.1"})
    public String uri;
    @Param(value={"benchmark"})
    public String cacheName;
    @Param(value={""})
    public String cacheTemplate;
    @Param(value={"16"})
    public int keySize;
    @Param(value={"1000"})
    public int valueSize;
    @Param(value={"1000"})
    public int keySetSize;
    RestEntity value;
    List<String> keySet;
    AtomicInteger nextIndex;

    /*
     * Unable to fully structure code
     */
    @Setup
    public void setup() {
        uri = RestURI.create((String)this.uri);
        builder = uri.toConfigurationBuilder();
        this.client = RestClient.forConfiguration((RestClientConfiguration)builder.build());
        this.cache = this.client.cache(this.cacheName);
        response = (RestResponse)HttpBenchmark.uncheckedAwait(this.cache.exists());
        try {
            switch (response.getStatus()) {
                case 200: 
                case 204: {
                    ** break;
lbl10:
                    // 1 sources

                    break;
                }
                case 404: {
                    throw new IllegalArgumentException("Could not find cache '" + this.cacheName + "'");
                }
                case 401: {
                    throw new SecurityException(response.getBody());
                }
                default: {
                    throw new RuntimeException(response.getBody());
                }
            }
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        this.value = RestEntity.create((MediaType)MediaType.APPLICATION_OCTET_STREAM, (byte[])new byte[this.valueSize]);
        this.keySet = new ArrayList<String>(this.keySetSize);
        r = new Random(17L);
        keyBytes = new byte[this.keySize / 2];
        for (i = 0; i < this.keySetSize; ++i) {
            r.nextBytes(keyBytes);
            key = Util.toHexString((byte[])keyBytes);
            this.keySet.add(key);
            this.cache.put(key, this.value);
        }
        this.nextIndex = new AtomicInteger();
    }

    @Benchmark
    public void get(Blackhole bh) {
        try (RestResponse response = (RestResponse)HttpBenchmark.uncheckedAwait(this.cache.get(this.nextKey()));){
            bh.consume((Object)response.getBody());
        }
    }

    @Benchmark
    public void put() {
        Util.close((AutoCloseable)((AutoCloseable)HttpBenchmark.uncheckedAwait(this.cache.put(this.nextKey(), this.value))));
    }

    @TearDown
    public void teardown() {
        Util.close((AutoCloseable)this.client);
    }

    private String nextKey() {
        return this.keySet.get(this.nextIndex.getAndIncrement() % this.keySetSize);
    }

    public static <T> T uncheckedAwait(CompletionStage<T> future) {
        try {
            return Objects.requireNonNull(future, "Completable Future must be non-null.").toCompletableFuture().get(BIG_DELAY_NANOS, TimeUnit.NANOSECONDS);
        }
        catch (TimeoutException e) {
            throw new IllegalStateException("This should never happen!", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CacheException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new CacheException((Throwable)e);
        }
    }
}

