/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands.kubernetes;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ListVisitFromServerGetDeleteRecreateWaitApplicable;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandResult;
import org.aesh.command.option.Option;
import org.infinispan.cli.commands.CliCommand;
import org.infinispan.cli.commands.kubernetes.Kube;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;
import org.infinispan.cli.impl.KubernetesContextImpl;
import org.infinispan.commons.util.TypedProperties;

@CommandDefinition(name="install", description="Installs the operator")
public class Install
extends CliCommand {
    @Option(shortName=110, description="Select the namespace")
    String namespace;
    @Option(shortName=104, hasValue=false, overrideRequired=true)
    protected boolean help;

    @Override
    public boolean isHelp() {
        return this.help;
    }

    @Override
    public CommandResult exec(ContextAwareCommandInvocation invocation) {
        KubernetesClient client = ((KubernetesContextImpl)invocation.getContext()).getKubernetesClient();
        this.namespace = Kube.getNamespaceOrDefault(client, this.namespace);
        try {
            TypedProperties properties = new TypedProperties().setProperty("NAMESPACE", this.namespace);
            String crd = Kube.loadResourceAsString("/operator/operator-install.yaml", (Properties)properties);
            ((ListVisitFromServerGetDeleteRecreateWaitApplicable)client.load((InputStream)new ByteArrayInputStream(crd.getBytes(StandardCharsets.UTF_8))).inNamespace(this.namespace)).createOrReplace();
            crd = Kube.loadResourceAsString("/operator/operator-group.yaml", (Properties)properties);
            client.customResource(Kube.OPERATOR_OPERATORGROUP_CRD).createOrReplace(this.namespace, crd);
            crd = Kube.loadResourceAsString("/operator/operator-subscription.yaml", (Properties)properties);
            client.customResource(Kube.OPERATOR_SUBSCRIPTION_CRD).createOrReplace(this.namespace, crd);
            return CommandResult.SUCCESS;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

