/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands;

import org.aesh.command.Command;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;
import org.infinispan.commons.util.Util;

public abstract class CliCommand
implements Command<ContextAwareCommandInvocation> {
    public CommandResult execute(ContextAwareCommandInvocation invocation) throws CommandException {
        if (this.isHelp()) {
            invocation.println(invocation.getHelpInfo());
            return CommandResult.SUCCESS;
        }
        try {
            return this.exec(invocation);
        }
        catch (CommandException e) {
            Throwable cause = Util.getRootCause((Throwable)e);
            invocation.getShell().writeln("\u001b[0;31m" + e.getLocalizedMessage() + "\u001b[0;39m");
            if (cause != e) {
                invocation.getShell().writeln("\u001b[0;31m" + cause.getClass().getSimpleName() + ": " + cause.getLocalizedMessage() + "\u001b[0;39m");
            }
            return CommandResult.FAILURE;
        }
        catch (Throwable e) {
            Throwable cause = Util.getRootCause((Throwable)e);
            invocation.getShell().writeln("\u001b[0;31m" + cause.getClass().getSimpleName() + ": " + cause.getLocalizedMessage() + "\u001b[0;39m");
            return CommandResult.FAILURE;
        }
    }

    protected abstract boolean isHelp();

    protected abstract CommandResult exec(ContextAwareCommandInvocation var1) throws CommandException;

    public int nesting() {
        return 0;
    }
}

