/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands.kubernetes;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodStatus;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ExecListenable;
import io.fabric8.kubernetes.client.dsl.ExecListener;
import io.fabric8.kubernetes.client.dsl.Execable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.TtyExecErrorChannelable;
import io.fabric8.kubernetes.client.dsl.TtyExecErrorable;
import io.fabric8.kubernetes.client.dsl.TtyExecOutputErrorable;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import okhttp3.Response;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandResult;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.infinispan.cli.commands.CliCommand;
import org.infinispan.cli.commands.kubernetes.Kube;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;
import org.infinispan.cli.impl.KubernetesContextImpl;

@CommandDefinition(name="shell", description="Initiates an interactive shell with a service")
public class Shell
extends CliCommand {
    @Option(shortName=110, description="Select the namespace")
    String namespace;
    @Option(description="The name of the pod to connect to")
    String podName;
    @Option(shortName=104, hasValue=false, overrideRequired=true)
    protected boolean help;
    @Argument(description="The name of the service to connect to", defaultValue={"infinispan"})
    String name;

    @Override
    public boolean isHelp() {
        return this.help;
    }

    @Override
    public CommandResult exec(ContextAwareCommandInvocation invocation) {
        KubernetesClient client = ((KubernetesContextImpl)invocation.getContext()).getKubernetesClient();
        this.namespace = Kube.getNamespaceOrDefault(client, this.namespace);
        if (this.podName == null) {
            List pods = ((PodList)((FilterWatchListDeletable)((NonNamespaceOperation)client.pods().inNamespace(this.namespace)).withLabel("infinispan_cr", this.name)).list()).getItems();
            for (Pod pod : pods) {
                PodStatus status = pod.getStatus();
                if (!"Running".equalsIgnoreCase(status.getPhase())) continue;
                this.podName = pod.getMetadata().getName();
                break;
            }
        }
        if (this.podName == null) {
            System.err.printf("No running pods available in service %s\n", this.name);
        }
        LatchListener latchListener = new LatchListener();
        ((Execable)((ExecListenable)((TtyExecErrorChannelable)((TtyExecErrorable)((TtyExecOutputErrorable)((PodResource)((NonNamespaceOperation)client.pods().inNamespace(this.namespace)).withName(this.podName)).readingInput((Object)System.in)).writingOutput((Object)System.out)).writingError((Object)System.err)).withTTY()).usingListener((Object)latchListener)).exec((Object[])new String[]{"/opt/infinispan/bin/cli.sh"});
        try {
            latchListener.latch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return CommandResult.SUCCESS;
    }

    public static class LatchListener
    implements ExecListener {
        CountDownLatch latch = new CountDownLatch(1);

        public void onOpen(Response response) {
        }

        public void onFailure(Throwable t, Response response) {
            this.latch.countDown();
        }

        public void onClose(int code, String reason) {
            this.latch.countDown();
        }
    }
}

