/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands.rest;

import java.io.File;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.aesh.command.CommandDefinition;
import org.aesh.command.impl.completer.FileOptionCompleter;
import org.aesh.command.option.Arguments;
import org.aesh.command.option.Option;
import org.aesh.io.Resource;
import org.infinispan.cli.activators.ConnectionActivator;
import org.infinispan.cli.commands.rest.RestCliCommand;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;
import org.infinispan.cli.logging.Messages;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.commons.dataconversion.MediaType;

@CommandDefinition(name="schema", description="Manipulates protobuf schemas", activator=ConnectionActivator.class)
public class Schema
extends RestCliCommand {
    @Arguments(required=true, description="The name of the schema")
    List<String> args;
    @Option(completer=FileOptionCompleter.class, shortName=117, description="The protobuf file to upload")
    Resource upload;
    @Option(shortName=104, hasValue=false, overrideRequired=true)
    protected boolean help;

    @Override
    public boolean isHelp() {
        return this.help;
    }

    @Override
    protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, org.infinispan.cli.resources.Resource resource) {
        if (this.upload != null && this.args.size() != 1) {
            throw Messages.MSG.illegalCommandArguments();
        }
        if (this.upload == null && this.args.size() != 2) {
            throw Messages.MSG.illegalCommandArguments();
        }
        if (this.upload == null) {
            return client.schemas().put(this.args.get(0), this.args.get(1));
        }
        return client.schemas().put(this.args.get(0), RestEntity.create((MediaType)MediaType.TEXT_PLAIN, (File)new File(this.upload.getAbsolutePath())));
    }
}

