/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.patching;

import java.nio.file.Path;
import java.nio.file.Paths;

public class ServerFile {
    private final Path directory;
    private final String filename;
    private final String basename;
    private final String digest;
    private final String permissions;
    private final boolean soft;

    public ServerFile(Path path, String digest, String permissions, boolean soft) {
        this.directory = path.getParent();
        this.filename = path.getFileName().toString();
        this.basename = ServerFile.basename(this.filename);
        this.digest = digest;
        this.permissions = permissions;
        this.soft = soft;
    }

    public String toString() {
        return "ServerFile{directory=" + this.directory + ", filename='" + this.filename + '\'' + ", basename='" + this.basename + '\'' + ", permissions='" + this.permissions + '\'' + ", soft=" + this.soft + '}';
    }

    private static String basename(String filename) {
        filename = filename.replace("-linux-x86_64", "");
        int l = filename.length();
        for (int i = 0; i < l; ++i) {
            char c = filename.charAt(i);
            if (c != '-' || i >= l - 1 || (c = filename.charAt(i + 1)) < '0' || c > '9') continue;
            return filename.substring(0, i);
        }
        return filename;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getDigest() {
        return this.digest;
    }

    public String getPermissions() {
        return this.permissions;
    }

    Path getVersionedPath() {
        return this.directory != null ? this.directory.resolve(this.filename) : Paths.get(this.filename, new String[0]);
    }

    Path getUnversionedPath() {
        return this.directory != null ? this.directory.resolve(this.basename) : Paths.get(this.basename, new String[0]);
    }

    public boolean isSoft() {
        return this.soft;
    }
}

