/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands.kubernetes;

import io.fabric8.kubernetes.client.KubernetesClient;
import java.io.IOException;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandResult;
import org.aesh.command.GroupCommandDefinition;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.infinispan.cli.commands.CliCommand;
import org.infinispan.cli.commands.kubernetes.Kube;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;
import org.infinispan.cli.impl.KubernetesContextImpl;

@GroupCommandDefinition(name="delete", description="Deletes a resource", groupCommands={Cluster.class})
public class Delete
extends CliCommand {
    @Option(shortName=104, hasValue=false, overrideRequired=true)
    protected boolean help;

    @Override
    public boolean isHelp() {
        return this.help;
    }

    @Override
    public CommandResult exec(ContextAwareCommandInvocation invocation) {
        return CommandResult.FAILURE;
    }

    @CommandDefinition(name="cluster", description="Deletes a cluster")
    public static class Cluster
    extends CliCommand {
        @Option(shortName=110, description="Select the namespace")
        String namespace;
        @Argument(description="The name of the service to delete", defaultValue={"infinispan"})
        String name;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        public CommandResult exec(ContextAwareCommandInvocation invocation) {
            KubernetesClient client = ((KubernetesContextImpl)invocation.getContext()).getKubernetesClient();
            try {
                client.customResource(Kube.INFINISPAN_CLUSTER_CRD).delete(Kube.getNamespaceOrDefault(client, this.namespace), this.name);
                return CommandResult.SUCCESS;
            }
            catch (IOException e) {
                return CommandResult.FAILURE;
            }
        }
    }
}

