/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands.rest;

import java.io.File;
import java.util.concurrent.CompletionStage;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandResult;
import org.aesh.command.GroupCommandDefinition;
import org.aesh.command.impl.completer.FileOptionCompleter;
import org.aesh.command.option.Option;
import org.aesh.io.Resource;
import org.infinispan.cli.activators.ConnectionActivator;
import org.infinispan.cli.commands.CliCommand;
import org.infinispan.cli.commands.rest.RestCliCommand;
import org.infinispan.cli.completers.CacheCompleter;
import org.infinispan.cli.converters.NullableIntegerConverter;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;
import org.infinispan.cli.logging.Messages;
import org.infinispan.cli.resources.CacheResource;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestResponse;

@GroupCommandDefinition(name="migrate", description="Migration operations", groupCommands={Cluster.class})
public class Migrate
extends CliCommand {
    @Option(shortName=104, hasValue=false, overrideRequired=true)
    protected boolean help;

    @Override
    public boolean isHelp() {
        return this.help;
    }

    @Override
    public CommandResult exec(ContextAwareCommandInvocation invocation) {
        invocation.println(invocation.getHelpInfo());
        return CommandResult.FAILURE;
    }

    @CommandDefinition(name="synchronize", description="Synchronizes data from a source to a target cluster")
    public static class ClusterSynchronize
    extends RestCliCommand {
        @Option(completer=CacheCompleter.class, shortName=99)
        String cache;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;
        @Option(shortName=98, name="read-batch", description="The amount of entries to process in a batch", converter=NullableIntegerConverter.class)
        Integer readBatch;
        @Option(shortName=116, description="The number of threads to use. Defaults to the number of cores on the server", converter=NullableIntegerConverter.class)
        Integer threads;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, org.infinispan.cli.resources.Resource resource) {
            return client.cache(this.cache != null ? this.cache : CacheResource.cacheName(resource)).synchronizeData(this.readBatch, this.threads);
        }
    }

    @CommandDefinition(name="disconnect", description="Disconnects from a source cluster")
    public static class ClusterDisconnect
    extends RestCliCommand {
        @Option(completer=CacheCompleter.class, shortName=99, description="The name of the cache.")
        String cache;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, org.infinispan.cli.resources.Resource resource) {
            return client.cache(this.cache != null ? this.cache : CacheResource.cacheName(resource)).disconnectSource();
        }
    }

    @CommandDefinition(name="connect", description="Connects to a source cluster")
    public static class ClusterConnect
    extends RestCliCommand {
        @Option(completer=CacheCompleter.class, shortName=99, description="The name of the cache.")
        String cache;
        @Option(completer=FileOptionCompleter.class, shortName=102, description="JSON containing a 'remote-store' element with the configuration")
        Resource file;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, org.infinispan.cli.resources.Resource resource) {
            if (this.file == null) {
                throw Messages.MSG.illegalCommandArguments();
            }
            RestEntity restEntity = RestEntity.create((File)new File(this.file.getAbsolutePath()));
            return client.cache(this.cache != null ? this.cache : CacheResource.cacheName(resource)).connectSource(restEntity);
        }
    }

    @GroupCommandDefinition(name="cluster", description="Performs data migration between clusters", groupCommands={ClusterConnect.class, ClusterDisconnect.class, ClusterSynchronize.class}, activator=ConnectionActivator.class)
    public static class Cluster
    extends CliCommand {
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        public CommandResult exec(ContextAwareCommandInvocation invocation) {
            invocation.println(invocation.getHelpInfo());
            return CommandResult.FAILURE;
        }
    }
}

