/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.logging;

import java.io.IOException;
import java.io.Serializable;
import java.net.ConnectException;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Locale;
import java.util.NoSuchElementException;
import org.aesh.command.CommandException;
import org.aesh.command.parser.RequiredOptionException;
import org.infinispan.cli.logging.Messages;
import org.infinispan.cli.patching.PatchInfo;
import org.infinispan.cli.patching.PatchOperation;
import org.infinispan.cli.user.UserTool;

public class Messages_$bundle
implements Messages,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final Messages_$bundle INSTANCE = new Messages_$bundle();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String username = "Username: ";
    private static final String password = "Password: ";
    private static final String cliHelpHelp = "Displays usage information and exits.";
    private static final String cliHelpVersion = "Displays version information and exits.";
    private static final String fileNotExists = "File '%s' doesn't exist or is not a file";
    private static final String cliHelpConnect = "Connects to a remote %s instance\n";
    private static final String cliHelpConnectHTTP = "Server HTTP http://[username[:password]]@host:port";
    private static final String cliHelpFile = "Reads input from the specified file instead of using interactive mode. If FILE is '-', then commands will be read from stdin.";
    private static final String cliHelpTruststorePassword = "The password of an optional truststore to be used for SSL/TLS connections.";
    private static final String cliHelpTruststore = "The path of an optional truststore to be used for SSL/TLS connections.";
    private static final String cliHelpTrustAll = "Trusts all certificates in SSL/TLS connections.";
    private static final String notFound = "Not Found: %s";
    private static final String unauthorized = "The supplied credentials are invalid %s";
    private static final String error = "Error: %s";
    private static final String genericError = "Error: %s";
    private static final String forbidden = "The user is not allowed to access the server resource: %s";
    private static final String keyStoreError = "Error while loading trust store '%s'";
    private static final String noSuchResource = "No such resource '%s'";
    private static final String illegalContext = "Command invoked from the wrong context";
    private static final String illegalCommandArguments = "Illegal arguments for command";
    private static final String mutuallyExclusiveOptions = "The options '%s' and '%s' are mutually exclusive";
    private static final String requiresOneOf = "One of the '%s' and '%s' options are required";
    private static final String connectionFailed = "Could not connect to server: %s";
    private static final String invalidResource = "Invalid resource '%s'";
    private static final String patchNoPatchesInstalled = "No patches installed";
    private static final String patchInfo = "%s";
    private static final String patchCannotApply = "The supplied patch cannot be applied to %s %s";
    private static final String patchShaMismatch = "File %s SHA mismatch. Expected = %s, Actual = %s";
    private static final String patchValidationErrors = "The following errors were encountered while validating the installation:%n%s";
    private static final String patchNoPatchesInstalledToRollback = "No installed patches to roll back";
    private static final String patchCannotFindCommons = "Cannot find the infinispan-commons jar under %s";
    private static final String patchIncompatibleProduct = "Cannot create patch %s with patches for %s";
    private static final String patchCannotWritePatchesFile = "Could not write patches file";
    private static final String patchRollback = "Rolled back patch %s";
    private static final String patchDryRun = "[Dry run] ";
    private static final String patchBackup = "Backing up '%s' to '%s'";
    private static final String patchCreateError = "Error while creating patch";
    private static final String patchCreateAdd = "Adding file '%s'";
    private static final String patchRollbackFile = "Rolling back file '%s'";
    private static final String patchCannotRead = "Could not read %s";
    private static final String patchFileAlreadyExists = "File '%s' already exists";
    private static final String patchCreateArgumentsRequired = "At least three arguments are required: the patch file, the target server path and one or more source server paths";
    private static final String patchArchiveArgumentRequired = "You must specify the path to a patch archive";
    private static final String patchServerAndTargetMustBeDifferent = "Cannot create a patch from identical source and target server versions: %s";
    private static final String patchCorruptArchive = "The patch archive appears to have a corrupt entry for: %s";
    private static final String downloadedFile = "Downloaded file '%s'";
    private static final String userToolUsername = "Specify a username: ";
    private static final String userToolPassword = "Set a password for the user: ";
    private static final String userToolPasswordConfirm = "Confirm the password for the user: ";
    private static final String userToolUserExists = "User `%s` already exists";
    private static final String userToolNoPassword = "Cannot add user `%s` without a password.";
    private static final String userToolIOError = "Error accessing file '%s'";
    private static final String userToolUnknownAlgorithm = "Unkown password encryption algorithm: '%s'";
    private static final String userToolNoSuchUser = "User `%s` does not exist";
    private static final String userDescribe = "{ username: \"%s\", realm: \"%s\", groups = %s }";
    private static final String invalidUnicodeSequence = "Invalid Unicode sequence '%s'";
    private static final String userToolIncompatibleEncrypyion = "Attempt to use %s passwords, but only %s passwords are allowed";
    private static final String userToolWrongRealm = "Attempted to use a different realm '%s' than the already existing one '%s'";
    private static final String configLoadFailed = "Unable to load CLI configuration from `%s`. Using defaults.";
    private static final String configStoreFailed = "Unable to store CLI configuration to '%s'.";
    private static final String wrongArgumentCount = "Wrong argument count: %d.";
    private static final String backupAbsolutePathRequired = "Backup path on the server must be absolute";
    private static final String noServicesFound = "No services found";
    private static final String specifyService = "The service must be specified";
    private static final String wrongServiceType = "The service '%s' is of the wrong type";
    private static final String noSuchService = "Cannot find service '%s'";
    private static final String noGeneratedSecret = "Cannot find generated secrets for service '%s'";
    private static final String noDefaultNamespace = "A namespace was not specified and a default has not been set";
    private static final String credentialToolPassword = "Enter the password for the credential keystore: ";
    private static final String credentialToolPasswordConfirm = "Confirm the password for the credential store: ";
    private static final String credentialToolCredential = "Set a credential for the alias: ";
    private static final String credentialToolCredentialConfirm = "Confirm the credential: ";
    private static final String illegalFilterRule = "Filter rule '%s' is not in the format [ACCEPT|REJECT]/{CIDR}";
    private static final String batchError = "Error executing line %d: '%s'";
    private static final String requiresAllOf = "Option '%s' requires option '%s'";
    private static final String missingCacheName = "The cache name is required";

    protected Messages_$bundle() {
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String username$str() {
        return username;
    }

    @Override
    public final String username() {
        return String.format(this.getLoggingLocale(), this.username$str(), new Object[0]);
    }

    protected String password$str() {
        return password;
    }

    @Override
    public final String password() {
        return String.format(this.getLoggingLocale(), this.password$str(), new Object[0]);
    }

    protected String cliHelpHelp$str() {
        return cliHelpHelp;
    }

    @Override
    public final String cliHelpHelp() {
        return String.format(this.getLoggingLocale(), this.cliHelpHelp$str(), new Object[0]);
    }

    protected String cliHelpVersion$str() {
        return cliHelpVersion;
    }

    @Override
    public final String cliHelpVersion() {
        return String.format(this.getLoggingLocale(), this.cliHelpVersion$str(), new Object[0]);
    }

    protected String fileNotExists$str() {
        return fileNotExists;
    }

    @Override
    public final String fileNotExists(String inputFile) {
        return String.format(this.getLoggingLocale(), this.fileNotExists$str(), inputFile);
    }

    protected String cliHelpConnect$str() {
        return cliHelpConnect;
    }

    @Override
    public final String cliHelpConnect(String brandName) {
        return String.format(this.getLoggingLocale(), this.cliHelpConnect$str(), brandName);
    }

    protected String cliHelpConnectHTTP$str() {
        return cliHelpConnectHTTP;
    }

    @Override
    public final String cliHelpConnectHTTP() {
        return String.format(this.getLoggingLocale(), this.cliHelpConnectHTTP$str(), new Object[0]);
    }

    protected String cliHelpFile$str() {
        return cliHelpFile;
    }

    @Override
    public final String cliHelpFile() {
        return String.format(this.getLoggingLocale(), this.cliHelpFile$str(), new Object[0]);
    }

    protected String cliHelpTruststorePassword$str() {
        return cliHelpTruststorePassword;
    }

    @Override
    public final String cliHelpTruststorePassword() {
        return String.format(this.getLoggingLocale(), this.cliHelpTruststorePassword$str(), new Object[0]);
    }

    protected String cliHelpTruststore$str() {
        return cliHelpTruststore;
    }

    @Override
    public final String cliHelpTruststore() {
        return String.format(this.getLoggingLocale(), this.cliHelpTruststore$str(), new Object[0]);
    }

    protected String cliHelpTrustAll$str() {
        return cliHelpTrustAll;
    }

    @Override
    public final String cliHelpTrustAll() {
        return String.format(this.getLoggingLocale(), this.cliHelpTrustAll$str(), new Object[0]);
    }

    protected String notFound$str() {
        return notFound;
    }

    @Override
    public final IOException notFound(String s) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.notFound$str(), s));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unauthorized$str() {
        return unauthorized;
    }

    @Override
    public final AccessDeniedException unauthorized(String s) {
        AccessDeniedException result = new AccessDeniedException(String.format(this.getLoggingLocale(), this.unauthorized$str(), s));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String error$str() {
        return "Error: %s";
    }

    @Override
    public final IOException error(String s) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.error$str(), s));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String genericError$str() {
        return "Error: %s";
    }

    @Override
    public final RuntimeException genericError(String s, Throwable t) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.genericError$str(), s), t);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String forbidden$str() {
        return forbidden;
    }

    @Override
    public final AccessDeniedException forbidden(String s) {
        AccessDeniedException result = new AccessDeniedException(String.format(this.getLoggingLocale(), this.forbidden$str(), s));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String keyStoreError$str() {
        return keyStoreError;
    }

    @Override
    public final String keyStoreError(String trustStorePath, Exception e) {
        return String.format(this.getLoggingLocale(), this.keyStoreError$str(), trustStorePath);
    }

    protected String noSuchResource$str() {
        return noSuchResource;
    }

    @Override
    public final IllegalArgumentException noSuchResource(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.noSuchResource$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String illegalContext$str() {
        return illegalContext;
    }

    @Override
    public final IllegalStateException illegalContext() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.illegalContext$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String illegalCommandArguments$str() {
        return illegalCommandArguments;
    }

    @Override
    public final IllegalArgumentException illegalCommandArguments() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalCommandArguments$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mutuallyExclusiveOptions$str() {
        return mutuallyExclusiveOptions;
    }

    @Override
    public final IllegalArgumentException mutuallyExclusiveOptions(String arg1, String arg2) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.mutuallyExclusiveOptions$str(), arg1, arg2));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String requiresOneOf$str() {
        return requiresOneOf;
    }

    @Override
    public final RequiredOptionException requiresOneOf(String arg1, String arg2) {
        RequiredOptionException result = new RequiredOptionException(String.format(this.getLoggingLocale(), this.requiresOneOf$str(), arg1, arg2));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String connectionFailed$str() {
        return connectionFailed;
    }

    @Override
    public final ConnectException connectionFailed(String message) {
        ConnectException result = new ConnectException(String.format(this.getLoggingLocale(), this.connectionFailed$str(), message));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidResource$str() {
        return invalidResource;
    }

    @Override
    public final IllegalArgumentException invalidResource(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidResource$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String patchNoPatchesInstalled$str() {
        return patchNoPatchesInstalled;
    }

    @Override
    public final String patchNoPatchesInstalled() {
        return String.format(this.getLoggingLocale(), this.patchNoPatchesInstalled$str(), new Object[0]);
    }

    protected String patchInfo$str() {
        return patchInfo;
    }

    @Override
    public final String patchInfo(PatchInfo patchInfo) {
        return String.format(this.getLoggingLocale(), this.patchInfo$str(), patchInfo);
    }

    protected String patchCannotApply$str() {
        return patchCannotApply;
    }

    @Override
    public final IllegalStateException patchCannotApply(String brandName, String version) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.patchCannotApply$str(), brandName, version));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String patchShaMismatch$str() {
        return patchShaMismatch;
    }

    @Override
    public final String patchShaMismatch(Path path, String digest, String sha256) {
        return String.format(this.getLoggingLocale(), this.patchShaMismatch$str(), path, digest, sha256);
    }

    protected String patchValidationErrors$str() {
        return patchValidationErrors;
    }

    @Override
    public final IllegalStateException patchValidationErrors(String errors) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.patchValidationErrors$str(), errors));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String patchNoPatchesInstalledToRollback$str() {
        return patchNoPatchesInstalledToRollback;
    }

    @Override
    public final IllegalStateException patchNoPatchesInstalledToRollback() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.patchNoPatchesInstalledToRollback$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String patchCannotFindCommons$str() {
        return patchCannotFindCommons;
    }

    @Override
    public final IllegalStateException patchCannotFindCommons(Path lib) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.patchCannotFindCommons$str(), lib));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String patchIncompatibleProduct$str() {
        return patchIncompatibleProduct;
    }

    @Override
    public final IllegalStateException patchIncompatibleProduct(String localBrand, String patchBrand) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.patchIncompatibleProduct$str(), localBrand, patchBrand));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String patchCannotWritePatchesFile$str() {
        return patchCannotWritePatchesFile;
    }

    @Override
    public final IllegalStateException patchCannotWritePatchesFile(IOException e) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.patchCannotWritePatchesFile$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String patchRollback$str() {
        return patchRollback;
    }

    @Override
    public final String patchRollback(PatchInfo patchInfo) {
        return String.format(this.getLoggingLocale(), this.patchRollback$str(), patchInfo);
    }

    protected String patchDryRun$str() {
        return patchDryRun;
    }

    @Override
    public final String patchDryRun() {
        return String.format(this.getLoggingLocale(), this.patchDryRun$str(), new Object[0]);
    }

    protected String patchBackup$str() {
        return patchBackup;
    }

    @Override
    public final String patchBackup(Path from, Path to) {
        return String.format(this.getLoggingLocale(), this.patchBackup$str(), from, to);
    }

    protected String patchCreateError$str() {
        return patchCreateError;
    }

    @Override
    public final RuntimeException patchCreateError(IOException e) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.patchCreateError$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String patchCreateAdd$str() {
        return patchCreateAdd;
    }

    @Override
    public final String patchCreateAdd(Path target) {
        return String.format(this.getLoggingLocale(), this.patchCreateAdd$str(), target);
    }

    protected String patchRollbackFile$str() {
        return patchRollbackFile;
    }

    @Override
    public final String patchRollbackFile(Path file) {
        return String.format(this.getLoggingLocale(), this.patchRollbackFile$str(), file);
    }

    protected String patchCannotRead$str() {
        return patchCannotRead;
    }

    @Override
    public final IllegalStateException patchCannotRead(Path patchesFile, IOException e) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.patchCannotRead$str(), patchesFile), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String patchFileAlreadyExists$str() {
        return patchFileAlreadyExists;
    }

    @Override
    public final FileAlreadyExistsException patchFileAlreadyExists(Path patch) {
        FileAlreadyExistsException result = new FileAlreadyExistsException(String.format(this.getLoggingLocale(), this.patchFileAlreadyExists$str(), patch));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String patchCreateArgumentsRequired$str() {
        return patchCreateArgumentsRequired;
    }

    @Override
    public final IllegalArgumentException patchCreateArgumentsRequired() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.patchCreateArgumentsRequired$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String patchArchiveArgumentRequired$str() {
        return patchArchiveArgumentRequired;
    }

    @Override
    public final IllegalArgumentException patchArchiveArgumentRequired() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.patchArchiveArgumentRequired$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String patchServerAndTargetMustBeDifferent$str() {
        return patchServerAndTargetMustBeDifferent;
    }

    @Override
    public final IllegalArgumentException patchServerAndTargetMustBeDifferent(String version) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.patchServerAndTargetMustBeDifferent$str(), version));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String patchCorruptArchive$str() {
        return patchCorruptArchive;
    }

    @Override
    public final String patchCorruptArchive(PatchOperation operation) {
        return String.format(this.getLoggingLocale(), this.patchCorruptArchive$str(), operation);
    }

    protected String downloadedFile$str() {
        return downloadedFile;
    }

    @Override
    public final String downloadedFile(String filename) {
        return String.format(this.getLoggingLocale(), this.downloadedFile$str(), filename);
    }

    protected String userToolUsername$str() {
        return userToolUsername;
    }

    @Override
    public final String userToolUsername() {
        return String.format(this.getLoggingLocale(), this.userToolUsername$str(), new Object[0]);
    }

    protected String userToolPassword$str() {
        return userToolPassword;
    }

    @Override
    public final String userToolPassword() {
        return String.format(this.getLoggingLocale(), this.userToolPassword$str(), new Object[0]);
    }

    protected String userToolPasswordConfirm$str() {
        return userToolPasswordConfirm;
    }

    @Override
    public final String userToolPasswordConfirm() {
        return String.format(this.getLoggingLocale(), this.userToolPasswordConfirm$str(), new Object[0]);
    }

    protected String userToolUserExists$str() {
        return userToolUserExists;
    }

    @Override
    public final IllegalStateException userToolUserExists(String username) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.userToolUserExists$str(), username));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String userToolNoPassword$str() {
        return userToolNoPassword;
    }

    @Override
    public final String userToolNoPassword(String username) {
        return String.format(this.getLoggingLocale(), this.userToolNoPassword$str(), username);
    }

    protected String userToolIOError$str() {
        return userToolIOError;
    }

    @Override
    public final RuntimeException userToolIOError(Path path, IOException e) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.userToolIOError$str(), path), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String userToolUnknownAlgorithm$str() {
        return userToolUnknownAlgorithm;
    }

    @Override
    public final IllegalArgumentException userToolUnknownAlgorithm(String algorithm) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.userToolUnknownAlgorithm$str(), algorithm));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String userToolNoSuchUser$str() {
        return userToolNoSuchUser;
    }

    @Override
    public final IllegalArgumentException userToolNoSuchUser(String username) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.userToolNoSuchUser$str(), username));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String userDescribe$str() {
        return userDescribe;
    }

    @Override
    public final String userDescribe(String username, String realm, String[] userGroups) {
        return String.format(this.getLoggingLocale(), this.userDescribe$str(), username, realm, Arrays.toString(userGroups));
    }

    protected String invalidUnicodeSequence$str() {
        return invalidUnicodeSequence;
    }

    @Override
    public final IOException invalidUnicodeSequence(String sequence, NoSuchElementException e) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.invalidUnicodeSequence$str(), sequence), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String userToolIncompatibleEncrypyion$str() {
        return userToolIncompatibleEncrypyion;
    }

    @Override
    public final IllegalArgumentException userToolIncompatibleEncrypyion(UserTool.Encryption encryption1, UserTool.Encryption encryption2) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.userToolIncompatibleEncrypyion$str(), new Object[]{encryption1, encryption2}));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String userToolWrongRealm$str() {
        return userToolWrongRealm;
    }

    @Override
    public final IllegalArgumentException userToolWrongRealm(String realm1, String realm2) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.userToolWrongRealm$str(), realm1, realm2));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String configLoadFailed$str() {
        return configLoadFailed;
    }

    @Override
    public final String configLoadFailed(String path) {
        return String.format(this.getLoggingLocale(), this.configLoadFailed$str(), path);
    }

    protected String configStoreFailed$str() {
        return configStoreFailed;
    }

    @Override
    public final String configStoreFailed(String path) {
        return String.format(this.getLoggingLocale(), this.configStoreFailed$str(), path);
    }

    protected String wrongArgumentCount$str() {
        return wrongArgumentCount;
    }

    @Override
    public final IllegalArgumentException wrongArgumentCount(int size) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.wrongArgumentCount$str(), size));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String backupAbsolutePathRequired$str() {
        return backupAbsolutePathRequired;
    }

    @Override
    public final IllegalArgumentException backupAbsolutePathRequired() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.backupAbsolutePathRequired$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noServicesFound$str() {
        return noServicesFound;
    }

    @Override
    public final NoSuchElementException noServicesFound() {
        NoSuchElementException result = new NoSuchElementException(String.format(this.getLoggingLocale(), this.noServicesFound$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String specifyService$str() {
        return specifyService;
    }

    @Override
    public final IllegalStateException specifyService() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.specifyService$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String wrongServiceType$str() {
        return wrongServiceType;
    }

    @Override
    public final IllegalArgumentException wrongServiceType(String serviceName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.wrongServiceType$str(), serviceName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noSuchService$str() {
        return noSuchService;
    }

    @Override
    public final IllegalArgumentException noSuchService(String serviceName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.noSuchService$str(), serviceName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noGeneratedSecret$str() {
        return noGeneratedSecret;
    }

    @Override
    public final IllegalStateException noGeneratedSecret(String serviceName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.noGeneratedSecret$str(), serviceName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noDefaultNamespace$str() {
        return noDefaultNamespace;
    }

    @Override
    public final IllegalStateException noDefaultNamespace() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.noDefaultNamespace$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String credentialToolPassword$str() {
        return credentialToolPassword;
    }

    @Override
    public final String credentialToolPassword() {
        return String.format(this.getLoggingLocale(), this.credentialToolPassword$str(), new Object[0]);
    }

    protected String credentialToolPasswordConfirm$str() {
        return credentialToolPasswordConfirm;
    }

    @Override
    public final String credentialToolPasswordConfirm() {
        return String.format(this.getLoggingLocale(), this.credentialToolPasswordConfirm$str(), new Object[0]);
    }

    protected String credentialToolCredential$str() {
        return credentialToolCredential;
    }

    @Override
    public final String credentialToolCredential() {
        return String.format(this.getLoggingLocale(), this.credentialToolCredential$str(), new Object[0]);
    }

    protected String credentialToolCredentialConfirm$str() {
        return credentialToolCredentialConfirm;
    }

    @Override
    public final String credentialToolCredentialConfirm() {
        return String.format(this.getLoggingLocale(), this.credentialToolCredentialConfirm$str(), new Object[0]);
    }

    protected String illegalFilterRule$str() {
        return illegalFilterRule;
    }

    @Override
    public final IllegalArgumentException illegalFilterRule(String rule) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalFilterRule$str(), rule));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String batchError$str() {
        return batchError;
    }

    @Override
    public final CommandException batchError(int lineNumber, String line, Throwable t) {
        CommandException result = new CommandException(String.format(this.getLoggingLocale(), this.batchError$str(), lineNumber, line), t);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String requiresAllOf$str() {
        return requiresAllOf;
    }

    @Override
    public final RequiredOptionException requiresAllOf(String option1, String option2) {
        RequiredOptionException result = new RequiredOptionException(String.format(this.getLoggingLocale(), this.requiresAllOf$str(), option1, option2));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String missingCacheName$str() {
        return missingCacheName;
    }

    @Override
    public final IllegalArgumentException missingCacheName() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.missingCacheName$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

