/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.Provider;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.aesh.command.AeshCommandRuntimeBuilder;
import org.aesh.command.Command;
import org.aesh.command.CommandNotFoundHandler;
import org.aesh.command.CommandResult;
import org.aesh.command.CommandRuntime;
import org.aesh.command.GroupCommandDefinition;
import org.aesh.command.activator.CommandActivatorProvider;
import org.aesh.command.completer.CompleterInvocationProvider;
import org.aesh.command.impl.completer.FileOptionCompleter;
import org.aesh.command.impl.registry.AeshCommandRegistryBuilder;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.invocation.CommandInvocationProvider;
import org.aesh.command.option.Option;
import org.aesh.command.option.OptionGroup;
import org.aesh.command.registry.CommandRegistry;
import org.aesh.command.registry.CommandRegistryException;
import org.aesh.command.settings.QuitHandler;
import org.aesh.command.settings.SettingsBuilder;
import org.aesh.command.shell.Shell;
import org.aesh.io.Resource;
import org.aesh.readline.AeshContext;
import org.aesh.readline.ReadlineConsole;
import org.aesh.readline.alias.AliasManager;
import org.infinispan.cli.Context;
import org.infinispan.cli.activators.ContextAwareCommandActivatorProvider;
import org.infinispan.cli.commands.Batch;
import org.infinispan.cli.commands.Benchmark;
import org.infinispan.cli.commands.Cache;
import org.infinispan.cli.commands.Cd;
import org.infinispan.cli.commands.Clear;
import org.infinispan.cli.commands.CliCommand;
import org.infinispan.cli.commands.Config;
import org.infinispan.cli.commands.Connect;
import org.infinispan.cli.commands.Container;
import org.infinispan.cli.commands.Counter;
import org.infinispan.cli.commands.Credentials;
import org.infinispan.cli.commands.Describe;
import org.infinispan.cli.commands.Disconnect;
import org.infinispan.cli.commands.Echo;
import org.infinispan.cli.commands.Encoding;
import org.infinispan.cli.commands.Ls;
import org.infinispan.cli.commands.Patch;
import org.infinispan.cli.commands.Run;
import org.infinispan.cli.commands.SecurityActions;
import org.infinispan.cli.commands.User;
import org.infinispan.cli.commands.Version;
import org.infinispan.cli.commands.kubernetes.Kube;
import org.infinispan.cli.commands.rest.Add;
import org.infinispan.cli.commands.rest.Alter;
import org.infinispan.cli.commands.rest.Availability;
import org.infinispan.cli.commands.rest.Backup;
import org.infinispan.cli.commands.rest.Cas;
import org.infinispan.cli.commands.rest.ClearCache;
import org.infinispan.cli.commands.rest.Create;
import org.infinispan.cli.commands.rest.Drop;
import org.infinispan.cli.commands.rest.Get;
import org.infinispan.cli.commands.rest.Logging;
import org.infinispan.cli.commands.rest.Migrate;
import org.infinispan.cli.commands.rest.Put;
import org.infinispan.cli.commands.rest.Query;
import org.infinispan.cli.commands.rest.Rebalance;
import org.infinispan.cli.commands.rest.Remove;
import org.infinispan.cli.commands.rest.Reset;
import org.infinispan.cli.commands.rest.Schema;
import org.infinispan.cli.commands.rest.Server;
import org.infinispan.cli.commands.rest.Shutdown;
import org.infinispan.cli.commands.rest.Site;
import org.infinispan.cli.commands.rest.Task;
import org.infinispan.cli.completers.ContextAwareCompleterInvocationProvider;
import org.infinispan.cli.impl.AeshDelegatingShell;
import org.infinispan.cli.impl.CliAliasManager;
import org.infinispan.cli.impl.CliCommandNotFoundHandler;
import org.infinispan.cli.impl.CliRuntimeRunner;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;
import org.infinispan.cli.impl.ContextAwareCommandInvocationProvider;
import org.infinispan.cli.impl.ContextAwareQuitHandler;
import org.infinispan.cli.impl.ContextImpl;
import org.infinispan.cli.impl.DefaultShell;
import org.infinispan.cli.impl.ExitCodeResultHandler;
import org.infinispan.cli.impl.KubernetesContext;
import org.infinispan.cli.impl.SSLContextSettings;
import org.infinispan.cli.logging.Messages;
import org.infinispan.cli.util.ZeroSecurityHostnameVerifier;
import org.infinispan.cli.util.ZeroSecurityTrustManager;
import org.infinispan.commons.jdkspecific.ProcessInfo;
import org.infinispan.commons.util.ServiceFinder;
import org.infinispan.commons.util.Util;
import org.wildfly.security.credential.store.WildFlyElytronCredentialStoreProvider;
import org.wildfly.security.keystore.KeyStoreUtil;
import org.wildfly.security.provider.util.ProviderUtil;

@GroupCommandDefinition(name="cli", description="", groupCommands={Add.class, Alter.class, Availability.class, Backup.class, Benchmark.class, Cache.class, Cas.class, Cd.class, Clear.class, ClearCache.class, Config.class, Connect.class, Container.class, Counter.class, Create.class, Credentials.class, Describe.class, Disconnect.class, Drop.class, Echo.class, Encoding.class, Get.class, Logging.class, Ls.class, Migrate.class, Patch.class, Put.class, Query.class, Rebalance.class, Remove.class, Reset.class, Run.class, Schema.class, Server.class, Shutdown.class, Site.class, Task.class, User.class, Version.class}, resultHandler=ExitCodeResultHandler.class)
public class CLI
extends CliCommand {
    private Context context;
    @Option(completer=FileOptionCompleter.class, shortName=116, name="truststore", description="A truststore to use when connecting to SSL/TLS-enabled servers")
    Resource truststore;
    @Option(shortName=115, name="truststore-password", description="The password for the truststore")
    String truststorePassword;
    @Option(shortName=118, hasValue=false, description="Shows version information")
    boolean version;
    @Option(hasValue=false, description="Whether to trust all certificates", name="trustall")
    boolean trustAll;
    @Option(completer=FileOptionCompleter.class, shortName=102, description="File for batch mode")
    Resource file;
    @Option(shortName=99, description="A connection URL. Use '-' to connect to http://localhost:11222")
    String connect;
    @Option(shortName=80, description="Sets system properties from the specified file.")
    String properties;
    @OptionGroup(shortName=68, description="Sets a system property")
    Map<String, String> propertyMap;
    @Option(shortName=104, hasValue=false, overrideRequired=true)
    protected boolean help;

    @Override
    public boolean isHelp() {
        return this.help;
    }

    @Override
    public CommandResult exec(ContextAwareCommandInvocation invocation) {
        String connectionString;
        block25: {
            String sslTrustStore;
            if (this.help) {
                invocation.println(invocation.getHelpInfo());
                return CommandResult.SUCCESS;
            }
            if (this.version) {
                invocation.printf("%s CLI %s\n", org.infinispan.commons.util.Version.getBrandName(), org.infinispan.commons.util.Version.getBrandVersion());
                invocation.printf("Copyright (C) Red Hat Inc. and/or its affiliates and other contributors\n", new Object[0]);
                invocation.printf("License Apache License, v. 2.0. http://www.apache.org/licenses/LICENSE-2.0\n", new Object[0]);
                return CommandResult.SUCCESS;
            }
            this.context = invocation.getContext();
            if (this.propertyMap != null) {
                this.propertyMap.forEach(this.context.getProperties()::putIfAbsent);
            }
            if (this.properties != null) {
                try (BufferedReader r = Files.newBufferedReader(Paths.get(this.properties, new String[0]));){
                    Properties loaded = new Properties();
                    loaded.load(r);
                    loaded.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)this.context.getProperties()::putIfAbsent));
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            String string = sslTrustStore = this.truststore != null ? this.truststore.getAbsolutePath() : this.context.getProperty(Context.Property.TRUSTSTORE);
            if (sslTrustStore != null) {
                String sslTrustStorePassword = this.truststorePassword != null ? this.truststorePassword : this.context.getProperty(Context.Property.TRUSTSTORE_PASSWORD);
                try (FileInputStream f = new FileInputStream(sslTrustStore);){
                    KeyStore keyStore = KeyStoreUtil.loadKeyStore((Supplier)ProviderUtil.INSTALLED_PROVIDERS, null, (FileInputStream)f, (String)sslTrustStore, (char[])(sslTrustStorePassword != null ? sslTrustStorePassword.toCharArray() : null));
                    TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    trustManagerFactory.init(keyStore);
                    SSLContextSettings sslContext = SSLContextSettings.getInstance("TLS", null, trustManagerFactory.getTrustManagers(), null, null);
                    this.context.setSslContext(sslContext);
                    break block25;
                }
                catch (Exception e) {
                    invocation.getShell().writeln(Messages.MSG.keyStoreError(sslTrustStore, e));
                    return CommandResult.FAILURE;
                }
            }
            if (this.trustAll || Boolean.parseBoolean(this.context.getProperty(Context.Property.TRUSTALL))) {
                SSLContextSettings sslContext = SSLContextSettings.getInstance("TLS", null, new TrustManager[]{new ZeroSecurityTrustManager()}, null, new ZeroSecurityHostnameVerifier());
                this.context.setSslContext(sslContext);
            }
        }
        String string = connectionString = this.connect != null ? this.connect : this.context.getProperty(Context.Property.AUTOCONNECT_URL);
        if (connectionString != null) {
            this.context.connect(null, connectionString);
        }
        if (this.file != null) {
            return this.batch(this.file.getAbsolutePath(), invocation.getShell());
        }
        if (this.context.getProperty(Context.Property.AUTOEXEC) != null) {
            this.batch(this.context.getProperty(Context.Property.AUTOEXEC), invocation.getShell());
        }
        return this.interactive(invocation.getShell());
    }

    private CommandResult batch(String inputFile, Shell shell) {
        CommandRegistry commandRegistry = this.initializeCommands(Batch.class);
        AeshCommandRuntimeBuilder runtimeBuilder = AeshCommandRuntimeBuilder.builder();
        runtimeBuilder.commandActivatorProvider((CommandActivatorProvider)new ContextAwareCommandActivatorProvider(this.context)).commandInvocationProvider((CommandInvocationProvider)new ContextAwareCommandInvocationProvider(this.context)).commandNotFoundHandler((CommandNotFoundHandler)new CliCommandNotFoundHandler()).completerInvocationProvider((CompleterInvocationProvider)new ContextAwareCompleterInvocationProvider(this.context)).aeshContext((AeshContext)this.context).commandRegistry(commandRegistry);
        runtimeBuilder.shell(shell);
        CliRuntimeRunner cliRunner = new CliRuntimeRunner("batch", runtimeBuilder.build());
        int exitCode = cliRunner.args(new String[]{"run", inputFile}).execute();
        this.context.disconnect();
        return CommandResult.valueOf((int)exitCode);
    }

    private CommandResult interactive(Shell shell) {
        CliAliasManager aliasManager;
        CommandRegistry commandRegistry = this.initializeCommands(new Class[0]);
        this.context.setRegistry((CommandRegistry<? extends CommandInvocation>)commandRegistry);
        try {
            aliasManager = new CliAliasManager(this.context.getConfigPath().resolve("aliases").toFile(), true, commandRegistry);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        SettingsBuilder settings = SettingsBuilder.builder();
        settings.enableAlias(true).aliasManager((AliasManager)aliasManager).historyFile(this.context.getConfigPath().resolve("history").toFile()).outputStream(System.out).outputStreamError(System.err).inputStream(System.in).commandActivatorProvider((CommandActivatorProvider)new ContextAwareCommandActivatorProvider(this.context)).commandInvocationProvider((CommandInvocationProvider)new ContextAwareCommandInvocationProvider(this.context)).commandNotFoundHandler((CommandNotFoundHandler)new CliCommandNotFoundHandler()).completerInvocationProvider((CompleterInvocationProvider)new ContextAwareCompleterInvocationProvider(this.context)).commandRegistry(commandRegistry).aeshContext((AeshContext)this.context).quitHandler((QuitHandler)new ContextAwareQuitHandler(this.context));
        if (shell instanceof AeshDelegatingShell) {
            settings.connection(((AeshDelegatingShell)shell).getConnection());
        }
        ReadlineConsole console = new ReadlineConsole(settings.build());
        this.context.setConsole(console);
        try {
            console.start();
            return CommandResult.SUCCESS;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private CommandRegistry initializeCommands(Class<? extends Command> ... commands) {
        try {
            AeshCommandRegistryBuilder registryBuilder = AeshCommandRegistryBuilder.builder();
            for (Class<? extends Command> command : commands) {
                registryBuilder.command(command);
            }
            for (Command command : ServiceFinder.load(Command.class, (ClassLoader[])new ClassLoader[]{this.getClass().getClassLoader()})) {
                registryBuilder.command(command);
            }
            return registryBuilder.create();
        }
        catch (CommandRegistryException e) {
            throw new RuntimeException(e);
        }
    }

    private static AeshCommandRuntimeBuilder initialCommandRuntimeBuilder(Shell shell, Properties properties, boolean kube) throws CommandRegistryException {
        ContextImpl context;
        AeshCommandRegistryBuilder registryBuilder = AeshCommandRegistryBuilder.builder();
        if (kube) {
            context = new KubernetesContext(properties);
            registryBuilder.command(Kube.class);
        } else {
            context = new ContextImpl(properties);
            registryBuilder.command(CLI.class);
        }
        AeshCommandRuntimeBuilder runtimeBuilder = AeshCommandRuntimeBuilder.builder();
        runtimeBuilder.commandActivatorProvider((CommandActivatorProvider)new ContextAwareCommandActivatorProvider(context)).commandInvocationProvider((CommandInvocationProvider)new ContextAwareCommandInvocationProvider(context)).commandNotFoundHandler((CommandNotFoundHandler)new CliCommandNotFoundHandler()).completerInvocationProvider((CompleterInvocationProvider)new ContextAwareCompleterInvocationProvider(context)).shell(shell).aeshContext((AeshContext)context).commandRegistry(registryBuilder.create());
        return runtimeBuilder;
    }

    private static boolean isKubernetesMode() {
        return ProcessInfo.getInstance().getName().contains("kubectl") || Boolean.getBoolean("infinispan.cli.kubernetes");
    }

    public static int main(Shell shell, String[] args, Properties properties, boolean kube) {
        CommandRuntime runtime = null;
        try {
            int exitCode;
            SecurityActions.addSecurityProvider((Provider)WildFlyElytronCredentialStoreProvider.getInstance());
            runtime = CLI.initialCommandRuntimeBuilder(shell, properties, kube).build();
            int n = exitCode = new CliRuntimeRunner(kube ? "kube" : "cli", runtime).args(args).execute();
            return n;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (runtime != null) {
                Util.close((AutoCloseable)((AutoCloseable)runtime.getAeshContext()));
            }
        }
    }

    public static int main(Shell shell, String[] args, Properties properties) {
        return CLI.main(shell, args, properties, CLI.isKubernetesMode());
    }

    public static void main(String[] args) {
        System.exit(CLI.main(new DefaultShell(), args, System.getProperties()));
    }
}

