/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands.kubernetes;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.LocalPortForward;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.ResourceDefinitionContext;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandResult;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.infinispan.cli.commands.CLI;
import org.infinispan.cli.commands.CliCommand;
import org.infinispan.cli.commands.kubernetes.Kube;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;
import org.infinispan.cli.impl.DefaultShell;
import org.infinispan.cli.impl.KubernetesContext;
import org.infinispan.cli.logging.Messages;

@CommandDefinition(name="shell", description="Initiates an interactive shell with a service.")
public class Shell
extends CliCommand {
    @Option(shortName=110, description="Specifies the namespace where the cluster is running. Uses the default namespace if you do not specify one.")
    String namespace;
    @Option(shortName=112, name="pod-name", description="Specifies to which pod you connect.")
    String podName;
    @Option(shortName=104, hasValue=false, overrideRequired=true)
    protected boolean help;
    @Argument(description="Specifies the name of the service to connect to. Defaults to 'infinispan'", defaultValue={"infinispan"})
    String name;

    @Override
    public boolean isHelp() {
        return this.help;
    }

    @Override
    public CommandResult exec(ContextAwareCommandInvocation invocation) {
        CommandResult commandResult;
        block15: {
            KubernetesClient client = KubernetesContext.getClient(invocation);
            this.namespace = Kube.getNamespaceOrDefault(client, this.namespace);
            GenericKubernetesResource infinispan = (GenericKubernetesResource)((Resource)((NonNamespaceOperation)client.genericKubernetesResources((ResourceDefinitionContext)Kube.INFINISPAN_CLUSTER_CRD).inNamespace(this.namespace)).withName(this.name)).get();
            if (infinispan == null) {
                throw Messages.MSG.noSuchService(this.name, this.namespace);
            }
            String endpointSecretName = (String)Kube.getProperty(infinispan, "spec", "security", "endpointSecretName");
            String certSecretName = (String)Kube.getProperty(infinispan, "spec", "security", "endpointEncryption", "certSecretName");
            Pod pod = this.podName == null ? (Pod)((PodList)((FilterWatchListDeletable)((NonNamespaceOperation)client.pods().inNamespace(this.namespace)).withLabel("infinispan_cr", this.name)).list()).getItems().stream().filter(p -> "running".equalsIgnoreCase(p.getStatus().getPhase())).findFirst().orElse(null) : (Pod)((PodResource)((NonNamespaceOperation)client.pods().inNamespace(this.namespace)).withName(this.podName)).get();
            if (pod == null) {
                throw Messages.MSG.noRunningPodsInService(this.name);
            }
            List ports = ((Container)pod.getSpec().getContainers().get(0)).getPorts();
            ContainerPort containerPort = ports.stream().filter(p -> "infinispan".equals(p.getName())).findFirst().get();
            LocalPortForward portForward = (LocalPortForward)((PodResource)((NonNamespaceOperation)client.pods().inNamespace(this.namespace)).withName(pod.getMetadata().getName())).portForward(containerPort.getContainerPort().intValue());
            try {
                InetAddress localAddress;
                Secret secret;
                StringBuilder connection = new StringBuilder();
                ArrayList<String> args = new ArrayList<String>();
                if (certSecretName != null) {
                    connection.append("https://");
                    secret = Kube.getSecret(client, this.namespace, certSecretName);
                    String crt = (String)secret.getData().get("tls.crt");
                    String pem = new String(Base64.getDecoder().decode(crt));
                    Path path = Files.createTempFile("clitrust", "pem", PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rw-------")));
                    Files.write(path, pem.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                    args.add("-t");
                    args.add(path.toString());
                } else {
                    connection.append("http://");
                }
                if (endpointSecretName != null) {
                    secret = Kube.getSecret(client, this.namespace, endpointSecretName);
                    List<Kube.SecretCredentials> credentials = Kube.decodeOpaqueSecrets(secret);
                    connection.append(credentials.get((int)0).username);
                    connection.append(':');
                    connection.append(credentials.get((int)0).password);
                    connection.append('@');
                }
                if ((localAddress = portForward.getLocalAddress()).getAddress().length == 4) {
                    connection.append(localAddress.getHostAddress());
                } else {
                    connection.append('[').append(localAddress.getHostAddress()).append(']');
                }
                connection.append(':');
                connection.append(portForward.getLocalPort());
                args.add("-c");
                args.add(connection.toString());
                CLI.main(new DefaultShell(), args.toArray(new String[0]), System.getProperties(), false);
                commandResult = CommandResult.SUCCESS;
                if (portForward == null) break block15;
            }
            catch (Throwable throwable) {
                try {
                    if (portForward != null) {
                        try {
                            portForward.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    return CommandResult.FAILURE;
                }
            }
            portForward.close();
        }
        return commandResult;
    }
}

