/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.Console;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.registry.CommandRegistry;
import org.aesh.command.shell.Shell;
import org.aesh.io.FileResource;
import org.aesh.io.Resource;
import org.aesh.readline.AeshContext;
import org.aesh.readline.Prompt;
import org.aesh.readline.ReadlineConsole;
import org.infinispan.cli.Context;
import org.infinispan.cli.connection.Connection;
import org.infinispan.cli.connection.ConnectionFactory;
import org.infinispan.cli.impl.SSLContextSettings;
import org.infinispan.cli.logging.Messages;
import org.infinispan.cli.resources.CacheKeyResource;
import org.infinispan.cli.util.SystemUtils;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.Version;

public class ContextImpl
implements Context,
AeshContext,
Closeable {
    private static final String CONFIG_FILE = "cli.properties";
    private Connection connection;
    private final Properties properties;
    private Resource cwd;
    private ReadlineConsole console;
    private SSLContextSettings sslContext;
    private CommandRegistry<? extends CommandInvocation> registry;
    private final Path configPath;

    public ContextImpl(Properties defaults) {
        this.properties = new Properties(defaults);
        String userDir = this.properties.getProperty("user.dir");
        this.cwd = userDir != null ? new FileResource(userDir) : null;
        String cliDir = this.properties.getProperty("cli.dir");
        if (cliDir == null) {
            cliDir = System.getenv("ISPN_CLI_DIR");
        }
        this.configPath = cliDir != null ? Paths.get(cliDir, new String[0]) : Paths.get(SystemUtils.getAppConfigFolder(Version.getBrandName().toLowerCase().replace(' ', '_')), new String[0]);
        Path configFile = this.configPath.resolve(CONFIG_FILE);
        if (Files.exists(configFile, new LinkOption[0])) {
            try (BufferedReader r = Files.newBufferedReader(configFile);){
                this.properties.load(r);
            }
            catch (IOException e) {
                System.err.println(Messages.MSG.configLoadFailed(configFile.toString()));
            }
        }
    }

    @Override
    public Path getConfigPath() {
        return this.configPath;
    }

    @Override
    public boolean isConnected() {
        return this.connection != null && this.connection.isConnected();
    }

    @Override
    public void setProperty(String key, String value) {
        if (value == null) {
            this.properties.remove(key);
        } else {
            this.properties.setProperty(key, value);
        }
    }

    @Override
    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    @Override
    public String getProperty(Context.Property property) {
        return this.properties.getProperty(property.propertyName());
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public void saveProperties() {
        Path configFile = this.configPath.resolve(CONFIG_FILE);
        try {
            Files.createDirectories(this.configPath, new FileAttribute[0]);
            try (BufferedWriter w = Files.newBufferedWriter(configFile, new OpenOption[0]);){
                this.properties.store(w, null);
            }
        }
        catch (IOException e) {
            System.err.println(Messages.MSG.configStoreFailed(configFile.toString()));
        }
    }

    @Override
    public void setSslContext(SSLContextSettings sslContext) {
        this.sslContext = sslContext;
    }

    @Override
    public Connection connect(Shell shell, String connectionString) {
        this.disconnect();
        this.connection = ConnectionFactory.getConnection(connectionString, this.sslContext);
        try {
            this.connection.connect();
        }
        catch (AccessDeniedException accessDenied) {
            try {
                Util.close((AutoCloseable)this.connection);
                String username = null;
                String password = null;
                if (shell != null) {
                    username = shell.readLine(Messages.MSG.username());
                    password = username.isEmpty() ? "" : shell.readLine(new Prompt(Messages.MSG.password(), Character.valueOf('*')));
                } else {
                    Console sysConsole = System.console();
                    if (sysConsole != null) {
                        username = sysConsole.readLine(Messages.MSG.username(), new Object[0]);
                        password = username.isEmpty() ? "" : new String(sysConsole.readPassword(Messages.MSG.password(), new Object[0]));
                    }
                }
                this.connection.connect(username, password);
            }
            catch (Exception e) {
                this.disconnect();
                this.showError(shell, e);
            }
        }
        catch (IOException e) {
            this.disconnect();
            this.showError(shell, e);
        }
        this.refreshPrompt();
        return this.connection;
    }

    private void showError(Shell shell, Throwable t) {
        if (shell != null) {
            shell.writeln(t.getMessage());
        } else {
            System.err.println(t.getMessage());
        }
    }

    @Override
    public Connection connect(Shell shell, String connectionString, String username, String password) {
        this.disconnect();
        this.connection = ConnectionFactory.getConnection(connectionString, this.sslContext);
        try {
            this.connection.connect(username, password);
        }
        catch (IOException e) {
            this.disconnect();
            if (shell != null) {
                shell.writeln("\u001b[0;31m" + e.getLocalizedMessage() + "\u001b[0;39m");
            }
            System.err.println(e.getLocalizedMessage());
        }
        this.refreshPrompt();
        return this.connection;
    }

    private void buildPrompt(org.infinispan.cli.resources.Resource resource, StringBuilder builder) {
        if (resource != null) {
            if (resource.getParent() != null) {
                this.buildPrompt(resource.getParent(), builder);
            }
            builder.append("/").append(resource.getName());
        }
    }

    @Override
    public void refreshPrompt() {
        if (this.console != null) {
            if (this.connection != null) {
                StringBuilder prompt = new StringBuilder();
                prompt.append("[").append("\u001b[0;32m").append(this.connection.getConnectionInfo()).append("\u001b[0;39m");
                this.buildPrompt(this.connection.getActiveResource(), prompt);
                prompt.append("]> ");
                this.console.setPrompt(prompt.toString());
            } else {
                this.console.setPrompt("[\u001b[0;33mdisconnected\u001b[0;39m]> ");
            }
        }
    }

    @Override
    public CommandResult changeResource(Class<? extends org.infinispan.cli.resources.Resource> fromResource, String resourceType, String name) throws CommandException {
        try {
            org.infinispan.cli.resources.Resource resource = fromResource != null ? this.connection.getActiveResource().findAncestor(fromResource).getChild(resourceType, name) : this.connection.getActiveResource().getResource(name);
            if (!(resource instanceof CacheKeyResource)) {
                this.connection.setActiveResource(resource);
            }
            this.refreshPrompt();
            return CommandResult.SUCCESS;
        }
        catch (IOException e) {
            throw new CommandException((Throwable)e);
        }
    }

    @Override
    public void disconnect() {
        Util.close((AutoCloseable)this.connection);
        this.connection = null;
        this.refreshPrompt();
    }

    @Override
    public MediaType getEncoding() {
        return this.connection.getEncoding();
    }

    @Override
    public void setEncoding(MediaType encoding) {
        this.connection.setEncoding(encoding);
    }

    @Override
    public void setConsole(ReadlineConsole console) {
        this.console = console;
        this.refreshPrompt();
    }

    @Override
    public CommandRegistry<? extends CommandInvocation> getRegistry() {
        return this.registry;
    }

    @Override
    public void setRegistry(CommandRegistry<? extends CommandInvocation> registry) {
        this.registry = registry;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    public Resource getCurrentWorkingDirectory() {
        return this.cwd;
    }

    public void setCurrentWorkingDirectory(Resource cwd) {
        this.cwd = cwd;
    }

    public Set<String> exportedVariableNames() {
        return Collections.emptySet();
    }

    public String exportedVariable(String key) {
        return null;
    }

    @Override
    public void close() {
        this.disconnect();
    }
}

