/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.benchmark;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.aesh.command.shell.Shell;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.IterationParams;
import org.openjdk.jmh.results.BenchmarkResult;
import org.openjdk.jmh.results.IterationResult;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.RunResult;
import org.openjdk.jmh.results.format.ResultFormatFactory;
import org.openjdk.jmh.results.format.ResultFormatType;
import org.openjdk.jmh.runner.IterationType;
import org.openjdk.jmh.runner.format.OutputFormat;
import org.openjdk.jmh.runner.options.TimeValue;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.openjdk.jmh.util.Utils;

public class BenchmarkOutputFormat
implements OutputFormat {
    final VerboseMode verbose;
    final Shell out;

    public BenchmarkOutputFormat(Shell out, VerboseMode verbose) {
        this.out = out;
        this.verbose = verbose;
    }

    public void print(String s) {
        if (this.verbose != VerboseMode.SILENT) {
            this.out.write(s);
        }
    }

    public void println(String s) {
        if (this.verbose != VerboseMode.SILENT && !s.contains("on-forked runs")) {
            this.out.writeln(s);
        }
    }

    public void flush() {
    }

    public void verbosePrintln(String s) {
        if (this.verbose == VerboseMode.EXTRA) {
            this.out.writeln(s);
        }
    }

    public void write(int b) {
        this.out.write(new String(Character.toChars(b)));
    }

    public void write(byte[] b) {
    }

    public void close() {
    }

    public void startBenchmark(BenchmarkParams params) {
        if (this.verbose == VerboseMode.SILENT) {
            return;
        }
        IterationParams warmup = params.getWarmup();
        if (warmup.getCount() > 0) {
            this.out.writeln("# Warmup: " + warmup.getCount() + " iterations, " + warmup.getTime() + " each" + (warmup.getBatchSize() <= 1 ? "" : ", " + warmup.getBatchSize() + " calls per op"));
        } else {
            this.out.writeln("# Warmup: <none>");
        }
        IterationParams measurement = params.getMeasurement();
        if (measurement.getCount() > 0) {
            this.out.writeln("# Measurement: " + measurement.getCount() + " iterations, " + measurement.getTime() + " each" + (measurement.getBatchSize() <= 1 ? "" : ", " + measurement.getBatchSize() + " calls per op"));
        } else {
            this.out.writeln("# Measurement: <none>");
        }
        TimeValue timeout = params.getTimeout();
        boolean timeoutWarning = timeout.convertTo(TimeUnit.NANOSECONDS) <= measurement.getTime().convertTo(TimeUnit.NANOSECONDS) || timeout.convertTo(TimeUnit.NANOSECONDS) <= warmup.getTime().convertTo(TimeUnit.NANOSECONDS);
        this.out.writeln("# Timeout: " + timeout + " per iteration" + (timeoutWarning ? ", ***WARNING: The timeout might be too low!***" : ""));
        this.out.write("# Threads: " + params.getThreads() + " " + BenchmarkOutputFormat.getThreadsString(params.getThreads()));
        if (!params.getThreadGroupLabels().isEmpty()) {
            int[] tg = params.getThreadGroups();
            ArrayList labels = new ArrayList(params.getThreadGroupLabels());
            String[] ss = new String[tg.length];
            for (int cnt = 0; cnt < tg.length; ++cnt) {
                ss[cnt] = tg[cnt] + "x \"" + (String)labels.get(cnt) + "\"";
            }
            int groupCount = params.getThreads() / Utils.sum((int[])tg);
            this.out.write(" (" + groupCount + " " + BenchmarkOutputFormat.getGroupsString(groupCount) + "; " + Utils.join((String[])ss, (String)", ") + " in each group)");
        }
        this.out.writeln(params.shouldSynchIterations() ? ", will synchronize iterations" : (params.getMode() == Mode.SingleShotTime ? "" : ", ***WARNING: Synchronize iterations are disabled!***"));
        this.out.writeln("# Benchmark mode: " + params.getMode().longLabel());
        this.out.writeln("# Benchmark: " + params.getBenchmark());
        if (!params.getParamsKeys().isEmpty()) {
            StringBuilder sb = new StringBuilder();
            boolean isFirst = true;
            for (String k : params.getParamsKeys()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append(k).append(" = ").append(params.getParam(k));
            }
            this.out.writeln("# Parameters: (" + sb.toString() + ")");
        }
    }

    public void iteration(BenchmarkParams benchmarkParams, IterationParams params, int iteration) {
        if (this.verbose == VerboseMode.SILENT) {
            return;
        }
        switch (params.getType()) {
            case WARMUP: {
                this.out.write(String.format("Warmup    %3d: ", iteration));
                break;
            }
            case MEASUREMENT: {
                this.out.write(String.format("Iteration %3d: ", iteration));
                break;
            }
            default: {
                throw new IllegalStateException("Unknown iteration type: " + params.getType());
            }
        }
        this.flush();
    }

    protected static String getThreadsString(int t) {
        if (t > 1) {
            return "threads";
        }
        return "thread";
    }

    protected static String getGroupsString(int g) {
        if (g > 1) {
            return "groups";
        }
        return "group";
    }

    public void iterationResult(BenchmarkParams benchmParams, IterationParams params, int iteration, IterationResult data) {
        if (this.verbose == VerboseMode.SILENT) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(data.getPrimaryResult().toString());
        if (params.getType() == IterationType.MEASUREMENT) {
            int prefixLen = String.format("Iteration %3d: ", iteration).length();
            Map secondary = data.getSecondaryResults();
            if (!secondary.isEmpty()) {
                sb.append("\n");
                int maxKeyLen = 0;
                for (Map.Entry res : secondary.entrySet()) {
                    maxKeyLen = Math.max(maxKeyLen, ((String)res.getKey()).length());
                }
                for (Map.Entry res : secondary.entrySet()) {
                    sb.append(String.format("%" + prefixLen + "s", ""));
                    sb.append(String.format("  %-" + (maxKeyLen + 1) + "s %s", (String)res.getKey() + ":", res.getValue()));
                    sb.append("\n");
                }
            }
        }
        this.out.write(String.format("%s%n", sb));
        this.flush();
    }

    public void endBenchmark(BenchmarkResult result) {
        this.out.writeln("");
        if (result != null) {
            Result r = result.getPrimaryResult();
            String s = r.extendedInfo();
            if (!s.trim().isEmpty()) {
                this.out.writeln("Result \"" + result.getParams().getBenchmark() + "\":");
                this.out.writeln(s);
            }
            for (Result r2 : result.getSecondaryResults().values()) {
                String s2 = r2.extendedInfo();
                if (s2.trim().isEmpty()) continue;
                this.out.writeln("Secondary result \"" + result.getParams().getBenchmark() + ":" + r2.getLabel() + "\":");
                this.out.writeln(s2);
            }
            this.out.writeln("");
        }
    }

    public void startRun() {
    }

    public void endRun(Collection<RunResult> runResults) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream((OutputStream)baos, true, StandardCharsets.UTF_8.name());
            ResultFormatFactory.getInstance((ResultFormatType)ResultFormatType.TEXT, (PrintStream)printStream).writeOut(runResults);
            this.println(baos.toString());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }
}

