/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands.kubernetes;

import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceList;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import java.util.Base64;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.aesh.command.Command;
import org.aesh.command.CommandResult;
import org.aesh.command.GroupCommandDefinition;
import org.aesh.command.invocation.CommandInvocation;
import org.infinispan.cli.commands.Version;
import org.infinispan.cli.commands.kubernetes.Create;
import org.infinispan.cli.commands.kubernetes.Delete;
import org.infinispan.cli.commands.kubernetes.Get;
import org.infinispan.cli.commands.kubernetes.Install;
import org.infinispan.cli.commands.kubernetes.Shell;
import org.infinispan.cli.commands.kubernetes.Uninstall;
import org.infinispan.cli.logging.Messages;
import org.yaml.snakeyaml.Yaml;

@GroupCommandDefinition(name="kube", description="Kubernetes commands.", groupCommands={Create.class, Install.class, Shell.class, Get.class, Delete.class, Uninstall.class, Version.class})
public class Kube
implements Command {
    public static final String DEFAULT_CLUSTER_NAME = "infinispan";
    static final CustomResourceDefinitionContext INFINISPAN_CLUSTER_CRD = new CustomResourceDefinitionContext.Builder().withName("infinispans.infinispan.org").withGroup("infinispan.org").withKind("Infinispan").withPlural("infinispans").withScope("Namespaced").withVersion("v1").build();
    static final CustomResourceDefinitionContext OPERATOR_CATALOGSOURCE_CRD = new CustomResourceDefinitionContext.Builder().withGroup("operators.coreos.com").withKind("CatalogSource").withPlural("catalogsources").withScope("Namespaced").withVersion("v1alpha1").build();
    static final CustomResourceDefinitionContext OPERATOR_CLUSTERSERVICEVERSION_CRD = new CustomResourceDefinitionContext.Builder().withGroup("operators.coreos.com").withKind("ClusterServiceVersion").withPlural("clusterserviceversions").withScope("Namespaced").withVersion("v1alpha1").build();
    static final CustomResourceDefinitionContext OPERATOR_SUBSCRIPTION_CRD = new CustomResourceDefinitionContext.Builder().withGroup("operators.coreos.com").withKind("Subscription").withPlural("subscriptions").withScope("Namespaced").withVersion("v1alpha1").build();
    static final CustomResourceDefinitionContext OPERATOR_OPERATORGROUP_CRD = new CustomResourceDefinitionContext.Builder().withGroup("operators.coreos.com").withKind("OperatorGroup").withPlural("operatorgroups").withScope("Namespaced").withVersion("v1").build();

    public static <T> T getProperty(GenericKubernetesResource item, String ... names) {
        Map properties = item.getAdditionalProperties();
        for (int i = 0; i < names.length - 1; ++i) {
            if ((properties = (Map)properties.get(names[i])) != null) continue;
            return null;
        }
        return (T)properties.get(names[names.length - 1]);
    }

    public static void setProperty(GenericKubernetesResource item, String value, String ... names) {
        for (int i = 0; i < names.length - 1; ++i) {
            Map properties = item.getAdditionalProperties();
            if (properties.containsKey(names[i])) {
                item = (GenericKubernetesResource)properties.get(names[i]);
                continue;
            }
            GenericKubernetesResource child = new GenericKubernetesResource();
            item.setAdditionalProperty(names[i], (Object)child);
            item = child;
        }
        item.setAdditionalProperty(names[names.length - 1], (Object)value);
    }

    public CommandResult execute(CommandInvocation invocation) {
        invocation.getShell().write(invocation.getHelpInfo());
        return CommandResult.FAILURE;
    }

    static Secret getSecret(KubernetesClient client, String namespace, String name) {
        try {
            return (Secret)((Resource)((NonNamespaceOperation)client.secrets().inNamespace(namespace)).withName(name)).get();
        }
        catch (KubernetesClientException e) {
            return null;
        }
    }

    static Map<String, String> decodeOpaqueSecrets(Secret secret) {
        if (secret == null) {
            return Collections.emptyMap();
        }
        String opaqueIdentities = (String)secret.getData().get("identities.yaml");
        String identitiesYaml = new String(Base64.getDecoder().decode(opaqueIdentities));
        Yaml yaml = new Yaml();
        Map identities = (Map)yaml.load(identitiesYaml);
        List credentialsList = (List)identities.get("credentials");
        LinkedHashMap<String, String> res = new LinkedHashMap<String, String>(identities.size());
        for (Map credentials : credentialsList) {
            res.put((String)credentials.get("username"), (String)credentials.get("password"));
        }
        return res;
    }

    static String getNamespaceOrDefault(KubernetesClient client, String namespace) {
        String ns;
        String string = ns = namespace != null ? namespace : client.getConfiguration().getNamespace();
        if (ns == null) {
            throw Messages.MSG.noDefaultNamespace();
        }
        return ns;
    }

    static String defaultOperatorNamespace(KubernetesClient client) {
        List namespaces = ((NamespaceList)client.namespaces().list()).getItems();
        Optional<Namespace> ns = namespaces.stream().filter(n -> "openshift-operators".equals(n.getMetadata().getName())).findFirst();
        if (!ns.isPresent()) {
            ns = namespaces.stream().filter(n -> "operators".equals(n.getMetadata().getName())).findFirst();
        }
        if (ns.isPresent()) {
            return ns.get().getMetadata().getName();
        }
        throw Messages.MSG.noDefaultOperatorNamespace();
    }
}

