/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands.rest;

import java.util.concurrent.CompletionStage;
import org.aesh.command.CommandDefinition;
import org.aesh.command.impl.completer.BooleanOptionCompleter;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.infinispan.cli.activators.ConnectionActivator;
import org.infinispan.cli.commands.rest.RestCliCommand;
import org.infinispan.cli.completers.CounterCompleter;
import org.infinispan.cli.connection.Connection;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;
import org.infinispan.cli.resources.CounterResource;
import org.infinispan.cli.resources.Resource;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestResponse;

@CommandDefinition(name="add", description="Adds/subtracts a value to/from a counter", activator=ConnectionActivator.class)
public class Add
extends RestCliCommand {
    @Argument(completer=CounterCompleter.class, description="The name of the counter")
    String counter;
    @Option(description="Does not display the value", completer=BooleanOptionCompleter.class)
    boolean quiet;
    @Option(description="The delta to add/subtract from/to the value. Defaults to adding 1", defaultValue={"1"})
    long delta;
    @Option(shortName=104, hasValue=false, overrideRequired=true)
    protected boolean help;

    @Override
    public boolean isHelp() {
        return this.help;
    }

    @Override
    protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, Resource resource) {
        return client.counter(this.counter != null ? this.counter : CounterResource.counterName(resource)).add(this.delta);
    }

    @Override
    public Connection.ResponseMode getResponseMode() {
        return this.quiet ? Connection.ResponseMode.QUIET : Connection.ResponseMode.BODY;
    }
}

