/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.util.aesh.graal;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.aesh.AeshRuntimeRunner;
import org.aesh.command.Command;
import org.aesh.command.impl.internal.ProcessedCommand;
import org.aesh.command.impl.internal.ProcessedOption;
import org.aesh.command.impl.parser.AeshOptionParser;
import org.aesh.command.impl.parser.CommandLineParser;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.terminal.utils.Config;
import org.infinispan.cli.util.aesh.graal.GraalReflectionCommand;

public class GraalReflectionFileGenerator {
    Set<String> klasses = new HashSet<String>();

    public GraalReflectionFileGenerator() {
        this.klasses.add(AeshOptionParser.class.getName());
    }

    public void generateReflection(CommandLineParser<CommandInvocation> parser, Writer w) throws IOException {
        w.append('[').append(Config.getLineSeparator());
        this.processCommand(parser, w);
        this.appendOptions(w);
        w.append(Config.getLineSeparator()).append("]");
    }

    private void processCommand(CommandLineParser<CommandInvocation> parser, Writer w) throws IOException {
        this.parseCommand((ProcessedCommand<Command<CommandInvocation>, CommandInvocation>)parser.getProcessedCommand(), w);
        if (parser.isGroupCommand()) {
            for (CommandLineParser child : parser.getAllChildParsers()) {
                w.append("  },").append(Config.getLineSeparator());
                this.processCommand((CommandLineParser<CommandInvocation>)child, w);
            }
        }
    }

    private void parseCommand(ProcessedCommand<Command<CommandInvocation>, CommandInvocation> command, Writer w) throws IOException {
        w.append("  {").append(Config.getLineSeparator());
        this.appendCommand(command, w);
    }

    private void appendOptions(Writer w) throws IOException {
        for (String klass : this.klasses) {
            w.append("  },").append(Config.getLineSeparator()).append("  {").append(Config.getLineSeparator()).append("    \"name\" : \"").append(klass).append("\", ").append(Config.getLineSeparator());
            this.appendDefaults(w);
        }
        w.append(Config.getLineSeparator()).append("  }");
    }

    private void appendDefaults(Writer w) throws IOException {
        w.append("    \"allDeclaredConstructors\" : true,").append(Config.getLineSeparator()).append("    \"allPublicConstructors\" : true,").append(Config.getLineSeparator()).append("    \"allDeclaredMethods\" : true,").append(Config.getLineSeparator()).append("    \"allPublicMethods\" : true");
    }

    private void appendCommand(ProcessedCommand<Command<CommandInvocation>, CommandInvocation> command, Writer w) throws IOException {
        w.append("    \"name\" : \"").append(command.getCommand().getClass().getName()).append("\",").append(Config.getLineSeparator());
        this.appendDefaults(w);
        if (command.getActivator() != null) {
            this.klasses.add(command.getActivator().getClass().getName());
        }
        ArrayList<ProcessedOption> allArgumentsAndOptions = new ArrayList<ProcessedOption>(command.getOptions());
        if (command.getArguments() != null) {
            allArgumentsAndOptions.add(command.getArguments());
        }
        if (command.getArgument() != null) {
            allArgumentsAndOptions.add(command.getArgument());
        }
        if (allArgumentsAndOptions.size() > 0) {
            w.append(",").append(Config.getLineSeparator()).append("    \"fields\" : [").append(Config.getLineSeparator());
            boolean comma = false;
            for (ProcessedOption option : allArgumentsAndOptions) {
                if (comma) {
                    w.append(",").append(Config.getLineSeparator());
                } else {
                    comma = true;
                }
                w.append("      { \"name\" : \"").append(option.getFieldName()).append("\" }");
                if (option.completer() != null) {
                    this.klasses.add(option.completer().getClass().getName());
                }
                if (option.activator() != null) {
                    this.klasses.add(option.activator().getClass().getName());
                }
                if (option.converter() == null) continue;
                this.klasses.add(option.converter().getClass().getName());
            }
            w.append(Config.getLineSeparator());
            w.append("    ]").append(Config.getLineSeparator());
        }
    }

    public static void main(String[] args) {
        AeshRuntimeRunner.builder().command(GraalReflectionCommand.class).args(args).execute();
    }
}

