/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands.kubernetes;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.LocalPortForward;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.base.ResourceDefinitionContext;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandResult;
import org.aesh.command.impl.completer.FileOptionCompleter;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.aesh.io.Resource;
import org.aesh.readline.terminal.formatting.Color;
import org.aesh.readline.terminal.formatting.TerminalColor;
import org.aesh.readline.terminal.formatting.TerminalString;
import org.infinispan.cli.commands.CLI;
import org.infinispan.cli.commands.CliCommand;
import org.infinispan.cli.commands.kubernetes.Kube;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;
import org.infinispan.cli.impl.DefaultShell;
import org.infinispan.cli.impl.KubernetesContext;
import org.infinispan.cli.logging.Messages;
import org.infinispan.commons.util.Util;

@CommandDefinition(name="shell", description="Initiates an interactive shell with a service.")
public class Shell
extends CliCommand {
    @Option(shortName=110, description="Specifies the namespace where the cluster is running. Uses the default namespace if you do not specify one.")
    String namespace;
    @Option(shortName=112, name="pod-name", description="Specifies to which pod you connect.")
    String podName;
    @Option(shortName=117, name="username", description="The username to use when connecting")
    String username;
    @Option(completer=FileOptionCompleter.class, shortName=107, name="keystore", description="A keystore containing a client certificate to authenticate with the server")
    Resource keystore;
    @Option(shortName=119, name="keystore-password", description="The password for the keystore")
    String keystorePassword;
    @Option(shortName=104, hasValue=false, overrideRequired=true)
    protected boolean help;
    @Argument(description="Specifies the name of the service to connect to. Defaults to 'infinispan'", defaultValue={"infinispan"})
    String name;

    @Override
    public boolean isHelp() {
        return this.help;
    }

    @Override
    public CommandResult exec(ContextAwareCommandInvocation invocation) {
        CommandResult commandResult;
        block22: {
            KubernetesClient client = KubernetesContext.getClient(invocation);
            this.namespace = Kube.getNamespaceOrDefault(client, this.namespace);
            GenericKubernetesResource infinispan = (GenericKubernetesResource)((io.fabric8.kubernetes.client.dsl.Resource)((NonNamespaceOperation)client.genericKubernetesResources((ResourceDefinitionContext)Kube.INFINISPAN_CLUSTER_CRD).inNamespace(this.namespace)).withName(this.name)).get();
            if (infinispan == null) {
                throw Messages.MSG.noSuchService(this.name, this.namespace);
            }
            String endpointSecretName = (String)Kube.getProperty(infinispan, "spec", "security", "endpointSecretName");
            String certSecretName = (String)Kube.getProperty(infinispan, "spec", "security", "endpointEncryption", "certSecretName");
            Pod pod = this.podName == null ? (Pod)((PodList)((FilterWatchListDeletable)((NonNamespaceOperation)client.pods().inNamespace(this.namespace)).withLabel("infinispan_cr", this.name)).list()).getItems().stream().filter(p -> "running".equalsIgnoreCase(p.getStatus().getPhase())).findFirst().orElse(null) : (Pod)((PodResource)((NonNamespaceOperation)client.pods().inNamespace(this.namespace)).withName(this.podName)).get();
            if (pod == null) {
                throw Messages.MSG.noRunningPodsInService(this.name);
            }
            List ports = ((Container)pod.getSpec().getContainers().get(0)).getPorts();
            ContainerPort containerPort = ports.stream().filter(p -> "infinispan".equals(p.getName())).findFirst().get();
            LocalPortForward portForward = (LocalPortForward)((PodResource)((NonNamespaceOperation)client.pods().inNamespace(this.namespace)).withName(pod.getMetadata().getName())).portForward(containerPort.getContainerPort().intValue());
            try {
                InetAddress localAddress;
                Secret secret;
                StringBuilder connection = new StringBuilder();
                ArrayList<String> args = new ArrayList<String>();
                if (certSecretName != null) {
                    String suffix;
                    byte[] cert;
                    connection.append("https://");
                    secret = Kube.getSecret(client, this.namespace, certSecretName);
                    if (secret.getData().containsKey("keystore.p12")) {
                        cert = Base64.getDecoder().decode((String)secret.getData().get("keystore.p12"));
                        suffix = ".p12";
                        String password = new String(Base64.getDecoder().decode((String)secret.getData().get("password")));
                        args.add("-s");
                        args.add(password);
                    } else {
                        cert = new String(Base64.getDecoder().decode((String)secret.getData().get("tls.crt"))).getBytes(StandardCharsets.UTF_8);
                        suffix = ".pem";
                    }
                    Path certPath = Files.createTempFile("clitrust", suffix, PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rw-------")));
                    Files.write(certPath, cert, new OpenOption[0]);
                    args.add("-t");
                    args.add(certPath.toString());
                    args.add("--hostname-verifier");
                    args.add(".*");
                    if (this.keystore != null) {
                        args.add("-k");
                        args.add(this.keystore.getAbsolutePath());
                        args.add("-w");
                        args.add(this.keystorePassword);
                    }
                } else {
                    connection.append("http://");
                }
                if (endpointSecretName != null) {
                    secret = Kube.getSecret(client, this.namespace, endpointSecretName);
                    Map<String, String> credentials = Kube.decodeOpaqueSecrets(secret);
                    if (this.username == null) {
                        if (credentials.size() != 1) {
                            throw Messages.MSG.usernameRequired();
                        }
                        Map.Entry<String, String> entry = credentials.entrySet().iterator().next();
                        connection.append(entry.getKey());
                        connection.append(':');
                        connection.append(entry.getValue());
                        connection.append('@');
                    } else {
                        connection.append(this.username);
                        if (credentials.containsKey(this.username)) {
                            connection.append(':');
                            connection.append(credentials.get(this.username));
                        }
                        connection.append('@');
                    }
                }
                if ((localAddress = portForward.getLocalAddress()).getAddress().length == 4) {
                    connection.append(localAddress.getHostAddress());
                } else {
                    connection.append('[').append(localAddress.getHostAddress()).append(']');
                }
                connection.append(':');
                connection.append(portForward.getLocalPort());
                args.add("-c");
                args.add(connection.toString());
                Messages.CLI.debugf("cli %s", args);
                CLI.main((org.aesh.command.shell.Shell)new DefaultShell(), args.toArray(new String[0]), System.getProperties(), false);
                commandResult = CommandResult.SUCCESS;
                if (portForward == null) break block22;
            }
            catch (Throwable connection) {
                try {
                    if (portForward != null) {
                        try {
                            portForward.close();
                        }
                        catch (Throwable throwable) {
                            connection.addSuppressed(throwable);
                        }
                    }
                    throw connection;
                }
                catch (Throwable t) {
                    TerminalString error = new TerminalString(Util.getRootCause((Throwable)t).getLocalizedMessage(), new TerminalColor(Color.RED, Color.DEFAULT, Color.Intensity.BRIGHT));
                    invocation.getShell().writeln(error.toString());
                    return CommandResult.FAILURE;
                }
            }
            portForward.close();
        }
        return commandResult;
    }
}

