/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.GroupCommandDefinition;
import org.aesh.command.impl.completer.FileOptionCompleter;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Arguments;
import org.aesh.command.option.Option;
import org.aesh.io.Resource;
import org.infinispan.cli.Context;
import org.infinispan.cli.activators.ConfigConversionAvailable;
import org.infinispan.cli.commands.CliCommand;
import org.infinispan.cli.completers.ConfigPropertyCompleter;
import org.infinispan.cli.completers.MediaTypeCompleter;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;
import org.infinispan.cli.logging.Messages;
import org.infinispan.commons.configuration.io.ConfigurationWriter;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;

@GroupCommandDefinition(name="config", description="Configuration operations", groupCommands={Set.class, Get.class, Reset.class, Convert.class})
public class Config
extends CliCommand {
    @Option(shortName=104, hasValue=false, overrideRequired=true)
    protected boolean help;

    @Override
    public boolean isHelp() {
        return this.help;
    }

    @Override
    public CommandResult exec(ContextAwareCommandInvocation invocation) {
        Context context = invocation.getContext();
        context.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> invocation.printf("%s=%s\n", k, v)));
        return CommandResult.SUCCESS;
    }

    @CommandDefinition(name="convert", description="Converts configuration to different formats.", activator=ConfigConversionAvailable.class)
    public static class Convert
    extends CliCommand {
        @Argument(description="Specifies the path to a configuration file to convert. Uses standard input (stdin) if you do not specify a path.", completer=FileOptionCompleter.class)
        Resource input;
        @Option(description="Specifies the path to the output configuration file. Uses standard output (stdout) if you do not specify a path.", completer=FileOptionCompleter.class, shortName=111)
        Resource output;
        @Option(description="Sets the format of the output configuration.", required=true, completer=MediaTypeCompleter.class, shortName=102)
        String format;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        public CommandResult exec(ContextAwareCommandInvocation invocation) throws CommandException {
            CommandResult commandResult;
            OutputStream os;
            block20: {
                InputStream is = null;
                os = null;
                try {
                    MediaType mediaType;
                    ParserRegistry registry = new ParserRegistry();
                    is = this.input == null ? System.in : new FileInputStream(this.input.getAbsolutePath());
                    ConfigurationBuilderHolder holder = registry.parse(is, null, null);
                    os = this.output == null ? System.out : new FileOutputStream(this.output.getAbsolutePath());
                    HashMap<String, Configuration> configurations = new HashMap<String, Configuration>();
                    for (Map.Entry configuration : holder.getNamedConfigurationBuilders().entrySet()) {
                        configurations.put((String)configuration.getKey(), ((ConfigurationBuilder)configuration.getValue()).build());
                    }
                    switch (MediaTypeCompleter.MediaType.valueOf(this.format.toUpperCase(Locale.ROOT))) {
                        case XML: {
                            mediaType = MediaType.APPLICATION_XML;
                            break;
                        }
                        case YAML: {
                            mediaType = MediaType.APPLICATION_YAML;
                            break;
                        }
                        case JSON: {
                            mediaType = MediaType.APPLICATION_JSON;
                            break;
                        }
                        default: {
                            throw new CommandException("Invalid output format: " + this.format);
                        }
                    }
                    try (ConfigurationWriter writer = ConfigurationWriter.to((OutputStream)os).withType(mediaType).clearTextSecrets(true).prettyPrint(true).build();){
                        registry.serialize(writer, holder.getGlobalConfigurationBuilder().build(), configurations);
                    }
                    commandResult = CommandResult.SUCCESS;
                    if (this.input == null) break block20;
                }
                catch (FileNotFoundException e) {
                    try {
                        throw new CommandException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        if (this.input != null) {
                            Util.close(is);
                        }
                        if (this.output != null) {
                            Util.close(os);
                        }
                        throw throwable;
                    }
                }
                Util.close((AutoCloseable)is);
            }
            if (this.output != null) {
                Util.close((AutoCloseable)os);
            }
            return commandResult;
        }
    }

    @CommandDefinition(name="reset", description="Resets all configuration properties to their default values")
    public static class Reset
    extends CliCommand {
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        public CommandResult exec(ContextAwareCommandInvocation invocation) {
            Context context = invocation.getContext();
            context.resetProperties();
            context.saveProperties();
            return CommandResult.SUCCESS;
        }
    }

    @CommandDefinition(name="get", description="Gets a configuration property")
    public static class Get
    extends CliCommand {
        @Argument(description="The name of the property", required=true, completer=ConfigPropertyCompleter.class)
        String name;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        public CommandResult exec(ContextAwareCommandInvocation invocation) {
            Context context = invocation.getContext();
            invocation.printf("%s=%s\n", this.name, context.getProperty(this.name));
            return CommandResult.SUCCESS;
        }
    }

    @CommandDefinition(name="set", description="Sets a configuration property")
    public static class Set
    extends CliCommand {
        @Arguments(description="The property name and value", required=true, completer=ConfigPropertyCompleter.class)
        List<String> args;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        public CommandResult exec(ContextAwareCommandInvocation invocation) {
            Context context = invocation.getContext();
            switch (this.args.size()) {
                case 1: {
                    context.setProperty(this.args.get(0), null);
                    break;
                }
                case 2: {
                    context.setProperty(this.args.get(0), this.args.get(1));
                    break;
                }
                default: {
                    throw Messages.MSG.wrongArgumentCount(this.args.size());
                }
            }
            context.saveProperties();
            return CommandResult.SUCCESS;
        }
    }
}

