package org.infinispan.cli.logging;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.NoSuchFileException;
import java.lang.String;
import org.infinispan.cli.user.UserTool.Encryption;
import org.infinispan.cli.resources.Resource.ListFormat;
import java.lang.RuntimeException;
import org.infinispan.cli.patching.PatchOperation;
import java.lang.IllegalArgumentException;
import java.net.ConnectException;
import java.nio.file.Path;
import javax.annotation.processing.Generated;
import org.infinispan.cli.patching.PatchInfo;
import org.aesh.io.Resource;
import java.lang.SecurityException;
import java.io.IOException;
import org.aesh.command.CommandException;
import java.lang.Exception;
import org.aesh.command.parser.RequiredOptionException;
import java.lang.Throwable;
import java.util.Arrays;
import java.util.NoSuchElementException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageBundleImplementor", date = "2023-04-06T12:28:57-0400")
public class Messages_$bundle implements Messages, Serializable {
    private static final long serialVersionUID = 1L;
    protected Messages_$bundle() {}
    public static final Messages_$bundle INSTANCE = new Messages_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String username$str() {
        return "Username: ";
    }
    @Override
    public final String username() {
        return String.format(getLoggingLocale(), username$str());
    }
    protected String password$str() {
        return "Password: ";
    }
    @Override
    public final String password() {
        return String.format(getLoggingLocale(), password$str());
    }
    protected String notFound$str() {
        return "Not Found: %s";
    }
    @Override
    public final IOException notFound(final String s) {
        final IOException result = new IOException(String.format(getLoggingLocale(), notFound$str(), s));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String unauthorized$str() {
        return "The supplied credentials are invalid %s";
    }
    @Override
    public final AccessDeniedException unauthorized(final String s) {
        final AccessDeniedException result = new AccessDeniedException(String.format(getLoggingLocale(), unauthorized$str(), s));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String error$str() {
        return "Error: %s";
    }
    @Override
    public final IOException error(final String s) {
        final IOException result = new IOException(String.format(getLoggingLocale(), error$str(), s));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String forbidden$str() {
        return "The user is not allowed to access the server resource: %s";
    }
    @Override
    public final AccessDeniedException forbidden(final String s) {
        final AccessDeniedException result = new AccessDeniedException(String.format(getLoggingLocale(), forbidden$str(), s));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String keyStoreError$str() {
        return "Error while configuring SSL";
    }
    @Override
    public final String keyStoreError(final Exception e) {
        return String.format(getLoggingLocale(), keyStoreError$str());
    }
    protected String noSuchResource$str() {
        return "No such resource '%s'";
    }
    @Override
    public final IllegalArgumentException noSuchResource(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), noSuchResource$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalContext$str() {
        return "Command invoked from the wrong context";
    }
    @Override
    public final IllegalStateException illegalContext() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), illegalContext$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalCommandArguments$str() {
        return "Illegal arguments for command";
    }
    @Override
    public final IllegalArgumentException illegalCommandArguments() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalCommandArguments$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mutuallyExclusiveOptions$str() {
        return "The options '%s' and '%s' are mutually exclusive";
    }
    @Override
    public final IllegalArgumentException mutuallyExclusiveOptions(final String arg1, final String arg2) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), mutuallyExclusiveOptions$str(), arg1, arg2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String requiresOneOf$str() {
        return "One of the '%s' and '%s' options are required";
    }
    @Override
    public final RequiredOptionException requiresOneOf(final String arg1, final String arg2) {
        final RequiredOptionException result = new RequiredOptionException(String.format(getLoggingLocale(), requiresOneOf$str(), arg1, arg2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String connectionFailed$str() {
        return "Could not connect to server: %s";
    }
    @Override
    public final ConnectException connectionFailed(final String message) {
        final ConnectException result = new ConnectException(String.format(getLoggingLocale(), connectionFailed$str(), message));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidResource$str() {
        return "Invalid resource '%s'";
    }
    @Override
    public final IllegalArgumentException invalidResource(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidResource$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String patchNoPatchesInstalled$str() {
        return "No patches installed";
    }
    @Override
    public final String patchNoPatchesInstalled() {
        return String.format(getLoggingLocale(), patchNoPatchesInstalled$str());
    }
    protected String patchInfo$str() {
        return "%s";
    }
    @Override
    public final String patchInfo(final PatchInfo patchInfo) {
        return String.format(getLoggingLocale(), patchInfo$str(), patchInfo);
    }
    protected String patchCannotApply$str() {
        return "The supplied patch cannot be applied to %s %s";
    }
    @Override
    public final IllegalStateException patchCannotApply(final String brandName, final String version) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), patchCannotApply$str(), brandName, version));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String patchShaMismatch$str() {
        return "File %s SHA mismatch. Expected = %s, Actual = %s";
    }
    @Override
    public final String patchShaMismatch(final Path path, final String digest, final String sha256) {
        return String.format(getLoggingLocale(), patchShaMismatch$str(), path, digest, sha256);
    }
    protected String patchValidationErrors$str() {
        return "The following errors were encountered while validating the installation:%n%s";
    }
    @Override
    public final IllegalStateException patchValidationErrors(final String errors) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), patchValidationErrors$str(), errors));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String patchNoPatchesInstalledToRollback$str() {
        return "No installed patches to roll back";
    }
    @Override
    public final IllegalStateException patchNoPatchesInstalledToRollback() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), patchNoPatchesInstalledToRollback$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String patchCannotFindCommons$str() {
        return "Cannot find the infinispan-commons jar under %s";
    }
    @Override
    public final IllegalStateException patchCannotFindCommons(final Path lib) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), patchCannotFindCommons$str(), lib));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String patchIncompatibleProduct$str() {
        return "Cannot create patch %s with patches for %s";
    }
    @Override
    public final IllegalStateException patchIncompatibleProduct(final String localBrand, final String patchBrand) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), patchIncompatibleProduct$str(), localBrand, patchBrand));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String patchCannotWritePatchesFile$str() {
        return "Could not write patches file";
    }
    @Override
    public final IllegalStateException patchCannotWritePatchesFile(final IOException e) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), patchCannotWritePatchesFile$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String patchRollback$str() {
        return "Rolled back patch %s";
    }
    @Override
    public final String patchRollback(final PatchInfo patchInfo) {
        return String.format(getLoggingLocale(), patchRollback$str(), patchInfo);
    }
    protected String patchDryRun$str() {
        return "[Dry run] ";
    }
    @Override
    public final String patchDryRun() {
        return String.format(getLoggingLocale(), patchDryRun$str());
    }
    protected String patchBackup$str() {
        return "Backing up '%s' to '%s'";
    }
    @Override
    public final String patchBackup(final Path from, final Path to) {
        return String.format(getLoggingLocale(), patchBackup$str(), from, to);
    }
    protected String patchCreateError$str() {
        return "Error while creating patch";
    }
    @Override
    public final RuntimeException patchCreateError(final IOException e) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), patchCreateError$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String patchCreateAdd$str() {
        return "Adding file '%s'";
    }
    @Override
    public final String patchCreateAdd(final Path target) {
        return String.format(getLoggingLocale(), patchCreateAdd$str(), target);
    }
    protected String patchRollbackFile$str() {
        return "Rolling back file '%s'";
    }
    @Override
    public final String patchRollbackFile(final Path file) {
        return String.format(getLoggingLocale(), patchRollbackFile$str(), file);
    }
    protected String patchCannotRead$str() {
        return "Could not read %s";
    }
    @Override
    public final IllegalStateException patchCannotRead(final Path patchesFile, final IOException e) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), patchCannotRead$str(), patchesFile), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String patchFileAlreadyExists$str() {
        return "File '%s' already exists";
    }
    @Override
    public final FileAlreadyExistsException patchFileAlreadyExists(final Path patch) {
        final FileAlreadyExistsException result = new FileAlreadyExistsException(String.format(getLoggingLocale(), patchFileAlreadyExists$str(), patch));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String patchCreateArgumentsRequired$str() {
        return "At least three arguments are required: the patch file, the target server path and one or more source server paths";
    }
    @Override
    public final IllegalArgumentException patchCreateArgumentsRequired() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), patchCreateArgumentsRequired$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String patchArchiveArgumentRequired$str() {
        return "You must specify the path to a patch archive";
    }
    @Override
    public final IllegalArgumentException patchArchiveArgumentRequired() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), patchArchiveArgumentRequired$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String patchServerAndTargetMustBeDifferent$str() {
        return "Cannot create a patch from identical source and target server versions: %s";
    }
    @Override
    public final IllegalArgumentException patchServerAndTargetMustBeDifferent(final String version) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), patchServerAndTargetMustBeDifferent$str(), version));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String patchCorruptArchive$str() {
        return "The patch archive appears to have a corrupt entry for: %s";
    }
    @Override
    public final String patchCorruptArchive(final PatchOperation operation) {
        return String.format(getLoggingLocale(), patchCorruptArchive$str(), operation);
    }
    protected String downloadedFile$str() {
        return "Downloaded file '%s'";
    }
    @Override
    public final String downloadedFile(final String filename) {
        return String.format(getLoggingLocale(), downloadedFile$str(), filename);
    }
    protected String userToolUsername$str() {
        return "Specify a username: ";
    }
    @Override
    public final String userToolUsername() {
        return String.format(getLoggingLocale(), userToolUsername$str());
    }
    protected String userToolPassword$str() {
        return "Set a password for the user: ";
    }
    @Override
    public final String userToolPassword() {
        return String.format(getLoggingLocale(), userToolPassword$str());
    }
    protected String userToolPasswordConfirm$str() {
        return "Confirm the password for the user: ";
    }
    @Override
    public final String userToolPasswordConfirm() {
        return String.format(getLoggingLocale(), userToolPasswordConfirm$str());
    }
    protected String userToolUserExists$str() {
        return "User `%s` already exists";
    }
    @Override
    public final IllegalStateException userToolUserExists(final String username) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), userToolUserExists$str(), username));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String userToolIOError$str() {
        return "Error accessing file '%s'";
    }
    @Override
    public final RuntimeException userToolIOError(final Path path, final IOException e) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), userToolIOError$str(), path), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String userToolUnknownAlgorithm$str() {
        return "Unkown password encryption algorithm: '%s'";
    }
    @Override
    public final IllegalArgumentException userToolUnknownAlgorithm(final String algorithm) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), userToolUnknownAlgorithm$str(), algorithm));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String userToolNoSuchUser$str() {
        return "User `%s` does not exist";
    }
    @Override
    public final IllegalArgumentException userToolNoSuchUser(final String username) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), userToolNoSuchUser$str(), username));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String userDescribe$str() {
        return "{ username: \"%s\", realm: \"%s\", groups = %s }";
    }
    @Override
    public final String userDescribe(final String username, final String realm, final String[] userGroups) {
        return String.format(getLoggingLocale(), userDescribe$str(), username, realm, Arrays.toString(userGroups));
    }
    protected String invalidUnicodeSequence$str() {
        return "Invalid Unicode sequence '%s'";
    }
    @Override
    public final IOException invalidUnicodeSequence(final String sequence, final NoSuchElementException e) {
        final IOException result = new IOException(String.format(getLoggingLocale(), invalidUnicodeSequence$str(), sequence), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String userToolIncompatibleEncrypyion$str() {
        return "Attempt to use %s passwords, but only %s passwords are allowed";
    }
    @Override
    public final IllegalArgumentException userToolIncompatibleEncrypyion(final Encryption encryption1, final Encryption encryption2) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), userToolIncompatibleEncrypyion$str(), encryption1, encryption2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String userToolWrongRealm$str() {
        return "Attempted to use a different realm '%s' than the already existing one '%s'";
    }
    @Override
    public final IllegalArgumentException userToolWrongRealm(final String realm1, final String realm2) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), userToolWrongRealm$str(), realm1, realm2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String configLoadFailed$str() {
        return "Unable to load CLI configuration from `%s`. Using defaults.";
    }
    @Override
    public final String configLoadFailed(final String path) {
        return String.format(getLoggingLocale(), configLoadFailed$str(), path);
    }
    protected String configStoreFailed$str() {
        return "Unable to store CLI configuration to '%s'.";
    }
    @Override
    public final String configStoreFailed(final String path) {
        return String.format(getLoggingLocale(), configStoreFailed$str(), path);
    }
    protected String wrongArgumentCount$str() {
        return "Wrong argument count: %d.";
    }
    @Override
    public final IllegalArgumentException wrongArgumentCount(final int size) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), wrongArgumentCount$str(), size));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noSuchService$str() {
        return "Cannot find service '%s' in namespace '%s'";
    }
    @Override
    public final IllegalArgumentException noSuchService(final String serviceName, final String namespace) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), noSuchService$str(), serviceName, namespace));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noGeneratedSecret$str() {
        return "Cannot find or access generated secrets for service '%s'";
    }
    @Override
    public final IllegalStateException noGeneratedSecret(final String serviceName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noGeneratedSecret$str(), serviceName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noDefaultNamespace$str() {
        return "A namespace was not specified and a default has not been set";
    }
    @Override
    public final IllegalStateException noDefaultNamespace() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noDefaultNamespace$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String credentialToolPassword$str() {
        return "Enter the password for the credential keystore: ";
    }
    @Override
    public final String credentialToolPassword() {
        return String.format(getLoggingLocale(), credentialToolPassword$str());
    }
    protected String credentialToolPasswordConfirm$str() {
        return "Confirm the password for the credential store: ";
    }
    @Override
    public final String credentialToolPasswordConfirm() {
        return String.format(getLoggingLocale(), credentialToolPasswordConfirm$str());
    }
    protected String credentialToolCredential$str() {
        return "Set a credential for the alias: ";
    }
    @Override
    public final String credentialToolCredential() {
        return String.format(getLoggingLocale(), credentialToolCredential$str());
    }
    protected String credentialToolCredentialConfirm$str() {
        return "Confirm the credential: ";
    }
    @Override
    public final String credentialToolCredentialConfirm() {
        return String.format(getLoggingLocale(), credentialToolCredentialConfirm$str());
    }
    protected String illegalFilterRule$str() {
        return "Filter rule '%s' is not in the format [ACCEPT|REJECT]/{CIDR}";
    }
    @Override
    public final IllegalArgumentException illegalFilterRule(final String rule) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalFilterRule$str(), rule));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String batchError$str() {
        return "Error executing file: %s, line %d: '%s'";
    }
    @Override
    public final CommandException batchError(final String file, final int lineNumber, final String line, final Throwable t) {
        final CommandException result = new CommandException(String.format(getLoggingLocale(), batchError$str(), file, lineNumber, line), t);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String requiresAllOf$str() {
        return "Option '%s' requires option '%s'";
    }
    @Override
    public final RequiredOptionException requiresAllOf(final String option1, final String option2) {
        final RequiredOptionException result = new RequiredOptionException(String.format(getLoggingLocale(), requiresAllOf$str(), option1, option2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingCacheName$str() {
        return "The cache name is required";
    }
    @Override
    public final IllegalArgumentException missingCacheName() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), missingCacheName$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noCatalog$str() {
        return "Could not determine catalog source";
    }
    @Override
    public final IllegalStateException noCatalog() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noCatalog$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noTargetNamespaces$str() {
        return "Target namespaces must be specified when not installing globally";
    }
    @Override
    public final IllegalArgumentException noTargetNamespaces() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), noTargetNamespaces$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noDefaultOperatorNamespace$str() {
        return "Could not find a default operator namespace";
    }
    @Override
    public final IllegalStateException noDefaultOperatorNamespace() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noDefaultOperatorNamespace$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noKubernetes$str() {
        return "Kubernetes client is unavailable in this mode";
    }
    @Override
    public final IllegalStateException noKubernetes() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noKubernetes$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noOperatorSubscription$str() {
        return "Could not find an operator subscription in namespace '%s'";
    }
    @Override
    public final IllegalStateException noOperatorSubscription(final String namespace) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noOperatorSubscription$str(), namespace));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String exposeTypeRequiresPort$str() {
        return "Expose type '%s' requires a port";
    }
    @Override
    public final IllegalArgumentException exposeTypeRequiresPort(final String exposeType) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), exposeTypeRequiresPort$str(), exposeType));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String encryptionTypeRequiresSecret$str() {
        return "Encryption type '%s' requires a secret name";
    }
    @Override
    public final IllegalArgumentException encryptionTypeRequiresSecret(final String encryptionType) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), encryptionTypeRequiresSecret$str(), encryptionType));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noRunningPodsInService$str() {
        return "No running pods available in service %s";
    }
    @Override
    public final IllegalStateException noRunningPodsInService(final String name) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noRunningPodsInService$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String usernameRequired$str() {
        return "A username must be specified";
    }
    @Override
    public final IllegalArgumentException usernameRequired() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), usernameRequired$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String checksumFailed$str() {
        return "Checksum for '%s' does not match. Supplied: %s Actual: %s";
    }
    @Override
    public final SecurityException checksumFailed(final String path, final String checksum, final String computed) {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), checksumFailed$str(), path, checksum, computed));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String checksumVerified$str() {
        return "Checksum for '%s' verified";
    }
    @Override
    public final String checksumVerified(final String path) {
        return String.format(getLoggingLocale(), checksumVerified$str(), path);
    }
    protected String artifactNotFound$str() {
        return "Artifact '%s' not found";
    }
    @Override
    public final IllegalArgumentException artifactNotFound(final String path) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), artifactNotFound$str(), path));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String retryDownload$str() {
        return "Retry download '%d/%d'";
    }
    @Override
    public final String retryDownload(final int retry, final int retries) {
        return String.format(getLoggingLocale(), retryDownload$str(), retry, retries);
    }
    protected String unsupportedListFormat$str() {
        return "The resource does not support the '%s' list format";
    }
    @Override
    public final IllegalArgumentException unsupportedListFormat(final ListFormat format) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unsupportedListFormat$str(), format));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nonExistentFile$str() {
        return "File '%s' does not exist";
    }
    @Override
    public final NoSuchFileException nonExistentFile(final Resource file) {
        final NoSuchFileException result = new NoSuchFileException(String.format(getLoggingLocale(), nonExistentFile$str(), file));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
