/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.util;

import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.MessageDigest;
import org.infinispan.commons.util.Util;

public class Utils {
    public static final int BUFFER_SIZE = 8192;

    public static String sha256(Path path) {
        return Utils.digest(path, "SHA-256");
    }

    public static String digest(Path path, String algorithm) {
        String string;
        block12: {
            SeekableByteChannel channel = Files.newByteChannel(path, StandardOpenOption.READ);
            try {
                MessageDigest digest = MessageDigest.getInstance(algorithm);
                if (channel instanceof FileChannel) {
                    FileChannel fileChannel = (FileChannel)channel;
                    MappedByteBuffer byteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size());
                    digest.update(byteBuffer);
                } else {
                    ByteBuffer bb = ByteBuffer.allocate(8192);
                    while (channel.read(bb) != -1) {
                        bb.flip();
                        digest.update(bb);
                        bb.flip();
                    }
                }
                string = Util.toHexString((byte[])digest.digest());
                if (channel == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchFileException e) {
                    return null;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            channel.close();
        }
        return string;
    }
}

