/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.connection;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.infinispan.cli.Context;
import org.infinispan.cli.connection.Connection;

public class JMXConnection
implements Connection {
    private static final QueryExp INTERPRETER_QUERY = JMXConnection.createObjectName("*:type=CacheManager,component=Interpreter,name=*");
    private JMXConnector jmxConnector;
    private Map<String, ObjectInstance> cacheManagers;
    private Map<String, String> sessions;
    private String activeCacheManager;
    private final JMXUrl serviceUrl;
    private MBeanServerConnection mbsc;

    public JMXConnection(String connectionString) {
        this.serviceUrl = new JMXUrl(connectionString);
    }

    @Override
    public void connect(Context context) throws Exception {
        JMXServiceURL url = new JMXServiceURL(this.serviceUrl.getUrl());
        HashMap<String, String[]> env = new HashMap<String, String[]>();
        if (this.serviceUrl.username != null || this.serviceUrl.password != null) {
            env.put("jmx.remote.credentials", new String[]{this.serviceUrl.username, this.serviceUrl.password});
        }
        this.jmxConnector = JMXConnectorFactory.connect(url, env);
        this.mbsc = this.jmxConnector.getMBeanServerConnection();
        this.cacheManagers = new TreeMap<String, ObjectInstance>();
        for (ObjectInstance mbean : this.mbsc.queryMBeans(null, INTERPRETER_QUERY)) {
            this.cacheManagers.put(JMXConnection.unquote(mbean.getObjectName().getKeyProperty("name")), mbean);
        }
        this.cacheManagers = Collections.unmodifiableMap(this.cacheManagers);
        this.activeCacheManager = this.cacheManagers.keySet().iterator().next();
        this.sessions = new HashMap<String, String>();
    }

    @Override
    public boolean isConnected() {
        return this.jmxConnector != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.jmxConnector != null) {
            try {
                this.jmxConnector.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.mbsc = null;
                this.jmxConnector = null;
            }
        }
    }

    public String toString() {
        return this.serviceUrl.toString();
    }

    @Override
    public Collection<String> getAvailableContainers() {
        return this.cacheManagers.keySet();
    }

    @Override
    public String getActiveContainer() {
        return this.activeCacheManager;
    }

    @Override
    public void setActiveContainer(String name) {
        if (!this.cacheManagers.containsKey(name)) {
            throw new IllegalArgumentException(name);
        }
        this.activeCacheManager = name;
    }

    public Collection<String> getAvailableCacheNames() {
        ObjectInstance manager = this.cacheManagers.get(this.activeCacheManager);
        try {
            String[] cacheNames = (String[])this.mbsc.invoke(manager.getObjectName(), "getCacheNames", new Object[0], new String[0]);
            List<String> cacheList = Arrays.asList(cacheNames);
            Collections.sort(cacheList);
            return cacheList;
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Context context) {
        ObjectInstance manager = this.cacheManagers.get(this.activeCacheManager);
        String sessionId = this.sessions.get(this.activeCacheManager);
        try {
            String result;
            if (sessionId == null) {
                sessionId = (String)this.mbsc.invoke(manager.getObjectName(), "createSessionId", new Object[0], new String[0]);
                this.sessions.put(this.activeCacheManager, sessionId);
            }
            if ((result = (String)this.mbsc.invoke(manager.getObjectName(), "execute", new String[]{sessionId, context.getCommandBuffer().toString()}, new String[]{String.class.getName(), String.class.getName()})) != null) {
                context.println(result);
            }
        }
        catch (InstanceNotFoundException e) {
            context.error(e);
        }
        catch (MBeanException e) {
            Exception te = e.getTargetException();
            context.error(te.getCause() != null ? te.getCause() : te);
        }
        catch (ReflectionException e) {
            context.error(e);
        }
        catch (IOException e) {
            context.error(e);
        }
        finally {
            context.getCommandBuffer().reset();
        }
    }

    private static ObjectName createObjectName(String name) {
        try {
            return new ObjectName(name);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    public static String unquote(String s) {
        if (s != null && (s.startsWith("\"") && s.endsWith("\"") || s.startsWith("'") && s.endsWith("'"))) {
            s = s.substring(1, s.length() - 1);
        }
        return s;
    }

    public static class JMXUrl {
        private static final Pattern JMX_URL = Pattern.compile("^(?:(?![^:@]+:[^:@/]*@)([^:/?#.]+):)?(?://)?((?:(([^:@]*):?([^:@]*))?@)?([^:/?#]*)(?::(\\d*))?)");
        private String hostname;
        private int port;
        private String username;
        private String password;

        public String getUrl() {
            return "service:jmx:rmi:///jndi/rmi://" + this.hostname + ":" + this.port + "/jmxrmi";
        }

        public JMXUrl(String connectionString) {
            Matcher matcher = JMX_URL.matcher(connectionString);
            if (!matcher.matches()) {
                throw new IllegalArgumentException(connectionString);
            }
            this.username = matcher.group(4);
            this.password = matcher.group(5);
            this.hostname = matcher.group(6);
            this.port = Integer.parseInt(matcher.group(7));
        }

        public String toString() {
            return "jmx://" + (this.username == null ? "" : this.username + "@") + this.hostname + ":" + this.port;
        }
    }
}

