/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.io;

import java.io.IOException;
import org.fusesource.jansi.Ansi;
import org.infinispan.cli.io.IOAdapter;
import org.jboss.jreadline.console.Console;

public class ConsoleIOAdapter
implements IOAdapter {
    private final Console console;

    public ConsoleIOAdapter(Console console) {
        this.console = console;
    }

    @Override
    public boolean isInteractive() {
        return true;
    }

    @Override
    public String readln(String prompt) throws IOException {
        return this.console.read(prompt);
    }

    @Override
    public String secureReadln(String prompt) throws IOException {
        return this.console.read(prompt, Character.valueOf('\u0000'));
    }

    @Override
    public void println(String s) throws IOException {
        this.console.pushToConsole(s);
        this.console.pushToConsole("\n");
    }

    @Override
    public void error(String s) throws IOException {
        Ansi ansi = new Ansi();
        ansi.fg(Ansi.Color.RED);
        this.println(ansi.render(s).reset().toString());
    }

    @Override
    public int getWidth() {
        return this.console.getTerminalWidth();
    }

    @Override
    public void close() throws IOException {
        this.console.stop();
    }
}

