/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.infinispan.cli.commands.Argument;
import org.infinispan.cli.commands.Parameter;

public class ProcessedCommand {
    final String command;
    final String line;
    final List<Argument> arguments;
    final boolean commandComplete;

    public ProcessedCommand(String raw) {
        this.commandComplete = this.ltrim(raw).indexOf(32) > 0;
        this.line = raw.trim();
        int sep = this.line.indexOf(32);
        this.command = sep > 0 ? this.line.substring(0, sep) : this.line;
        this.arguments = new ArrayList<Argument>();
        this.splitArguments(sep > 0 ? this.line.substring(sep + 1) : "", sep + 1);
    }

    private String ltrim(String s) {
        int st;
        int len = s.length();
        for (st = 0; st < len && s.charAt(st) <= ' '; ++st) {
        }
        return st > 0 ? s.substring(st) : s;
    }

    private void splitArguments(String s, int offset) {
        Pattern regex = Pattern.compile("[^\\s\"']+|\"([^\"]*)\"|'([^']*)'");
        Matcher regexMatcher = regex.matcher(s);
        while (regexMatcher.find()) {
            if (regexMatcher.group(1) != null) {
                this.arguments.add(new Parameter(regexMatcher.group(1), offset + regexMatcher.start(1)));
                continue;
            }
            if (regexMatcher.group(2) != null) {
                this.arguments.add(new Parameter(regexMatcher.group(2), offset + regexMatcher.start(2)));
                continue;
            }
            this.arguments.add(new Parameter(regexMatcher.group(), offset + regexMatcher.start()));
        }
    }

    public String getCommand() {
        return this.command;
    }

    public String getCommandLine() {
        return this.line;
    }

    public List<Argument> getArguments() {
        return this.arguments;
    }

    public boolean isCommandComplete() {
        return this.commandComplete;
    }
}

