/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.shell;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.infinispan.cli.Context;
import org.infinispan.cli.commands.Argument;
import org.infinispan.cli.commands.Command;
import org.infinispan.cli.commands.ProcessedCommand;
import org.jboss.jreadline.complete.CompleteOperation;
import org.jboss.jreadline.complete.Completion;

public class Completer
implements Completion {
    private final Context context;

    public Completer(Context context) {
        this.context = context;
    }

    public void complete(CompleteOperation op) {
        String buffer = op.getBuffer();
        List candidates = op.getCompletionCandidates();
        if (buffer.isEmpty()) {
            for (String name : this.context.getCommandRegistry().getCommandNames()) {
                Command command = this.context.getCommandRegistry().getCommand(name);
                if (!command.isAvailable(this.context)) continue;
                candidates.add(name);
            }
        } else {
            ProcessedCommand procCmd = new ProcessedCommand(buffer);
            if (!procCmd.isCommandComplete()) {
                for (String name : this.context.getCommandRegistry().getCommandNames()) {
                    Command command = this.context.getCommandRegistry().getCommand(name);
                    if (!command.isAvailable(this.context) || !name.startsWith(procCmd.getCommand())) continue;
                    candidates.add(name);
                }
            } else {
                Command command = this.context.getCommandRegistry().getCommand(procCmd.getCommand());
                if (command.isAvailable(this.context)) {
                    for (Argument arg : procCmd.getArguments()) {
                        if (arg.getOffset() >= op.getCursor()) break;
                        op.setOffset(arg.getOffset());
                    }
                    command.complete(this.context, procCmd, candidates);
                }
            }
        }
        Collections.sort(candidates);
    }

    public static void addPrefixMatches(String prefix, Collection<String> all, List<String> candidates) {
        if (prefix == null) {
            candidates.addAll(all);
        } else {
            for (String s : all) {
                if (!s.startsWith(prefix)) continue;
                candidates.add(s);
            }
        }
    }
}

