/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.shell;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.File;
import org.fusesource.jansi.Ansi;
import org.infinispan.cli.Config;
import org.infinispan.cli.Context;
import org.infinispan.cli.commands.Command;
import org.infinispan.cli.commands.ProcessedCommand;
import org.infinispan.cli.commands.client.Version;
import org.infinispan.cli.connection.Connection;
import org.infinispan.cli.connection.ConnectionFactory;
import org.infinispan.cli.impl.CommandBufferImpl;
import org.infinispan.cli.impl.ContextImpl;
import org.infinispan.cli.io.ConsoleIOAdapter;
import org.infinispan.cli.io.StreamIOAdapter;
import org.infinispan.cli.shell.Color;
import org.infinispan.cli.shell.Completer;
import org.infinispan.cli.shell.ConfigImpl;
import org.infinispan.cli.shell.Prompt;
import org.infinispan.cli.shell.Shell;
import org.infinispan.cli.util.SystemUtils;
import org.jboss.jreadline.complete.Completion;
import org.jboss.jreadline.console.Console;
import org.jboss.jreadline.console.settings.Settings;

public class ShellImpl
implements Shell {
    private Config config;
    private Console console;
    private Context context;

    @Override
    public void init(String[] args) throws Exception {
        int c;
        this.context = new ContextImpl(new StreamIOAdapter(), new CommandBufferImpl());
        String sopts = "hc:v";
        LongOpt[] lopts = new LongOpt[]{new LongOpt("connect", 1, null, 99), new LongOpt("help", 0, null, 104), new LongOpt("version", 0, null, 118)};
        Getopt g = new Getopt("ispn-cli", args, sopts, lopts);
        while ((c = g.getopt()) != -1) {
            switch (c) {
                case 99: {
                    Connection connection = ConnectionFactory.getConnection(g.getOptarg());
                    connection.connect(this.context);
                    this.context.setConnection(connection);
                    break;
                }
                case 104: {
                    this.help();
                    break;
                }
                case 118: {
                    this.version();
                }
            }
        }
        this.config = new ConfigImpl(SystemUtils.getAppConfigFolder("InfinispanShell"));
        this.config.load();
        Settings settings = Settings.getInstance();
        settings.setReadInputrc(false);
        this.console = new Console(settings);
        this.context.setOutputAdapter(new ConsoleIOAdapter(this.console));
        this.console.addCompletion((Completion)new Completer(this.context));
    }

    @Override
    public void run() {
        while (!this.context.isQuitting()) {
            try {
                this.context.refreshProperties();
                String line = this.console.read(this.getPrompt());
                if (line == null || "".equals(line.trim())) continue;
                this.execute(line);
            }
            catch (Exception e) {
                this.context.error(e);
            }
        }
        try {
            this.config.save();
            this.console.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void execute(String line) {
        ProcessedCommand parsed = new ProcessedCommand(line);
        Command command = this.context.getCommandRegistry().getCommand(parsed.getCommand());
        if (command != null) {
            command.execute(this.context, parsed);
        } else {
            this.context.println("Command " + parsed.getCommand() + " unknown or not available");
        }
    }

    private String getPrompt() {
        return Prompt.echo(this, Prompt.promptExpressionParser(this, this.config.getPrompt()));
    }

    @Override
    public String renderColor(Color color, String output) {
        if (!this.config.isColorEnabled()) {
            return output;
        }
        Ansi ansi = new Ansi();
        switch (color) {
            case BLACK: {
                ansi.fg(Ansi.Color.BLACK);
                break;
            }
            case BLUE: {
                ansi.fg(Ansi.Color.BLUE);
                break;
            }
            case CYAN: {
                ansi.fg(Ansi.Color.CYAN);
                break;
            }
            case GREEN: {
                ansi.fg(Ansi.Color.GREEN);
                break;
            }
            case MAGENTA: {
                ansi.fg(Ansi.Color.MAGENTA);
                break;
            }
            case RED: {
                ansi.fg(Ansi.Color.RED);
                break;
            }
            case WHITE: {
                ansi.fg(Ansi.Color.WHITE);
                break;
            }
            case YELLOW: {
                ansi.fg(Ansi.Color.YELLOW);
                break;
            }
            case BOLD: {
                ansi.a(Ansi.Attribute.INTENSITY_BOLD);
                break;
            }
            case ITALIC: {
                ansi.a(Ansi.Attribute.ITALIC);
                ansi.a(Ansi.Attribute.INTENSITY_FAINT);
                break;
            }
            default: {
                return output;
            }
        }
        return ansi.render(output).reset().toString();
    }

    @Override
    public String getCWD() {
        File directory = new File(".");
        return directory.getAbsolutePath();
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    private void help() {
        System.out.println("Usage: ispn-cli [OPTION]...");
        System.out.println("Command-line interface for interacting with a running instance of Infinispan");
        System.out.println();
        System.out.println("Options:");
        System.out.println("  -c, --connect=URL       connects to a running instance of Infinispan. Currently only ");
        System.out.println("                          supports JMX via the following URL format: jmx://host:port");
        System.out.println("  -h, --help              shows this help page");
        System.out.println("  -v, --version           shows version information");
        System.exit(0);
    }

    private void version() {
        System.out.println("ispn-cli " + Version.class.getPackage().getImplementationVersion());
        System.out.println("Copyright (C) 2012 Red Hat Inc. and/or its affiliates and other contributors");
        System.out.println("License GNU Lesser General Public License, v. 2.1. http://www.gnu.org/licenses/lgpl-2.1.txt");
        System.exit(0);
    }
}

