/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.connection.jmx.remoting;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.infinispan.cli.connection.jmx.JMXUrl;

public class JMXRemotingUrl
implements JMXUrl {
    private static final Pattern JMX_URL = Pattern.compile("^(?:(?![^:@]+:[^:@/]*@)(remoting):)?(?://)?((?:(([^:@]*):?([^:@]*))?@)?([^:/?#]*)(?::(\\d*))?)(?:/([^/]*)(?:/(.*))?)?");
    private static final int DEFAULT_REMOTING_PORT = 9999;
    protected final String hostname;
    protected final int port;
    protected final String username;
    protected final String password;
    protected final String container;
    protected final String cache;

    public JMXRemotingUrl(String connectionString) {
        Matcher matcher = JMX_URL.matcher(connectionString);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(connectionString);
        }
        this.username = matcher.group(4);
        this.password = matcher.group(5);
        this.hostname = matcher.group(6);
        this.port = matcher.group(7) != null ? Integer.parseInt(matcher.group(7)) : 9999;
        this.container = matcher.group(8);
        this.cache = matcher.group(9);
    }

    @Override
    public String getJMXServiceURL() {
        return "service:jmx:remoting-jmx://" + this.hostname + ":" + this.port;
    }

    @Override
    public String getContainer() {
        return this.container;
    }

    @Override
    public String getCache() {
        return this.cache;
    }

    @Override
    public Map<String, Object> getConnectionEnvironment() {
        HashMap<String, Object> env = new HashMap<String, Object>();
        if (this.username != null || this.password != null) {
            env.put("jmx.remote.credentials", new String[]{this.username, this.password});
        }
        return env;
    }

    public String toString() {
        return "remoting://" + (this.username == null ? "" : this.username + "@") + this.hostname + ":" + this.port;
    }
}

