/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.connection.jmx;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.infinispan.cli.Context;
import org.infinispan.cli.connection.Connection;
import org.infinispan.cli.connection.jmx.JMXUrl;

public class JMXConnection
implements Connection {
    private static final QueryExp INTERPRETER_QUERY = JMXConnection.createObjectName("*:type=CacheManager,component=Interpreter,name=*");
    private JMXConnector jmxConnector;
    private Map<String, ObjectInstance> cacheManagers;
    private Map<String, String> sessions;
    private String activeCacheManager;
    private String activeCache;
    private final JMXUrl serviceUrl;
    private MBeanServerConnection mbsc;

    public JMXConnection(JMXUrl serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    @Override
    public void connect(Context context) throws Exception {
        JMXServiceURL url = new JMXServiceURL(this.serviceUrl.getJMXServiceURL());
        this.jmxConnector = JMXConnectorFactory.connect(url, this.serviceUrl.getConnectionEnvironment());
        this.mbsc = this.jmxConnector.getMBeanServerConnection();
        this.cacheManagers = new TreeMap<String, ObjectInstance>();
        for (ObjectInstance mbean : this.mbsc.queryMBeans(null, INTERPRETER_QUERY)) {
            if (!"org.infinispan.cli.interpreter.Interpreter".equals(mbean.getClassName())) continue;
            this.cacheManagers.put(JMXConnection.unquote(mbean.getObjectName().getKeyProperty("name")), mbean);
        }
        if (this.cacheManagers.size() == 0) {
            throw new IllegalArgumentException("The remote server does not expose any CacheManagers");
        }
        this.sessions = new HashMap<String, String>();
        this.cacheManagers = Collections.unmodifiableMap(this.cacheManagers);
        this.activeCacheManager = this.serviceUrl.getContainer();
        if (this.activeCacheManager == null) {
            this.activeCacheManager = this.cacheManagers.keySet().iterator().next();
        } else if (!this.cacheManagers.containsKey(this.activeCacheManager)) {
            throw new Exception("No such container: " + this.activeCacheManager);
        }
        this.activeCache = this.serviceUrl.getCache();
        if (this.activeCache != null) {
            try {
                this.getSession(this.cacheManagers.get(this.activeCacheManager));
            }
            catch (MBeanException e) {
                Throwable ue = this.unwrapException(e);
                throw new Exception(ue.getMessage(), ue);
            }
        }
    }

    private Throwable unwrapException(MBeanException e) {
        Exception te = e.getTargetException();
        if (te != null) {
            if (te instanceof InvocationTargetException) {
                return ((InvocationTargetException)te).getCause();
            }
            return te;
        }
        return e;
    }

    @Override
    public boolean isConnected() {
        return this.jmxConnector != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.jmxConnector != null) {
            try {
                this.jmxConnector.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.mbsc = null;
                this.jmxConnector = null;
            }
        }
    }

    public String toString() {
        return this.serviceUrl.toString();
    }

    @Override
    public String getActiveCache() {
        return this.activeCache;
    }

    @Override
    public Collection<String> getAvailableContainers() {
        return this.cacheManagers.keySet();
    }

    @Override
    public String getActiveContainer() {
        return this.activeCacheManager;
    }

    @Override
    public void setActiveContainer(String name) {
        if (!this.cacheManagers.containsKey(name)) {
            throw new IllegalArgumentException(name);
        }
        this.activeCacheManager = name;
    }

    @Override
    public Collection<String> getAvailableCaches() {
        ObjectInstance manager = this.cacheManagers.get(this.activeCacheManager);
        try {
            String[] cacheNames = (String[])this.mbsc.getAttribute(manager.getObjectName(), "cacheNames");
            List<String> cacheList = Arrays.asList(cacheNames);
            Collections.sort(cacheList);
            return cacheList;
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Context context) {
        ObjectInstance manager = this.cacheManagers.get(this.activeCacheManager);
        try {
            String sessionId = this.getSession(manager);
            Map response = (Map)this.mbsc.invoke(manager.getObjectName(), "execute", new String[]{sessionId, context.getCommandBuffer().toString()}, new String[]{String.class.getName(), String.class.getName()});
            if (response.containsKey("OUTPUT")) {
                context.println((String)response.get("OUTPUT"));
            }
            if (response.containsKey("ERROR")) {
                context.error((String)response.get("ERROR"));
            }
            if (response.containsKey("CACHE")) {
                this.activeCache = (String)response.get("CACHE");
            }
        }
        catch (InstanceNotFoundException e) {
            context.error(e);
        }
        catch (MBeanException e) {
            Exception te = e.getTargetException();
            context.error(te.getCause() != null ? te.getCause() : te);
        }
        catch (ReflectionException e) {
            context.error(e);
        }
        catch (IOException e) {
            context.error(e);
        }
        finally {
            context.getCommandBuffer().reset();
        }
    }

    private String getSession(ObjectInstance manager) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        String sessionId = this.sessions.get(this.activeCacheManager);
        if (sessionId == null) {
            sessionId = (String)this.mbsc.invoke(manager.getObjectName(), "createSessionId", new Object[]{this.activeCache}, new String[]{String.class.getName()});
            this.sessions.put(this.activeCacheManager, sessionId);
        }
        return sessionId;
    }

    private static ObjectName createObjectName(String name) {
        try {
            return new ObjectName(name);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    public static String unquote(String s) {
        if (s != null && (s.startsWith("\"") && s.endsWith("\"") || s.startsWith("'") && s.endsWith("'"))) {
            s = s.substring(1, s.length() - 1);
        }
        return s;
    }
}

