/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.connection.jmx.rmi;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.infinispan.cli.connection.jmx.JMXUrl;

public class JMXRMIUrl
implements JMXUrl {
    private static final Pattern JMX_URL = Pattern.compile("^(?:(?![^:@]+:[^:@/]*@)(jmx):)?(?://)?((?:(([^:@]*):?([^:@]*))?@)?([^:/?#]*)(?::(\\d*))?)(?:/([^/]*)(?:/(.*))?)?");
    protected final String hostname;
    protected final int port;
    protected final String username;
    protected final String password;
    protected final String container;
    protected final String cache;

    public JMXRMIUrl(String connectionString) {
        Matcher matcher = JMX_URL.matcher(connectionString);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(connectionString);
        }
        this.username = matcher.group(4);
        this.password = matcher.group(5);
        this.hostname = matcher.group(6);
        this.port = Integer.parseInt(matcher.group(7));
        this.container = matcher.group(8);
        this.cache = matcher.group(9);
    }

    @Override
    public String getJMXServiceURL() {
        return "service:jmx:rmi:///jndi/rmi://" + this.hostname + ":" + this.port + "/jmxrmi";
    }

    @Override
    public String getContainer() {
        return this.container;
    }

    @Override
    public String getCache() {
        return this.cache;
    }

    @Override
    public Map<String, Object> getConnectionEnvironment() {
        HashMap<String, Object> env = new HashMap<String, Object>();
        if (this.username != null || this.password != null) {
            env.put("jmx.remote.credentials", new String[]{this.username, this.password});
        }
        return env;
    }

    public String toString() {
        return "jmx://" + (this.username == null ? "" : this.username + "@") + this.hostname + ":" + this.port;
    }
}

