/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.connection.jmx.rmi;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.infinispan.cli.connection.jmx.AbstractJMXUrl;
import org.infinispan.cli.util.Utils;

public class JMXRMIUrl
extends AbstractJMXUrl {
    private static final Pattern JMX_URL = Pattern.compile("^(?:(?![^:@]+:[^:@/]*@)(jmx):)?(?://)?((?:(([^:@]*):?([^:@]*))?@)?([^:/?#]*)(?::(\\d*))?)(?:/([^/]*)(?:/(.*))?)?");

    public JMXRMIUrl(String connectionString) {
        Matcher matcher = JMX_URL.matcher(connectionString);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(connectionString);
        }
        this.username = Utils.nullIfEmpty(matcher.group(4));
        this.password = Utils.nullIfEmpty(matcher.group(5));
        this.hostname = Utils.nullIfEmpty(matcher.group(6));
        this.port = Integer.parseInt(matcher.group(7));
        this.container = Utils.nullIfEmpty(matcher.group(8));
        this.cache = Utils.nullIfEmpty(matcher.group(9));
    }

    @Override
    public String getJMXServiceURL() {
        return "service:jmx:rmi:///jndi/rmi://" + this.hostname + ":" + this.port + "/jmxrmi";
    }

    public String toString() {
        return "jmx://" + (this.username == null ? "" : this.username + "@") + this.hostname + ":" + this.port;
    }
}

