/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.shell;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fusesource.jansi.Ansi;

public class Man2Ansi {
    public static Pattern MAN_MACRO_REGEX = Pattern.compile("^(\\.[A-Z]{1,2} ?)?(.*)$");
    public static int DEFAULT_INDENT = 4;
    public static int WRAP_WIDTH = 72;
    private final Ansi ansi = new Ansi();
    private int pos = 0;
    private int indent = DEFAULT_INDENT;
    private boolean blankLine = true;
    private int screenWidth;

    public Man2Ansi(int screenWidth) {
        this.screenWidth = screenWidth;
    }

    public String render(InputStream is) throws IOException {
        BufferedReader r = new BufferedReader(new InputStreamReader(is));
        String line = r.readLine();
        while (line != null) {
            Matcher matcher = MAN_MACRO_REGEX.matcher(line);
            if (matcher.matches()) {
                String macro = matcher.group(1);
                String text = matcher.group(2);
                if (".B ".equals(macro)) {
                    this.fit(text, Ansi.Attribute.INTENSITY_BOLD);
                } else if (".I ".equals(macro)) {
                    this.fit(text, Ansi.Attribute.ITALIC);
                } else if (".SH ".equals(macro)) {
                    this.newline(false);
                    this.flushLeft();
                    this.newline(true);
                    this.fit(text, Ansi.Attribute.INTENSITY_BOLD);
                    this.resetIndent();
                    this.newline(true);
                } else if (".IP ".equals(macro)) {
                    this.resetIndent();
                    this.newline(false);
                    this.fit(text, new Ansi.Attribute[0]);
                    this.tab(DEFAULT_INDENT);
                } else if (".BR".equals(macro)) {
                    this.newline(false);
                } else {
                    this.fit(text, new Ansi.Attribute[0]);
                }
            }
            line = r.readLine();
        }
        return this.ansi.toString();
    }

    private void newline(boolean force) {
        if (force || !this.blankLine) {
            this.ansi.newline();
            this.indent();
        }
    }

    private void fit(String text, Ansi.Attribute ... attributes) {
        if (this.pos + text.length() > this.screenWidth) {
            int ideal = this.screenWidth - this.pos;
            int actual = text.lastIndexOf(32, ideal);
            if (actual > 0) {
                this.format(text.substring(0, actual), new Ansi.Attribute[0]);
                this.ansi.newline();
                this.indent();
                this.fit(text.substring(actual + 1), attributes);
                return;
            }
            this.ansi.newline();
            this.indent();
        }
        this.format(text, attributes);
        this.pos += text.length();
        this.blankLine = false;
    }

    private void format(String text, Ansi.Attribute ... attributes) {
        for (Ansi.Attribute attribute : attributes) {
            this.ansi.a(attribute);
        }
        this.ansi.render(text).reset();
    }

    private void tab(int add) {
        this.indent += add;
        if (this.pos >= this.indent) {
            this.newline(false);
        } else {
            while (this.pos < this.indent) {
                this.ansi.render(" ");
                ++this.pos;
            }
        }
    }

    private void indent() {
        this.indent(0);
    }

    private void indent(int add) {
        this.indent += add;
        for (int i = 0; i < this.indent; ++i) {
            this.ansi.render(" ");
        }
        this.pos = this.indent;
        this.blankLine = true;
    }

    private void resetIndent() {
        this.indent = DEFAULT_INDENT;
    }

    private void flushLeft() {
        this.indent = 0;
    }
}

