/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.infinispan.cli.commands.Command;

public class CommandRegistry {
    private Map<String, Command> commands = new HashMap<String, Command>();

    public CommandRegistry() {
        for (Command cmd : ServiceLoader.load(Command.class)) {
            String name = cmd.getName();
            if (this.commands.containsKey(name)) {
                throw new RuntimeException("Command " + cmd.getClass().getName() + " overrides " + this.commands.get(name).getClass().getName());
            }
            this.commands.put(name, cmd);
        }
    }

    public Set<String> getCommandNames() {
        return Collections.unmodifiableSet(this.commands.keySet());
    }

    public Command getCommand(String name) {
        return this.commands.get(name);
    }
}

