/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.cli.CommandBuffer;
import org.infinispan.cli.CommandRegistry;
import org.infinispan.cli.Context;
import org.infinispan.cli.connection.Connection;
import org.infinispan.cli.io.IOAdapter;

public class ContextImpl
implements Context {
    private final CommandBuffer commandBuffer;
    private final CommandRegistry commandRegistry;
    private IOAdapter outputAdapter;
    private Connection connection;
    private boolean quitting;
    private Map<String, String> env = new HashMap<String, String>();

    public ContextImpl(IOAdapter outputAdapter, CommandBuffer commandBuffer) {
        this.commandBuffer = commandBuffer;
        this.outputAdapter = outputAdapter;
        this.commandRegistry = new CommandRegistry();
    }

    @Override
    public void setOutputAdapter(IOAdapter outputAdapter) {
        if (this.outputAdapter != null) {
            try {
                this.outputAdapter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.outputAdapter = outputAdapter;
    }

    @Override
    public boolean isConnected() {
        return this.connection != null && this.connection.isConnected();
    }

    @Override
    public boolean isQuitting() {
        return this.quitting;
    }

    @Override
    public void setQuitting(boolean quitting) {
        this.quitting = quitting;
    }

    @Override
    public void setProperty(String key, String value) {
        this.env.put(key, value);
    }

    @Override
    public String getProperty(String key) {
        return this.env.get(key);
    }

    @Override
    public void println(String s) {
        try {
            this.outputAdapter.println(s);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void error(String s) {
        try {
            this.outputAdapter.error(s);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void error(Throwable t) {
        try {
            this.outputAdapter.error(t.getMessage() != null ? t.getMessage() : t.getClass().getName());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public CommandBuffer getCommandBuffer() {
        return this.commandBuffer;
    }

    @Override
    public void disconnect() {
        if (this.isConnected()) {
            try {
                this.connection.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.connection = null;
        }
    }

    @Override
    public void setConnection(Connection connection) {
        if (this.isConnected()) {
            throw new IllegalStateException("Still connected");
        }
        this.connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        try {
            this.connection.execute(this, this.commandBuffer);
        }
        finally {
            this.commandBuffer.reset();
        }
    }

    @Override
    public void execute(CommandBuffer commandBuffer) {
        this.connection.execute(this, commandBuffer);
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public CommandRegistry getCommandRegistry() {
        return this.commandRegistry;
    }

    @Override
    public IOAdapter getOutputAdapter() {
        return this.outputAdapter;
    }

    @Override
    public void refreshProperties() {
        this.setProperty("CONNECTION", this.connection != null ? this.connection.toString() : "disconnected");
        this.setProperty("CONTAINER", this.connection != null ? this.connection.getActiveContainer() : "");
        this.setProperty("CACHE", this.connection != null ? this.connection.getActiveCache() : "");
    }
}

