/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.io;

import java.io.IOException;
import org.fusesource.jansi.Ansi;
import org.infinispan.cli.io.IOAdapter;
import org.jboss.aesh.console.Console;
import org.jboss.aesh.console.Prompt;

public class ConsoleIOAdapter
implements IOAdapter {
    private final Console console;

    public ConsoleIOAdapter(Console console) {
        this.console = console;
    }

    @Override
    public boolean isInteractive() {
        return true;
    }

    @Override
    public String readln(String prompt) throws IOException {
        return this.console.read(prompt).getBuffer();
    }

    @Override
    public String secureReadln(String prompt) throws IOException {
        return this.console.read(new Prompt(prompt), Character.valueOf('\u0000')).getBuffer();
    }

    @Override
    public void println(String s) throws IOException {
        this.console.pushToStdOut(s);
        this.console.pushToStdOut("\n");
    }

    @Override
    public void error(String s) throws IOException {
        Ansi ansi = new Ansi();
        ansi.fg(Ansi.Color.RED);
        this.println(ansi.render(s).reset().toString());
    }

    @Override
    public int getWidth() {
        return this.console.getTerminalSize().getWidth();
    }

    @Override
    public void close() throws IOException {
        this.console.stop();
    }
}

