/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.connection.jmx.remoting;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.infinispan.cli.connection.jmx.AbstractJMXUrl;
import org.infinispan.cli.util.Utils;

public class JMXRemotingUrl
extends AbstractJMXUrl {
    private static final Pattern JMX_URL = Pattern.compile("^(?:(?![^:@]+:[^:@/]*@)(remoting):)?(?://)?((?:(([^:@]*):?([^:@]*))?@)?(\\[[0-9A-Fa-f:]+\\]|[^:/?#]*)(?::(\\d*))?)(?:/([^/]*)(?:/(.*))?)?");
    private static final int DEFAULT_REMOTING_PORT = 9999;

    public JMXRemotingUrl(String connectionString) {
        if (connectionString.length() == 0) {
            this.hostname = "localhost";
            this.port = 9999;
        } else {
            Matcher matcher = JMX_URL.matcher(connectionString);
            if (!matcher.matches()) {
                throw new IllegalArgumentException(connectionString);
            }
            this.username = Utils.nullIfEmpty(matcher.group(4));
            this.password = Utils.nullIfEmpty(matcher.group(5));
            this.hostname = Utils.nullIfEmpty(matcher.group(6));
            this.port = matcher.group(7) != null ? Integer.parseInt(matcher.group(7)) : 9999;
            this.container = Utils.nullIfEmpty(matcher.group(8));
            this.cache = Utils.nullIfEmpty(matcher.group(9));
        }
    }

    @Override
    public String getJMXServiceURL() {
        return "service:jmx:remoting-jmx://" + this.hostname + ":" + this.port;
    }

    public String toString() {
        return "remoting://" + (this.username == null ? "" : this.username + "@") + this.hostname + ":" + this.port;
    }
}

