/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.io;

import java.io.IOException;
import java.util.List;
import org.fusesource.jansi.Ansi;
import org.infinispan.cli.commands.ProcessedCommand;
import org.infinispan.cli.io.IOAdapter;
import org.jboss.aesh.console.Console;
import org.jboss.aesh.console.Prompt;

public class ConsoleIOAdapter
implements IOAdapter {
    private final Console console;

    public ConsoleIOAdapter(Console console) {
        this.console = console;
    }

    @Override
    public boolean isInteractive() {
        return true;
    }

    @Override
    public String readln(String prompt) throws IOException {
        return this.read(prompt, null);
    }

    @Override
    public String secureReadln(String prompt) throws IOException {
        return this.read(prompt, Character.valueOf('\u0000'));
    }

    @Override
    public void println(String s) throws IOException {
        this.console.getShell().out().println(s);
    }

    @Override
    public void error(String s) throws IOException {
        Ansi ansi = new Ansi();
        ansi.fg(Ansi.Color.RED);
        this.println(ansi.render(s).reset().toString());
    }

    @Override
    public void result(List<ProcessedCommand> commands, String result, boolean isError) throws IOException {
        if (isError) {
            this.error(result);
        } else {
            this.println(result);
        }
    }

    @Override
    public int getWidth() {
        return this.console.getTerminalSize().getWidth();
    }

    @Override
    public void close() throws IOException {
        this.console.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String read(String prompt, Character mask) {
        Prompt origPrompt = null;
        if (!this.console.getPrompt().getPromptAsString().equals(prompt)) {
            origPrompt = this.console.getPrompt();
            this.console.setPrompt(new Prompt(prompt, mask));
        }
        try {
            String string = this.console.getInputLine();
            return string;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            if (origPrompt != null) {
                this.console.setPrompt(origPrompt);
            }
        }
        return null;
    }
}

