/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.connection.jmx.remoting;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.infinispan.cli.connection.jmx.AbstractJMXUrl;
import org.infinispan.cli.util.Utils;

public abstract class JMXRemotingUrl
extends AbstractJMXUrl {
    public JMXRemotingUrl(String connectionString) {
        if (connectionString.length() == 0) {
            this.hostname = "localhost";
            this.port = this.getDefaultPort();
        } else {
            Matcher matcher = this.getUrlPattern().matcher(connectionString);
            if (!matcher.matches()) {
                throw new IllegalArgumentException(connectionString);
            }
            this.username = Utils.nullIfEmpty(matcher.group(4));
            this.password = Utils.nullIfEmpty(matcher.group(5));
            this.hostname = Utils.nullIfEmpty(matcher.group(6));
            this.port = matcher.group(7) != null ? Integer.parseInt(matcher.group(7)) : this.getDefaultPort();
            this.container = Utils.nullIfEmpty(matcher.group(8));
            this.cache = Utils.nullIfEmpty(matcher.group(9));
        }
    }

    private Pattern getUrlPattern() {
        return Pattern.compile("^(?:(?![^:@]+:[^:@/]*@)(" + this.getProtocol() + "):)?(?://)?((?:(([^:@]*):?([^:@]*))?@)?(\\[[0-9A-Fa-f:]+\\]|[^:/?#]*)(?::(\\d*))?)(?:/([^/]*)(?:/(.*))?)?");
    }

    abstract String getProtocol();

    abstract int getDefaultPort();

    @Override
    public String getJMXServiceURL() {
        return "service:jmx:" + this.getProtocol() + "-jmx://" + this.hostname + ":" + this.port;
    }

    public String toString() {
        return this.getProtocol() + "://" + (this.username == null ? "" : this.username + "@") + this.hostname + ":" + this.port;
    }
}

