/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter.statement;

import java.util.List;
import org.infinispan.cli.interpreter.codec.Codec;
import org.infinispan.cli.interpreter.logging.Log;
import org.infinispan.cli.interpreter.result.StatementException;
import org.infinispan.cli.interpreter.session.Session;
import org.infinispan.cli.interpreter.statement.Option;
import org.infinispan.cli.interpreter.statement.Statement;
import org.infinispan.util.logging.LogFactory;

public abstract class CodecAwareStatement
implements Statement {
    private static final Log log = (Log)LogFactory.getLog(CodecAwareStatement.class, Log.class);
    private final List<Option> options;

    CodecAwareStatement(List<Option> options) {
        this.options = options;
    }

    Codec getCodec(Session session) throws StatementException {
        if (this.options.size() > 0) {
            for (Option option : this.options) {
                switch (option.toEnum(Options.class)) {
                    case CODEC: {
                        if (option.getParameter() == null) {
                            throw log.missingOptionParameter(option.getName());
                        }
                        return session.getCodec(option.getParameter());
                    }
                }
            }
        }
        return session.getCodec();
    }

    private static enum Options {
        CODEC;

    }
}

