// $ANTLR 3.4 org/infinispan/cli/interpreter/IspnQL.g 2012-07-20 11:32:30

/*
 * JBoss, Home of Professional Open Source
 * Copyright 2012 Red Hat Inc. and/or its affiliates and other contributors
 * as indicated by the @author tags. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
package org.infinispan.cli.interpreter;

import java.io.IOException;
import java.util.Map;
import java.util.HashMap;
import java.util.Collections;
import java.util.List;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.annotate.JsonTypeInfo;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.ObjectMapper.DefaultTyping;

import org.infinispan.cli.interpreter.session.*;
import org.infinispan.cli.interpreter.statement.*;
import static org.infinispan.cli.interpreter.utils.ParserSupport.*;



import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

import org.antlr.runtime.tree.*;


@SuppressWarnings({"all", "warnings", "unchecked"})
public class IspnQLParser extends Parser {
    public static final String[] tokenNames = new String[] {
        "<invalid>", "<EOR>", "<DOWN>", "<UP>", "ABORT", "AlphaChar", "AlphaNumChar", "BEGIN", "CACHE", "CLEAR", "COMMIT", "CharacterEscapeSequence", "Comment", "DOUBLELITERAL", "DecimalDigit", "DoubleQuotedStringCharacter", "DoubleSuffix", "END", "EOL", "EVICT", "EXPIRES", "EscapeCharacter", "EscapeSequence", "Exponent", "FALSE", "FLOATLITERAL", "FloatSuffix", "GET", "HexDigit", "HexEscapeSequence", "HexPrefix", "INTLITERAL", "IntegerNumber", "LOCATE", "LONGLITERAL", "LineComment", "LongSuffix", "MAXIDLE", "NULL", "NonEscapeCharacter", "NonIntegerNumber", "PUT", "PUTIFABSENT", "REMOVE", "REPLACE", "ROLLBACK", "START", "STRINGLITERAL", "SingleEscapeCharacter", "SingleQuotedStringCharacter", "TIMELITERAL", "TRUE", "TimeSuffix", "UUIDLITERAL", "UnicodeEscapeSequence", "UnquotedStringCharacter", "UnquotedStringStart", "WhiteSpace", "','", "'.'", "':'", "';'", "'['", "']'", "'{'", "'}'"
    };

    public static final int EOF=-1;
    public static final int T__58=58;
    public static final int T__59=59;
    public static final int T__60=60;
    public static final int T__61=61;
    public static final int T__62=62;
    public static final int T__63=63;
    public static final int T__64=64;
    public static final int T__65=65;
    public static final int ABORT=4;
    public static final int AlphaChar=5;
    public static final int AlphaNumChar=6;
    public static final int BEGIN=7;
    public static final int CACHE=8;
    public static final int CLEAR=9;
    public static final int COMMIT=10;
    public static final int CharacterEscapeSequence=11;
    public static final int Comment=12;
    public static final int DOUBLELITERAL=13;
    public static final int DecimalDigit=14;
    public static final int DoubleQuotedStringCharacter=15;
    public static final int DoubleSuffix=16;
    public static final int END=17;
    public static final int EOL=18;
    public static final int EVICT=19;
    public static final int EXPIRES=20;
    public static final int EscapeCharacter=21;
    public static final int EscapeSequence=22;
    public static final int Exponent=23;
    public static final int FALSE=24;
    public static final int FLOATLITERAL=25;
    public static final int FloatSuffix=26;
    public static final int GET=27;
    public static final int HexDigit=28;
    public static final int HexEscapeSequence=29;
    public static final int HexPrefix=30;
    public static final int INTLITERAL=31;
    public static final int IntegerNumber=32;
    public static final int LOCATE=33;
    public static final int LONGLITERAL=34;
    public static final int LineComment=35;
    public static final int LongSuffix=36;
    public static final int MAXIDLE=37;
    public static final int NULL=38;
    public static final int NonEscapeCharacter=39;
    public static final int NonIntegerNumber=40;
    public static final int PUT=41;
    public static final int PUTIFABSENT=42;
    public static final int REMOVE=43;
    public static final int REPLACE=44;
    public static final int ROLLBACK=45;
    public static final int START=46;
    public static final int STRINGLITERAL=47;
    public static final int SingleEscapeCharacter=48;
    public static final int SingleQuotedStringCharacter=49;
    public static final int TIMELITERAL=50;
    public static final int TRUE=51;
    public static final int TimeSuffix=52;
    public static final int UUIDLITERAL=53;
    public static final int UnicodeEscapeSequence=54;
    public static final int UnquotedStringCharacter=55;
    public static final int UnquotedStringStart=56;
    public static final int WhiteSpace=57;

    // delegates
    public Parser[] getDelegates() {
        return new Parser[] {};
    }

    // delegators


    public IspnQLParser(TokenStream input) {
        this(input, new RecognizerSharedState());
    }
    public IspnQLParser(TokenStream input, RecognizerSharedState state) {
        super(input, state);
    }

protected TreeAdaptor adaptor = new CommonTreeAdaptor();

public void setTreeAdaptor(TreeAdaptor adaptor) {
    this.adaptor = adaptor;
}
public TreeAdaptor getTreeAdaptor() {
    return adaptor;
}
    public String[] getTokenNames() { return IspnQLParser.tokenNames; }
    public String getGrammarFileName() { return "org/infinispan/cli/interpreter/IspnQL.g"; }


       private List<String> parserErrors = new ArrayList<String>();
       protected List<Statement> statements = new ArrayList<Statement>();
       private ObjectMapper jsonMapper = new ObjectMapper().enableDefaultTyping(DefaultTyping.NON_FINAL, JsonTypeInfo.As.WRAPPER_OBJECT);

       public void displayRecognitionError(String[] tokenNames, RecognitionException e) {
         parserErrors.add(getErrorHeader(e)+" "+getErrorMessage(e, tokenNames));
       }

       public List<String> getParserErrors() {
         return parserErrors;
       }


    public static class statements_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "statements"
    // org/infinispan/cli/interpreter/IspnQL.g:106:1: statements : ( statement ( EOL )* )* EOF ;
    public final IspnQLParser.statements_return statements() throws RecognitionException {
        IspnQLParser.statements_return retval = new IspnQLParser.statements_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token EOL2=null;
        Token EOF3=null;
        IspnQLParser.statement_return statement1 =null;


        Object EOL2_tree=null;
        Object EOF3_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:107:4: ( ( statement ( EOL )* )* EOF )
            // org/infinispan/cli/interpreter/IspnQL.g:107:6: ( statement ( EOL )* )* EOF
            {
            // org/infinispan/cli/interpreter/IspnQL.g:107:6: ( statement ( EOL )* )*
            loop2:
            do {
                int alt2=2;
                switch ( input.LA(1) ) {
                case ABORT:
                case BEGIN:
                case CACHE:
                case CLEAR:
                case COMMIT:
                case END:
                case EVICT:
                case GET:
                case LOCATE:
                case PUT:
                case PUTIFABSENT:
                case REMOVE:
                case REPLACE:
                case ROLLBACK:
                case START:
                    {
                    alt2=1;
                    }
                    break;

                }

                switch (alt2) {
            	case 1 :
            	    // org/infinispan/cli/interpreter/IspnQL.g:107:7: statement ( EOL )*
            	    {
            	    pushFollow(FOLLOW_statement_in_statements72);
            	    statement1=statement();

            	    state._fsp--;

            	    adaptor.addChild(root_0, statement1.getTree());

            	     statements.add((statement1!=null?statement1.stmt:null)); 

            	    // org/infinispan/cli/interpreter/IspnQL.g:107:54: ( EOL )*
            	    loop1:
            	    do {
            	        int alt1=2;
            	        switch ( input.LA(1) ) {
            	        case EOL:
            	            {
            	            alt1=1;
            	            }
            	            break;

            	        }

            	        switch (alt1) {
            	    	case 1 :
            	    	    // org/infinispan/cli/interpreter/IspnQL.g:107:54: EOL
            	    	    {
            	    	    EOL2=(Token)match(input,EOL,FOLLOW_EOL_in_statements76); 
            	    	    EOL2_tree = 
            	    	    (Object)adaptor.create(EOL2)
            	    	    ;
            	    	    adaptor.addChild(root_0, EOL2_tree);


            	    	    }
            	    	    break;

            	    	default :
            	    	    break loop1;
            	        }
            	    } while (true);


            	    }
            	    break;

            	default :
            	    break loop2;
                }
            } while (true);


            EOF3=(Token)match(input,EOF,FOLLOW_EOF_in_statements81); 
            EOF3_tree = 
            (Object)adaptor.create(EOF3)
            ;
            adaptor.addChild(root_0, EOF3_tree);


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "statements"


    public static class statement_return extends ParserRuleReturnScope {
        public Statement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "statement"
    // org/infinispan/cli/interpreter/IspnQL.g:110:1: statement returns [Statement stmt] : ( abortBatchStatement | beginTransactionStatement | cacheStatement | clearStatement | commitTransactionStatement | endBatchStatement | evictStatement | getStatement | locateStatement | putIfAbsentStatement | putStatement | removeStatement | replaceStatement | rollbackTransactionStatement | startBatchStatement );
    public final IspnQLParser.statement_return statement() throws RecognitionException {
        IspnQLParser.statement_return retval = new IspnQLParser.statement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        IspnQLParser.abortBatchStatement_return abortBatchStatement4 =null;

        IspnQLParser.beginTransactionStatement_return beginTransactionStatement5 =null;

        IspnQLParser.cacheStatement_return cacheStatement6 =null;

        IspnQLParser.clearStatement_return clearStatement7 =null;

        IspnQLParser.commitTransactionStatement_return commitTransactionStatement8 =null;

        IspnQLParser.endBatchStatement_return endBatchStatement9 =null;

        IspnQLParser.evictStatement_return evictStatement10 =null;

        IspnQLParser.getStatement_return getStatement11 =null;

        IspnQLParser.locateStatement_return locateStatement12 =null;

        IspnQLParser.putIfAbsentStatement_return putIfAbsentStatement13 =null;

        IspnQLParser.putStatement_return putStatement14 =null;

        IspnQLParser.removeStatement_return removeStatement15 =null;

        IspnQLParser.replaceStatement_return replaceStatement16 =null;

        IspnQLParser.rollbackTransactionStatement_return rollbackTransactionStatement17 =null;

        IspnQLParser.startBatchStatement_return startBatchStatement18 =null;



        try {
            // org/infinispan/cli/interpreter/IspnQL.g:111:4: ( abortBatchStatement | beginTransactionStatement | cacheStatement | clearStatement | commitTransactionStatement | endBatchStatement | evictStatement | getStatement | locateStatement | putIfAbsentStatement | putStatement | removeStatement | replaceStatement | rollbackTransactionStatement | startBatchStatement )
            int alt3=15;
            switch ( input.LA(1) ) {
            case ABORT:
                {
                alt3=1;
                }
                break;
            case BEGIN:
                {
                alt3=2;
                }
                break;
            case CACHE:
                {
                alt3=3;
                }
                break;
            case CLEAR:
                {
                alt3=4;
                }
                break;
            case COMMIT:
                {
                alt3=5;
                }
                break;
            case END:
                {
                alt3=6;
                }
                break;
            case EVICT:
                {
                alt3=7;
                }
                break;
            case GET:
                {
                alt3=8;
                }
                break;
            case LOCATE:
                {
                alt3=9;
                }
                break;
            case PUTIFABSENT:
                {
                alt3=10;
                }
                break;
            case PUT:
                {
                alt3=11;
                }
                break;
            case REMOVE:
                {
                alt3=12;
                }
                break;
            case REPLACE:
                {
                alt3=13;
                }
                break;
            case ROLLBACK:
                {
                alt3=14;
                }
                break;
            case START:
                {
                alt3=15;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 3, 0, input);

                throw nvae;

            }

            switch (alt3) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:111:6: abortBatchStatement
                    {
                    pushFollow(FOLLOW_abortBatchStatement_in_statement100);
                    abortBatchStatement4=abortBatchStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, abortBatchStatement4.getTree());

                     retval.stmt = (abortBatchStatement4!=null?abortBatchStatement4.stmt:null); 

                    }
                    break;
                case 2 :
                    // org/infinispan/cli/interpreter/IspnQL.g:112:6: beginTransactionStatement
                    {
                    pushFollow(FOLLOW_beginTransactionStatement_in_statement109);
                    beginTransactionStatement5=beginTransactionStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, beginTransactionStatement5.getTree());

                     retval.stmt = (beginTransactionStatement5!=null?beginTransactionStatement5.stmt:null); 

                    }
                    break;
                case 3 :
                    // org/infinispan/cli/interpreter/IspnQL.g:113:6: cacheStatement
                    {
                    pushFollow(FOLLOW_cacheStatement_in_statement118);
                    cacheStatement6=cacheStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, cacheStatement6.getTree());

                     retval.stmt = (cacheStatement6!=null?cacheStatement6.stmt:null); 

                    }
                    break;
                case 4 :
                    // org/infinispan/cli/interpreter/IspnQL.g:114:6: clearStatement
                    {
                    pushFollow(FOLLOW_clearStatement_in_statement127);
                    clearStatement7=clearStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, clearStatement7.getTree());

                     retval.stmt = (clearStatement7!=null?clearStatement7.stmt:null); 

                    }
                    break;
                case 5 :
                    // org/infinispan/cli/interpreter/IspnQL.g:115:6: commitTransactionStatement
                    {
                    pushFollow(FOLLOW_commitTransactionStatement_in_statement136);
                    commitTransactionStatement8=commitTransactionStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, commitTransactionStatement8.getTree());

                     retval.stmt = (commitTransactionStatement8!=null?commitTransactionStatement8.stmt:null); 

                    }
                    break;
                case 6 :
                    // org/infinispan/cli/interpreter/IspnQL.g:116:6: endBatchStatement
                    {
                    pushFollow(FOLLOW_endBatchStatement_in_statement145);
                    endBatchStatement9=endBatchStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, endBatchStatement9.getTree());

                     retval.stmt = (endBatchStatement9!=null?endBatchStatement9.stmt:null); 

                    }
                    break;
                case 7 :
                    // org/infinispan/cli/interpreter/IspnQL.g:117:6: evictStatement
                    {
                    pushFollow(FOLLOW_evictStatement_in_statement154);
                    evictStatement10=evictStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, evictStatement10.getTree());

                     retval.stmt = (evictStatement10!=null?evictStatement10.stmt:null); 

                    }
                    break;
                case 8 :
                    // org/infinispan/cli/interpreter/IspnQL.g:118:6: getStatement
                    {
                    pushFollow(FOLLOW_getStatement_in_statement163);
                    getStatement11=getStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, getStatement11.getTree());

                     retval.stmt = (getStatement11!=null?getStatement11.stmt:null); 

                    }
                    break;
                case 9 :
                    // org/infinispan/cli/interpreter/IspnQL.g:119:6: locateStatement
                    {
                    pushFollow(FOLLOW_locateStatement_in_statement172);
                    locateStatement12=locateStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, locateStatement12.getTree());

                     retval.stmt = (locateStatement12!=null?locateStatement12.stmt:null); 

                    }
                    break;
                case 10 :
                    // org/infinispan/cli/interpreter/IspnQL.g:120:6: putIfAbsentStatement
                    {
                    pushFollow(FOLLOW_putIfAbsentStatement_in_statement181);
                    putIfAbsentStatement13=putIfAbsentStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, putIfAbsentStatement13.getTree());

                     retval.stmt = (putIfAbsentStatement13!=null?putIfAbsentStatement13.stmt:null); 

                    }
                    break;
                case 11 :
                    // org/infinispan/cli/interpreter/IspnQL.g:121:6: putStatement
                    {
                    pushFollow(FOLLOW_putStatement_in_statement190);
                    putStatement14=putStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, putStatement14.getTree());

                     retval.stmt = (putStatement14!=null?putStatement14.stmt:null); 

                    }
                    break;
                case 12 :
                    // org/infinispan/cli/interpreter/IspnQL.g:122:6: removeStatement
                    {
                    pushFollow(FOLLOW_removeStatement_in_statement199);
                    removeStatement15=removeStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, removeStatement15.getTree());

                     retval.stmt = (removeStatement15!=null?removeStatement15.stmt:null); 

                    }
                    break;
                case 13 :
                    // org/infinispan/cli/interpreter/IspnQL.g:123:6: replaceStatement
                    {
                    pushFollow(FOLLOW_replaceStatement_in_statement208);
                    replaceStatement16=replaceStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, replaceStatement16.getTree());

                     retval.stmt = (replaceStatement16!=null?replaceStatement16.stmt:null); 

                    }
                    break;
                case 14 :
                    // org/infinispan/cli/interpreter/IspnQL.g:124:6: rollbackTransactionStatement
                    {
                    pushFollow(FOLLOW_rollbackTransactionStatement_in_statement217);
                    rollbackTransactionStatement17=rollbackTransactionStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, rollbackTransactionStatement17.getTree());

                     retval.stmt = (rollbackTransactionStatement17!=null?rollbackTransactionStatement17.stmt:null); 

                    }
                    break;
                case 15 :
                    // org/infinispan/cli/interpreter/IspnQL.g:125:6: startBatchStatement
                    {
                    pushFollow(FOLLOW_startBatchStatement_in_statement226);
                    startBatchStatement18=startBatchStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, startBatchStatement18.getTree());

                     retval.stmt = (startBatchStatement18!=null?startBatchStatement18.stmt:null); 

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "statement"


    public static class abortBatchStatement_return extends ParserRuleReturnScope {
        public EndBatchStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "abortBatchStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:129:1: abortBatchStatement returns [EndBatchStatement stmt] : ABORT (cacheName= STRINGLITERAL )? ( EOL | ';' ) !;
    public final IspnQLParser.abortBatchStatement_return abortBatchStatement() throws RecognitionException {
        IspnQLParser.abortBatchStatement_return retval = new IspnQLParser.abortBatchStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token cacheName=null;
        Token ABORT19=null;
        Token set20=null;

        Object cacheName_tree=null;
        Object ABORT19_tree=null;
        Object set20_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:130:4: ( ABORT (cacheName= STRINGLITERAL )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:130:6: ABORT (cacheName= STRINGLITERAL )? ( EOL | ';' ) !
            {
            ABORT19=(Token)match(input,ABORT,FOLLOW_ABORT_in_abortBatchStatement248); 
            ABORT19_tree = 
            (Object)adaptor.create(ABORT19)
            ;
            adaptor.addChild(root_0, ABORT19_tree);


            // org/infinispan/cli/interpreter/IspnQL.g:130:12: (cacheName= STRINGLITERAL )?
            int alt4=2;
            switch ( input.LA(1) ) {
                case STRINGLITERAL:
                    {
                    alt4=1;
                    }
                    break;
            }

            switch (alt4) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:130:13: cacheName= STRINGLITERAL
                    {
                    cacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_abortBatchStatement255); 
                    cacheName_tree = 
                    (Object)adaptor.create(cacheName)
                    ;
                    adaptor.addChild(root_0, cacheName_tree);


                    }
                    break;

            }


            set20=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==61 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new EndBatchStatement(unquote((cacheName!=null?cacheName.getText():null)), false); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "abortBatchStatement"


    public static class beginTransactionStatement_return extends ParserRuleReturnScope {
        public BeginTransactionStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "beginTransactionStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:133:1: beginTransactionStatement returns [BeginTransactionStatement stmt] : BEGIN (cacheName= STRINGLITERAL )? ( EOL | ';' ) !;
    public final IspnQLParser.beginTransactionStatement_return beginTransactionStatement() throws RecognitionException {
        IspnQLParser.beginTransactionStatement_return retval = new IspnQLParser.beginTransactionStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token cacheName=null;
        Token BEGIN21=null;
        Token set22=null;

        Object cacheName_tree=null;
        Object BEGIN21_tree=null;
        Object set22_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:134:4: ( BEGIN (cacheName= STRINGLITERAL )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:134:6: BEGIN (cacheName= STRINGLITERAL )? ( EOL | ';' ) !
            {
            BEGIN21=(Token)match(input,BEGIN,FOLLOW_BEGIN_in_beginTransactionStatement287); 
            BEGIN21_tree = 
            (Object)adaptor.create(BEGIN21)
            ;
            adaptor.addChild(root_0, BEGIN21_tree);


            // org/infinispan/cli/interpreter/IspnQL.g:134:12: (cacheName= STRINGLITERAL )?
            int alt5=2;
            switch ( input.LA(1) ) {
                case STRINGLITERAL:
                    {
                    alt5=1;
                    }
                    break;
            }

            switch (alt5) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:134:13: cacheName= STRINGLITERAL
                    {
                    cacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_beginTransactionStatement294); 
                    cacheName_tree = 
                    (Object)adaptor.create(cacheName)
                    ;
                    adaptor.addChild(root_0, cacheName_tree);


                    }
                    break;

            }


            set22=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==61 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new BeginTransactionStatement(unquote((cacheName!=null?cacheName.getText():null))); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "beginTransactionStatement"


    public static class cacheStatement_return extends ParserRuleReturnScope {
        public CacheStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "cacheStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:137:1: cacheStatement returns [CacheStatement stmt] : CACHE (cacheName= STRINGLITERAL )? ( EOL | ';' ) !;
    public final IspnQLParser.cacheStatement_return cacheStatement() throws RecognitionException {
        IspnQLParser.cacheStatement_return retval = new IspnQLParser.cacheStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token cacheName=null;
        Token CACHE23=null;
        Token set24=null;

        Object cacheName_tree=null;
        Object CACHE23_tree=null;
        Object set24_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:138:4: ( CACHE (cacheName= STRINGLITERAL )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:138:6: CACHE (cacheName= STRINGLITERAL )? ( EOL | ';' ) !
            {
            CACHE23=(Token)match(input,CACHE,FOLLOW_CACHE_in_cacheStatement326); 
            CACHE23_tree = 
            (Object)adaptor.create(CACHE23)
            ;
            adaptor.addChild(root_0, CACHE23_tree);


            // org/infinispan/cli/interpreter/IspnQL.g:138:12: (cacheName= STRINGLITERAL )?
            int alt6=2;
            switch ( input.LA(1) ) {
                case STRINGLITERAL:
                    {
                    alt6=1;
                    }
                    break;
            }

            switch (alt6) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:138:13: cacheName= STRINGLITERAL
                    {
                    cacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_cacheStatement333); 
                    cacheName_tree = 
                    (Object)adaptor.create(cacheName)
                    ;
                    adaptor.addChild(root_0, cacheName_tree);


                    }
                    break;

            }


            set24=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==61 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new CacheStatement(unquote((cacheName!=null?cacheName.getText():null))); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "cacheStatement"


    public static class clearStatement_return extends ParserRuleReturnScope {
        public ClearStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "clearStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:141:1: clearStatement returns [ClearStatement stmt] : CLEAR ( EOL | ';' ) !;
    public final IspnQLParser.clearStatement_return clearStatement() throws RecognitionException {
        IspnQLParser.clearStatement_return retval = new IspnQLParser.clearStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token CLEAR25=null;
        Token set26=null;

        Object CLEAR25_tree=null;
        Object set26_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:142:4: ( CLEAR ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:142:6: CLEAR ( EOL | ';' ) !
            {
            CLEAR25=(Token)match(input,CLEAR,FOLLOW_CLEAR_in_clearStatement365); 
            CLEAR25_tree = 
            (Object)adaptor.create(CLEAR25)
            ;
            adaptor.addChild(root_0, CLEAR25_tree);


            set26=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==61 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new ClearStatement(); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "clearStatement"


    public static class commitTransactionStatement_return extends ParserRuleReturnScope {
        public CommitTransactionStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "commitTransactionStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:145:1: commitTransactionStatement returns [CommitTransactionStatement stmt] : COMMIT (cacheName= STRINGLITERAL )? ( EOL | ';' ) !;
    public final IspnQLParser.commitTransactionStatement_return commitTransactionStatement() throws RecognitionException {
        IspnQLParser.commitTransactionStatement_return retval = new IspnQLParser.commitTransactionStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token cacheName=null;
        Token COMMIT27=null;
        Token set28=null;

        Object cacheName_tree=null;
        Object COMMIT27_tree=null;
        Object set28_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:146:4: ( COMMIT (cacheName= STRINGLITERAL )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:146:6: COMMIT (cacheName= STRINGLITERAL )? ( EOL | ';' ) !
            {
            COMMIT27=(Token)match(input,COMMIT,FOLLOW_COMMIT_in_commitTransactionStatement395); 
            COMMIT27_tree = 
            (Object)adaptor.create(COMMIT27)
            ;
            adaptor.addChild(root_0, COMMIT27_tree);


            // org/infinispan/cli/interpreter/IspnQL.g:146:13: (cacheName= STRINGLITERAL )?
            int alt7=2;
            switch ( input.LA(1) ) {
                case STRINGLITERAL:
                    {
                    alt7=1;
                    }
                    break;
            }

            switch (alt7) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:146:14: cacheName= STRINGLITERAL
                    {
                    cacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_commitTransactionStatement402); 
                    cacheName_tree = 
                    (Object)adaptor.create(cacheName)
                    ;
                    adaptor.addChild(root_0, cacheName_tree);


                    }
                    break;

            }


            set28=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==61 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new CommitTransactionStatement(unquote((cacheName!=null?cacheName.getText():null))); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "commitTransactionStatement"


    public static class endBatchStatement_return extends ParserRuleReturnScope {
        public EndBatchStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "endBatchStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:149:1: endBatchStatement returns [EndBatchStatement stmt] : END (cacheName= STRINGLITERAL )? ( EOL | ';' ) !;
    public final IspnQLParser.endBatchStatement_return endBatchStatement() throws RecognitionException {
        IspnQLParser.endBatchStatement_return retval = new IspnQLParser.endBatchStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token cacheName=null;
        Token END29=null;
        Token set30=null;

        Object cacheName_tree=null;
        Object END29_tree=null;
        Object set30_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:150:4: ( END (cacheName= STRINGLITERAL )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:150:6: END (cacheName= STRINGLITERAL )? ( EOL | ';' ) !
            {
            END29=(Token)match(input,END,FOLLOW_END_in_endBatchStatement434); 
            END29_tree = 
            (Object)adaptor.create(END29)
            ;
            adaptor.addChild(root_0, END29_tree);


            // org/infinispan/cli/interpreter/IspnQL.g:150:10: (cacheName= STRINGLITERAL )?
            int alt8=2;
            switch ( input.LA(1) ) {
                case STRINGLITERAL:
                    {
                    alt8=1;
                    }
                    break;
            }

            switch (alt8) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:150:11: cacheName= STRINGLITERAL
                    {
                    cacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_endBatchStatement441); 
                    cacheName_tree = 
                    (Object)adaptor.create(cacheName)
                    ;
                    adaptor.addChild(root_0, cacheName_tree);


                    }
                    break;

            }


            set30=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==61 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new EndBatchStatement(unquote((cacheName!=null?cacheName.getText():null)), true); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "endBatchStatement"


    public static class evictStatement_return extends ParserRuleReturnScope {
        public EvictStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "evictStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:153:1: evictStatement returns [EvictStatement stmt] : EVICT key= keyIdentifier ( EOL | ';' ) !;
    public final IspnQLParser.evictStatement_return evictStatement() throws RecognitionException {
        IspnQLParser.evictStatement_return retval = new IspnQLParser.evictStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token EVICT31=null;
        Token set32=null;
        IspnQLParser.keyIdentifier_return key =null;


        Object EVICT31_tree=null;
        Object set32_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:154:4: ( EVICT key= keyIdentifier ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:154:6: EVICT key= keyIdentifier ( EOL | ';' ) !
            {
            EVICT31=(Token)match(input,EVICT,FOLLOW_EVICT_in_evictStatement473); 
            EVICT31_tree = 
            (Object)adaptor.create(EVICT31)
            ;
            adaptor.addChild(root_0, EVICT31_tree);


            pushFollow(FOLLOW_keyIdentifier_in_evictStatement479);
            key=keyIdentifier();

            state._fsp--;

            adaptor.addChild(root_0, key.getTree());

            set32=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==61 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new EvictStatement((key!=null?key.key:null)); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "evictStatement"


    public static class getStatement_return extends ParserRuleReturnScope {
        public GetStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "getStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:157:1: getStatement returns [GetStatement stmt] : GET key= keyIdentifier ( EOL | ';' ) !;
    public final IspnQLParser.getStatement_return getStatement() throws RecognitionException {
        IspnQLParser.getStatement_return retval = new IspnQLParser.getStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token GET33=null;
        Token set34=null;
        IspnQLParser.keyIdentifier_return key =null;


        Object GET33_tree=null;
        Object set34_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:158:4: ( GET key= keyIdentifier ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:158:6: GET key= keyIdentifier ( EOL | ';' ) !
            {
            GET33=(Token)match(input,GET,FOLLOW_GET_in_getStatement509); 
            GET33_tree = 
            (Object)adaptor.create(GET33)
            ;
            adaptor.addChild(root_0, GET33_tree);


            pushFollow(FOLLOW_keyIdentifier_in_getStatement515);
            key=keyIdentifier();

            state._fsp--;

            adaptor.addChild(root_0, key.getTree());

            set34=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==61 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new GetStatement((key!=null?key.key:null)); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "getStatement"


    public static class locateStatement_return extends ParserRuleReturnScope {
        public LocateStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "locateStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:161:1: locateStatement returns [LocateStatement stmt] : LOCATE key= keyIdentifier ( EOL | ';' ) !;
    public final IspnQLParser.locateStatement_return locateStatement() throws RecognitionException {
        IspnQLParser.locateStatement_return retval = new IspnQLParser.locateStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token LOCATE35=null;
        Token set36=null;
        IspnQLParser.keyIdentifier_return key =null;


        Object LOCATE35_tree=null;
        Object set36_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:162:4: ( LOCATE key= keyIdentifier ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:162:6: LOCATE key= keyIdentifier ( EOL | ';' ) !
            {
            LOCATE35=(Token)match(input,LOCATE,FOLLOW_LOCATE_in_locateStatement545); 
            LOCATE35_tree = 
            (Object)adaptor.create(LOCATE35)
            ;
            adaptor.addChild(root_0, LOCATE35_tree);


            pushFollow(FOLLOW_keyIdentifier_in_locateStatement551);
            key=keyIdentifier();

            state._fsp--;

            adaptor.addChild(root_0, key.getTree());

            set36=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==61 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new LocateStatement((key!=null?key.key:null)); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "locateStatement"


    public static class putIfAbsentStatement_return extends ParserRuleReturnScope {
        public PutIfAbsentStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "putIfAbsentStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:165:1: putIfAbsentStatement returns [PutIfAbsentStatement stmt] : PUTIFABSENT key= keyIdentifier value= literal (exp= expirationClause )? ( EOL | ';' ) !;
    public final IspnQLParser.putIfAbsentStatement_return putIfAbsentStatement() throws RecognitionException {
        IspnQLParser.putIfAbsentStatement_return retval = new IspnQLParser.putIfAbsentStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token PUTIFABSENT37=null;
        Token set38=null;
        IspnQLParser.keyIdentifier_return key =null;

        IspnQLParser.literal_return value =null;

        IspnQLParser.expirationClause_return exp =null;


        Object PUTIFABSENT37_tree=null;
        Object set38_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:166:4: ( PUTIFABSENT key= keyIdentifier value= literal (exp= expirationClause )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:166:6: PUTIFABSENT key= keyIdentifier value= literal (exp= expirationClause )? ( EOL | ';' ) !
            {
            PUTIFABSENT37=(Token)match(input,PUTIFABSENT,FOLLOW_PUTIFABSENT_in_putIfAbsentStatement581); 
            PUTIFABSENT37_tree = 
            (Object)adaptor.create(PUTIFABSENT37)
            ;
            adaptor.addChild(root_0, PUTIFABSENT37_tree);


            pushFollow(FOLLOW_keyIdentifier_in_putIfAbsentStatement587);
            key=keyIdentifier();

            state._fsp--;

            adaptor.addChild(root_0, key.getTree());

            pushFollow(FOLLOW_literal_in_putIfAbsentStatement593);
            value=literal();

            state._fsp--;

            adaptor.addChild(root_0, value.getTree());

            // org/infinispan/cli/interpreter/IspnQL.g:166:54: (exp= expirationClause )?
            int alt9=2;
            switch ( input.LA(1) ) {
                case EXPIRES:
                    {
                    alt9=1;
                    }
                    break;
            }

            switch (alt9) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:166:55: exp= expirationClause
                    {
                    pushFollow(FOLLOW_expirationClause_in_putIfAbsentStatement600);
                    exp=expirationClause();

                    state._fsp--;

                    adaptor.addChild(root_0, exp.getTree());

                    }
                    break;

            }


            set38=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==61 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new PutIfAbsentStatement((key!=null?key.key:null), (value!=null?value.o:null), (exp!=null?exp.exp:null)); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "putIfAbsentStatement"


    public static class putStatement_return extends ParserRuleReturnScope {
        public PutStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "putStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:169:1: putStatement returns [PutStatement stmt] : PUT key= keyIdentifier value= literal (exp= expirationClause )? ( EOL | ';' ) !;
    public final IspnQLParser.putStatement_return putStatement() throws RecognitionException {
        IspnQLParser.putStatement_return retval = new IspnQLParser.putStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token PUT39=null;
        Token set40=null;
        IspnQLParser.keyIdentifier_return key =null;

        IspnQLParser.literal_return value =null;

        IspnQLParser.expirationClause_return exp =null;


        Object PUT39_tree=null;
        Object set40_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:170:4: ( PUT key= keyIdentifier value= literal (exp= expirationClause )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:170:6: PUT key= keyIdentifier value= literal (exp= expirationClause )? ( EOL | ';' ) !
            {
            PUT39=(Token)match(input,PUT,FOLLOW_PUT_in_putStatement632); 
            PUT39_tree = 
            (Object)adaptor.create(PUT39)
            ;
            adaptor.addChild(root_0, PUT39_tree);


            pushFollow(FOLLOW_keyIdentifier_in_putStatement638);
            key=keyIdentifier();

            state._fsp--;

            adaptor.addChild(root_0, key.getTree());

            pushFollow(FOLLOW_literal_in_putStatement644);
            value=literal();

            state._fsp--;

            adaptor.addChild(root_0, value.getTree());

            // org/infinispan/cli/interpreter/IspnQL.g:170:46: (exp= expirationClause )?
            int alt10=2;
            switch ( input.LA(1) ) {
                case EXPIRES:
                    {
                    alt10=1;
                    }
                    break;
            }

            switch (alt10) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:170:47: exp= expirationClause
                    {
                    pushFollow(FOLLOW_expirationClause_in_putStatement651);
                    exp=expirationClause();

                    state._fsp--;

                    adaptor.addChild(root_0, exp.getTree());

                    }
                    break;

            }


            set40=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==61 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new PutStatement((key!=null?key.key:null), (value!=null?value.o:null), (exp!=null?exp.exp:null)); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "putStatement"


    public static class removeStatement_return extends ParserRuleReturnScope {
        public RemoveStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "removeStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:173:1: removeStatement returns [RemoveStatement stmt] : REMOVE key= keyIdentifier (value= literal )? ( EOL | ';' ) !;
    public final IspnQLParser.removeStatement_return removeStatement() throws RecognitionException {
        IspnQLParser.removeStatement_return retval = new IspnQLParser.removeStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token REMOVE41=null;
        Token set42=null;
        IspnQLParser.keyIdentifier_return key =null;

        IspnQLParser.literal_return value =null;


        Object REMOVE41_tree=null;
        Object set42_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:174:4: ( REMOVE key= keyIdentifier (value= literal )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:174:6: REMOVE key= keyIdentifier (value= literal )? ( EOL | ';' ) !
            {
            REMOVE41=(Token)match(input,REMOVE,FOLLOW_REMOVE_in_removeStatement683); 
            REMOVE41_tree = 
            (Object)adaptor.create(REMOVE41)
            ;
            adaptor.addChild(root_0, REMOVE41_tree);


            pushFollow(FOLLOW_keyIdentifier_in_removeStatement689);
            key=keyIdentifier();

            state._fsp--;

            adaptor.addChild(root_0, key.getTree());

            // org/infinispan/cli/interpreter/IspnQL.g:174:33: (value= literal )?
            int alt11=2;
            switch ( input.LA(1) ) {
                case DOUBLELITERAL:
                case FALSE:
                case FLOATLITERAL:
                case INTLITERAL:
                case LONGLITERAL:
                case NULL:
                case STRINGLITERAL:
                case TRUE:
                case UUIDLITERAL:
                case 64:
                    {
                    alt11=1;
                    }
                    break;
            }

            switch (alt11) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:174:34: value= literal
                    {
                    pushFollow(FOLLOW_literal_in_removeStatement696);
                    value=literal();

                    state._fsp--;

                    adaptor.addChild(root_0, value.getTree());

                    }
                    break;

            }


            set42=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==61 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new RemoveStatement((key!=null?key.key:null), (value!=null?value.o:null)); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "removeStatement"


    public static class replaceStatement_return extends ParserRuleReturnScope {
        public ReplaceStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "replaceStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:177:1: replaceStatement returns [ReplaceStatement stmt] : REPLACE key= keyIdentifier value1= literal (value2= literal )? (exp= expirationClause )? ( EOL | ';' ) !;
    public final IspnQLParser.replaceStatement_return replaceStatement() throws RecognitionException {
        IspnQLParser.replaceStatement_return retval = new IspnQLParser.replaceStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token REPLACE43=null;
        Token set44=null;
        IspnQLParser.keyIdentifier_return key =null;

        IspnQLParser.literal_return value1 =null;

        IspnQLParser.literal_return value2 =null;

        IspnQLParser.expirationClause_return exp =null;


        Object REPLACE43_tree=null;
        Object set44_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:178:4: ( REPLACE key= keyIdentifier value1= literal (value2= literal )? (exp= expirationClause )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:178:6: REPLACE key= keyIdentifier value1= literal (value2= literal )? (exp= expirationClause )? ( EOL | ';' ) !
            {
            REPLACE43=(Token)match(input,REPLACE,FOLLOW_REPLACE_in_replaceStatement728); 
            REPLACE43_tree = 
            (Object)adaptor.create(REPLACE43)
            ;
            adaptor.addChild(root_0, REPLACE43_tree);


            pushFollow(FOLLOW_keyIdentifier_in_replaceStatement734);
            key=keyIdentifier();

            state._fsp--;

            adaptor.addChild(root_0, key.getTree());

            pushFollow(FOLLOW_literal_in_replaceStatement740);
            value1=literal();

            state._fsp--;

            adaptor.addChild(root_0, value1.getTree());

            // org/infinispan/cli/interpreter/IspnQL.g:178:51: (value2= literal )?
            int alt12=2;
            switch ( input.LA(1) ) {
                case DOUBLELITERAL:
                case FALSE:
                case FLOATLITERAL:
                case INTLITERAL:
                case LONGLITERAL:
                case NULL:
                case STRINGLITERAL:
                case TRUE:
                case UUIDLITERAL:
                case 64:
                    {
                    alt12=1;
                    }
                    break;
            }

            switch (alt12) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:178:52: value2= literal
                    {
                    pushFollow(FOLLOW_literal_in_replaceStatement747);
                    value2=literal();

                    state._fsp--;

                    adaptor.addChild(root_0, value2.getTree());

                    }
                    break;

            }


            // org/infinispan/cli/interpreter/IspnQL.g:178:71: (exp= expirationClause )?
            int alt13=2;
            switch ( input.LA(1) ) {
                case EXPIRES:
                    {
                    alt13=1;
                    }
                    break;
            }

            switch (alt13) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:178:72: exp= expirationClause
                    {
                    pushFollow(FOLLOW_expirationClause_in_replaceStatement756);
                    exp=expirationClause();

                    state._fsp--;

                    adaptor.addChild(root_0, exp.getTree());

                    }
                    break;

            }


            set44=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==61 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             if ((value2!=null?value2.o:null)==null) retval.stmt = new ReplaceStatement((key!=null?key.key:null), (value1!=null?value1.o:null), (exp!=null?exp.exp:null)); else retval.stmt = new ReplaceStatement((key!=null?key.key:null), (value1!=null?value1.o:null), (value2!=null?value2.o:null), (exp!=null?exp.exp:null));

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "replaceStatement"


    public static class rollbackTransactionStatement_return extends ParserRuleReturnScope {
        public RollbackTransactionStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "rollbackTransactionStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:181:1: rollbackTransactionStatement returns [RollbackTransactionStatement stmt] : ROLLBACK (cacheName= STRINGLITERAL )? ( EOL | ';' ) !;
    public final IspnQLParser.rollbackTransactionStatement_return rollbackTransactionStatement() throws RecognitionException {
        IspnQLParser.rollbackTransactionStatement_return retval = new IspnQLParser.rollbackTransactionStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token cacheName=null;
        Token ROLLBACK45=null;
        Token set46=null;

        Object cacheName_tree=null;
        Object ROLLBACK45_tree=null;
        Object set46_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:182:4: ( ROLLBACK (cacheName= STRINGLITERAL )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:182:6: ROLLBACK (cacheName= STRINGLITERAL )? ( EOL | ';' ) !
            {
            ROLLBACK45=(Token)match(input,ROLLBACK,FOLLOW_ROLLBACK_in_rollbackTransactionStatement788); 
            ROLLBACK45_tree = 
            (Object)adaptor.create(ROLLBACK45)
            ;
            adaptor.addChild(root_0, ROLLBACK45_tree);


            // org/infinispan/cli/interpreter/IspnQL.g:182:15: (cacheName= STRINGLITERAL )?
            int alt14=2;
            switch ( input.LA(1) ) {
                case STRINGLITERAL:
                    {
                    alt14=1;
                    }
                    break;
            }

            switch (alt14) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:182:16: cacheName= STRINGLITERAL
                    {
                    cacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_rollbackTransactionStatement795); 
                    cacheName_tree = 
                    (Object)adaptor.create(cacheName)
                    ;
                    adaptor.addChild(root_0, cacheName_tree);


                    }
                    break;

            }


            set46=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==61 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new RollbackTransactionStatement(unquote((cacheName!=null?cacheName.getText():null))); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "rollbackTransactionStatement"


    public static class startBatchStatement_return extends ParserRuleReturnScope {
        public StartBatchStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "startBatchStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:185:1: startBatchStatement returns [StartBatchStatement stmt] : START (cacheName= STRINGLITERAL )? ( EOL | ';' ) !;
    public final IspnQLParser.startBatchStatement_return startBatchStatement() throws RecognitionException {
        IspnQLParser.startBatchStatement_return retval = new IspnQLParser.startBatchStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token cacheName=null;
        Token START47=null;
        Token set48=null;

        Object cacheName_tree=null;
        Object START47_tree=null;
        Object set48_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:186:4: ( START (cacheName= STRINGLITERAL )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:186:6: START (cacheName= STRINGLITERAL )? ( EOL | ';' ) !
            {
            START47=(Token)match(input,START,FOLLOW_START_in_startBatchStatement827); 
            START47_tree = 
            (Object)adaptor.create(START47)
            ;
            adaptor.addChild(root_0, START47_tree);


            // org/infinispan/cli/interpreter/IspnQL.g:186:12: (cacheName= STRINGLITERAL )?
            int alt15=2;
            switch ( input.LA(1) ) {
                case STRINGLITERAL:
                    {
                    alt15=1;
                    }
                    break;
            }

            switch (alt15) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:186:13: cacheName= STRINGLITERAL
                    {
                    cacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_startBatchStatement834); 
                    cacheName_tree = 
                    (Object)adaptor.create(cacheName)
                    ;
                    adaptor.addChild(root_0, cacheName_tree);


                    }
                    break;

            }


            set48=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==61 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new StartBatchStatement(unquote((cacheName!=null?cacheName.getText():null))); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "startBatchStatement"


    public static class expirationClause_return extends ParserRuleReturnScope {
        public ExpirationData exp;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "expirationClause"
    // org/infinispan/cli/interpreter/IspnQL.g:189:1: expirationClause returns [ExpirationData exp] : EXPIRES expires= timeLiteral ( MAXIDLE idle= timeLiteral )? ;
    public final IspnQLParser.expirationClause_return expirationClause() throws RecognitionException {
        IspnQLParser.expirationClause_return retval = new IspnQLParser.expirationClause_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token EXPIRES49=null;
        Token MAXIDLE50=null;
        IspnQLParser.timeLiteral_return expires =null;

        IspnQLParser.timeLiteral_return idle =null;


        Object EXPIRES49_tree=null;
        Object MAXIDLE50_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:190:4: ( EXPIRES expires= timeLiteral ( MAXIDLE idle= timeLiteral )? )
            // org/infinispan/cli/interpreter/IspnQL.g:190:6: EXPIRES expires= timeLiteral ( MAXIDLE idle= timeLiteral )?
            {
            EXPIRES49=(Token)match(input,EXPIRES,FOLLOW_EXPIRES_in_expirationClause866); 
            EXPIRES49_tree = 
            (Object)adaptor.create(EXPIRES49)
            ;
            adaptor.addChild(root_0, EXPIRES49_tree);


            pushFollow(FOLLOW_timeLiteral_in_expirationClause872);
            expires=timeLiteral();

            state._fsp--;

            adaptor.addChild(root_0, expires.getTree());

            // org/infinispan/cli/interpreter/IspnQL.g:190:36: ( MAXIDLE idle= timeLiteral )?
            int alt16=2;
            switch ( input.LA(1) ) {
                case MAXIDLE:
                    {
                    alt16=1;
                    }
                    break;
            }

            switch (alt16) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:190:37: MAXIDLE idle= timeLiteral
                    {
                    MAXIDLE50=(Token)match(input,MAXIDLE,FOLLOW_MAXIDLE_in_expirationClause875); 
                    MAXIDLE50_tree = 
                    (Object)adaptor.create(MAXIDLE50)
                    ;
                    adaptor.addChild(root_0, MAXIDLE50_tree);


                    pushFollow(FOLLOW_timeLiteral_in_expirationClause881);
                    idle=timeLiteral();

                    state._fsp--;

                    adaptor.addChild(root_0, idle.getTree());

                    }
                    break;

            }


             retval.exp = new ExpirationData((expires!=null?expires.l:null), (idle!=null?idle.l:null)); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "expirationClause"


    public static class keyIdentifier_return extends ParserRuleReturnScope {
        public KeyData key;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "keyIdentifier"
    // org/infinispan/cli/interpreter/IspnQL.g:193:1: keyIdentifier returns [KeyData key] : ( STRINGLITERAL '.' literal | literal );
    public final IspnQLParser.keyIdentifier_return keyIdentifier() throws RecognitionException {
        IspnQLParser.keyIdentifier_return retval = new IspnQLParser.keyIdentifier_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token STRINGLITERAL51=null;
        Token char_literal52=null;
        IspnQLParser.literal_return literal53 =null;

        IspnQLParser.literal_return literal54 =null;


        Object STRINGLITERAL51_tree=null;
        Object char_literal52_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:194:4: ( STRINGLITERAL '.' literal | literal )
            int alt17=2;
            switch ( input.LA(1) ) {
            case STRINGLITERAL:
                {
                switch ( input.LA(2) ) {
                case 59:
                    {
                    alt17=1;
                    }
                    break;
                case DOUBLELITERAL:
                case EOL:
                case FALSE:
                case FLOATLITERAL:
                case INTLITERAL:
                case LONGLITERAL:
                case NULL:
                case STRINGLITERAL:
                case TRUE:
                case UUIDLITERAL:
                case 61:
                case 64:
                    {
                    alt17=2;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 17, 1, input);

                    throw nvae;

                }

                }
                break;
            case DOUBLELITERAL:
            case FALSE:
            case FLOATLITERAL:
            case INTLITERAL:
            case LONGLITERAL:
            case NULL:
            case TRUE:
            case UUIDLITERAL:
            case 64:
                {
                alt17=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 17, 0, input);

                throw nvae;

            }

            switch (alt17) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:194:6: STRINGLITERAL '.' literal
                    {
                    STRINGLITERAL51=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_keyIdentifier904); 
                    STRINGLITERAL51_tree = 
                    (Object)adaptor.create(STRINGLITERAL51)
                    ;
                    adaptor.addChild(root_0, STRINGLITERAL51_tree);


                    char_literal52=(Token)match(input,59,FOLLOW_59_in_keyIdentifier906); 
                    char_literal52_tree = 
                    (Object)adaptor.create(char_literal52)
                    ;
                    adaptor.addChild(root_0, char_literal52_tree);


                    pushFollow(FOLLOW_literal_in_keyIdentifier908);
                    literal53=literal();

                    state._fsp--;

                    adaptor.addChild(root_0, literal53.getTree());

                     retval.key = new KeyData(unquote((STRINGLITERAL51!=null?STRINGLITERAL51.getText():null)), (literal53!=null?literal53.o:null)); 

                    }
                    break;
                case 2 :
                    // org/infinispan/cli/interpreter/IspnQL.g:195:6: literal
                    {
                    pushFollow(FOLLOW_literal_in_keyIdentifier917);
                    literal54=literal();

                    state._fsp--;

                    adaptor.addChild(root_0, literal54.getTree());

                     retval.key = new KeyData((literal54!=null?literal54.o:null)); 

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "keyIdentifier"


    public static class literal_return extends ParserRuleReturnScope {
        public Object o;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "literal"
    // org/infinispan/cli/interpreter/IspnQL.g:198:1: literal returns [Object o] : ( INTLITERAL | LONGLITERAL | FLOATLITERAL | DOUBLELITERAL | NULL | STRINGLITERAL | UUIDLITERAL |b= ( TRUE | FALSE ) | jsonLiteral );
    public final IspnQLParser.literal_return literal() throws RecognitionException {
        IspnQLParser.literal_return retval = new IspnQLParser.literal_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token b=null;
        Token INTLITERAL55=null;
        Token LONGLITERAL56=null;
        Token FLOATLITERAL57=null;
        Token DOUBLELITERAL58=null;
        Token NULL59=null;
        Token STRINGLITERAL60=null;
        Token UUIDLITERAL61=null;
        IspnQLParser.jsonLiteral_return jsonLiteral62 =null;


        Object b_tree=null;
        Object INTLITERAL55_tree=null;
        Object LONGLITERAL56_tree=null;
        Object FLOATLITERAL57_tree=null;
        Object DOUBLELITERAL58_tree=null;
        Object NULL59_tree=null;
        Object STRINGLITERAL60_tree=null;
        Object UUIDLITERAL61_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:199:4: ( INTLITERAL | LONGLITERAL | FLOATLITERAL | DOUBLELITERAL | NULL | STRINGLITERAL | UUIDLITERAL |b= ( TRUE | FALSE ) | jsonLiteral )
            int alt18=9;
            switch ( input.LA(1) ) {
            case INTLITERAL:
                {
                alt18=1;
                }
                break;
            case LONGLITERAL:
                {
                alt18=2;
                }
                break;
            case FLOATLITERAL:
                {
                alt18=3;
                }
                break;
            case DOUBLELITERAL:
                {
                alt18=4;
                }
                break;
            case NULL:
                {
                alt18=5;
                }
                break;
            case STRINGLITERAL:
                {
                alt18=6;
                }
                break;
            case UUIDLITERAL:
                {
                alt18=7;
                }
                break;
            case FALSE:
            case TRUE:
                {
                alt18=8;
                }
                break;
            case 64:
                {
                alt18=9;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 18, 0, input);

                throw nvae;

            }

            switch (alt18) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:199:6: INTLITERAL
                    {
                    INTLITERAL55=(Token)match(input,INTLITERAL,FOLLOW_INTLITERAL_in_literal938); 
                    INTLITERAL55_tree = 
                    (Object)adaptor.create(INTLITERAL55)
                    ;
                    adaptor.addChild(root_0, INTLITERAL55_tree);


                     retval.o = Integer.valueOf((INTLITERAL55!=null?INTLITERAL55.getText():null)); 

                    }
                    break;
                case 2 :
                    // org/infinispan/cli/interpreter/IspnQL.g:200:6: LONGLITERAL
                    {
                    LONGLITERAL56=(Token)match(input,LONGLITERAL,FOLLOW_LONGLITERAL_in_literal947); 
                    LONGLITERAL56_tree = 
                    (Object)adaptor.create(LONGLITERAL56)
                    ;
                    adaptor.addChild(root_0, LONGLITERAL56_tree);


                     retval.o = Long.valueOf((LONGLITERAL56!=null?LONGLITERAL56.getText():null)); 

                    }
                    break;
                case 3 :
                    // org/infinispan/cli/interpreter/IspnQL.g:201:6: FLOATLITERAL
                    {
                    FLOATLITERAL57=(Token)match(input,FLOATLITERAL,FOLLOW_FLOATLITERAL_in_literal956); 
                    FLOATLITERAL57_tree = 
                    (Object)adaptor.create(FLOATLITERAL57)
                    ;
                    adaptor.addChild(root_0, FLOATLITERAL57_tree);


                     retval.o = Float.valueOf((FLOATLITERAL57!=null?FLOATLITERAL57.getText():null)); 

                    }
                    break;
                case 4 :
                    // org/infinispan/cli/interpreter/IspnQL.g:202:6: DOUBLELITERAL
                    {
                    DOUBLELITERAL58=(Token)match(input,DOUBLELITERAL,FOLLOW_DOUBLELITERAL_in_literal965); 
                    DOUBLELITERAL58_tree = 
                    (Object)adaptor.create(DOUBLELITERAL58)
                    ;
                    adaptor.addChild(root_0, DOUBLELITERAL58_tree);


                     retval.o = Double.valueOf((DOUBLELITERAL58!=null?DOUBLELITERAL58.getText():null)); 

                    }
                    break;
                case 5 :
                    // org/infinispan/cli/interpreter/IspnQL.g:203:6: NULL
                    {
                    NULL59=(Token)match(input,NULL,FOLLOW_NULL_in_literal974); 
                    NULL59_tree = 
                    (Object)adaptor.create(NULL59)
                    ;
                    adaptor.addChild(root_0, NULL59_tree);


                     retval.o = null; 

                    }
                    break;
                case 6 :
                    // org/infinispan/cli/interpreter/IspnQL.g:204:6: STRINGLITERAL
                    {
                    STRINGLITERAL60=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_literal983); 
                    STRINGLITERAL60_tree = 
                    (Object)adaptor.create(STRINGLITERAL60)
                    ;
                    adaptor.addChild(root_0, STRINGLITERAL60_tree);


                     retval.o = unquote((STRINGLITERAL60!=null?STRINGLITERAL60.getText():null)); 

                    }
                    break;
                case 7 :
                    // org/infinispan/cli/interpreter/IspnQL.g:205:6: UUIDLITERAL
                    {
                    UUIDLITERAL61=(Token)match(input,UUIDLITERAL,FOLLOW_UUIDLITERAL_in_literal992); 
                    UUIDLITERAL61_tree = 
                    (Object)adaptor.create(UUIDLITERAL61)
                    ;
                    adaptor.addChild(root_0, UUIDLITERAL61_tree);


                     retval.o = UUID.fromString((UUIDLITERAL61!=null?UUIDLITERAL61.getText():null)); 

                    }
                    break;
                case 8 :
                    // org/infinispan/cli/interpreter/IspnQL.g:206:6: b= ( TRUE | FALSE )
                    {
                    b=(Token)input.LT(1);

                    if ( input.LA(1)==FALSE||input.LA(1)==TRUE ) {
                        input.consume();
                        adaptor.addChild(root_0, 
                        (Object)adaptor.create(b)
                        );
                        state.errorRecovery=false;
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        throw mse;
                    }


                     retval.o = Boolean.valueOf((b!=null?b.getText():null)); 

                    }
                    break;
                case 9 :
                    // org/infinispan/cli/interpreter/IspnQL.g:207:6: jsonLiteral
                    {
                    pushFollow(FOLLOW_jsonLiteral_in_literal1022);
                    jsonLiteral62=jsonLiteral();

                    state._fsp--;

                    adaptor.addChild(root_0, jsonLiteral62.getTree());


                           retval.o = jsonMapper.readValue((jsonLiteral62!=null?input.toString(jsonLiteral62.start,jsonLiteral62.stop):null), Object.class);
                       

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (JsonProcessingException jpe) {
             throw new RecognitionException(input); 
        }
        catch (IOException ioe) {
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "literal"


    public static class timeLiteral_return extends ParserRuleReturnScope {
        public Long l;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "timeLiteral"
    // org/infinispan/cli/interpreter/IspnQL.g:214:1: timeLiteral returns [Long l] : TIMELITERAL ;
    public final IspnQLParser.timeLiteral_return timeLiteral() throws RecognitionException {
        IspnQLParser.timeLiteral_return retval = new IspnQLParser.timeLiteral_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token TIMELITERAL63=null;

        Object TIMELITERAL63_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:215:4: ( TIMELITERAL )
            // org/infinispan/cli/interpreter/IspnQL.g:215:6: TIMELITERAL
            {
            TIMELITERAL63=(Token)match(input,TIMELITERAL,FOLLOW_TIMELITERAL_in_timeLiteral1059); 
            TIMELITERAL63_tree = 
            (Object)adaptor.create(TIMELITERAL63)
            ;
            adaptor.addChild(root_0, TIMELITERAL63_tree);


             retval.l = millis((TIMELITERAL63!=null?TIMELITERAL63.getText():null)); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "timeLiteral"


    public static class jsonLiteral_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "jsonLiteral"
    // org/infinispan/cli/interpreter/IspnQL.g:218:1: jsonLiteral : '{' jsonPair ( ',' jsonPair )* '}' ;
    public final IspnQLParser.jsonLiteral_return jsonLiteral() throws RecognitionException {
        IspnQLParser.jsonLiteral_return retval = new IspnQLParser.jsonLiteral_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token char_literal64=null;
        Token char_literal66=null;
        Token char_literal68=null;
        IspnQLParser.jsonPair_return jsonPair65 =null;

        IspnQLParser.jsonPair_return jsonPair67 =null;


        Object char_literal64_tree=null;
        Object char_literal66_tree=null;
        Object char_literal68_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:219:4: ( '{' jsonPair ( ',' jsonPair )* '}' )
            // org/infinispan/cli/interpreter/IspnQL.g:219:6: '{' jsonPair ( ',' jsonPair )* '}'
            {
            char_literal64=(Token)match(input,64,FOLLOW_64_in_jsonLiteral1076); 
            char_literal64_tree = 
            (Object)adaptor.create(char_literal64)
            ;
            adaptor.addChild(root_0, char_literal64_tree);


            pushFollow(FOLLOW_jsonPair_in_jsonLiteral1078);
            jsonPair65=jsonPair();

            state._fsp--;

            adaptor.addChild(root_0, jsonPair65.getTree());

            // org/infinispan/cli/interpreter/IspnQL.g:219:19: ( ',' jsonPair )*
            loop19:
            do {
                int alt19=2;
                switch ( input.LA(1) ) {
                case 58:
                    {
                    alt19=1;
                    }
                    break;

                }

                switch (alt19) {
            	case 1 :
            	    // org/infinispan/cli/interpreter/IspnQL.g:219:20: ',' jsonPair
            	    {
            	    char_literal66=(Token)match(input,58,FOLLOW_58_in_jsonLiteral1081); 
            	    char_literal66_tree = 
            	    (Object)adaptor.create(char_literal66)
            	    ;
            	    adaptor.addChild(root_0, char_literal66_tree);


            	    pushFollow(FOLLOW_jsonPair_in_jsonLiteral1083);
            	    jsonPair67=jsonPair();

            	    state._fsp--;

            	    adaptor.addChild(root_0, jsonPair67.getTree());

            	    }
            	    break;

            	default :
            	    break loop19;
                }
            } while (true);


            char_literal68=(Token)match(input,65,FOLLOW_65_in_jsonLiteral1087); 
            char_literal68_tree = 
            (Object)adaptor.create(char_literal68)
            ;
            adaptor.addChild(root_0, char_literal68_tree);


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "jsonLiteral"


    public static class jsonPair_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "jsonPair"
    // org/infinispan/cli/interpreter/IspnQL.g:222:1: jsonPair : jsonString ':' jsonValue ;
    public final IspnQLParser.jsonPair_return jsonPair() throws RecognitionException {
        IspnQLParser.jsonPair_return retval = new IspnQLParser.jsonPair_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token char_literal70=null;
        IspnQLParser.jsonString_return jsonString69 =null;

        IspnQLParser.jsonValue_return jsonValue71 =null;


        Object char_literal70_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:223:4: ( jsonString ':' jsonValue )
            // org/infinispan/cli/interpreter/IspnQL.g:223:6: jsonString ':' jsonValue
            {
            pushFollow(FOLLOW_jsonString_in_jsonPair1102);
            jsonString69=jsonString();

            state._fsp--;

            adaptor.addChild(root_0, jsonString69.getTree());

            char_literal70=(Token)match(input,60,FOLLOW_60_in_jsonPair1104); 
            char_literal70_tree = 
            (Object)adaptor.create(char_literal70)
            ;
            adaptor.addChild(root_0, char_literal70_tree);


            pushFollow(FOLLOW_jsonValue_in_jsonPair1106);
            jsonValue71=jsonValue();

            state._fsp--;

            adaptor.addChild(root_0, jsonValue71.getTree());

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "jsonPair"


    public static class jsonString_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "jsonString"
    // org/infinispan/cli/interpreter/IspnQL.g:226:1: jsonString : STRINGLITERAL ;
    public final IspnQLParser.jsonString_return jsonString() throws RecognitionException {
        IspnQLParser.jsonString_return retval = new IspnQLParser.jsonString_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token STRINGLITERAL72=null;

        Object STRINGLITERAL72_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:227:4: ( STRINGLITERAL )
            // org/infinispan/cli/interpreter/IspnQL.g:227:6: STRINGLITERAL
            {
            STRINGLITERAL72=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_jsonString1121); 
            STRINGLITERAL72_tree = 
            (Object)adaptor.create(STRINGLITERAL72)
            ;
            adaptor.addChild(root_0, STRINGLITERAL72_tree);


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "jsonString"


    public static class jsonValue_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "jsonValue"
    // org/infinispan/cli/interpreter/IspnQL.g:230:1: jsonValue : ( jsonLiteral | jsonArray | INTLITERAL | DOUBLELITERAL | TRUE | FALSE | NULL | jsonString );
    public final IspnQLParser.jsonValue_return jsonValue() throws RecognitionException {
        IspnQLParser.jsonValue_return retval = new IspnQLParser.jsonValue_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token INTLITERAL75=null;
        Token DOUBLELITERAL76=null;
        Token TRUE77=null;
        Token FALSE78=null;
        Token NULL79=null;
        IspnQLParser.jsonLiteral_return jsonLiteral73 =null;

        IspnQLParser.jsonArray_return jsonArray74 =null;

        IspnQLParser.jsonString_return jsonString80 =null;


        Object INTLITERAL75_tree=null;
        Object DOUBLELITERAL76_tree=null;
        Object TRUE77_tree=null;
        Object FALSE78_tree=null;
        Object NULL79_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:231:4: ( jsonLiteral | jsonArray | INTLITERAL | DOUBLELITERAL | TRUE | FALSE | NULL | jsonString )
            int alt20=8;
            switch ( input.LA(1) ) {
            case 64:
                {
                alt20=1;
                }
                break;
            case 62:
                {
                alt20=2;
                }
                break;
            case INTLITERAL:
                {
                alt20=3;
                }
                break;
            case DOUBLELITERAL:
                {
                alt20=4;
                }
                break;
            case TRUE:
                {
                alt20=5;
                }
                break;
            case FALSE:
                {
                alt20=6;
                }
                break;
            case NULL:
                {
                alt20=7;
                }
                break;
            case STRINGLITERAL:
                {
                alt20=8;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 20, 0, input);

                throw nvae;

            }

            switch (alt20) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:231:6: jsonLiteral
                    {
                    pushFollow(FOLLOW_jsonLiteral_in_jsonValue1136);
                    jsonLiteral73=jsonLiteral();

                    state._fsp--;

                    adaptor.addChild(root_0, jsonLiteral73.getTree());

                    }
                    break;
                case 2 :
                    // org/infinispan/cli/interpreter/IspnQL.g:232:6: jsonArray
                    {
                    pushFollow(FOLLOW_jsonArray_in_jsonValue1143);
                    jsonArray74=jsonArray();

                    state._fsp--;

                    adaptor.addChild(root_0, jsonArray74.getTree());

                    }
                    break;
                case 3 :
                    // org/infinispan/cli/interpreter/IspnQL.g:233:6: INTLITERAL
                    {
                    INTLITERAL75=(Token)match(input,INTLITERAL,FOLLOW_INTLITERAL_in_jsonValue1150); 
                    INTLITERAL75_tree = 
                    (Object)adaptor.create(INTLITERAL75)
                    ;
                    adaptor.addChild(root_0, INTLITERAL75_tree);


                    }
                    break;
                case 4 :
                    // org/infinispan/cli/interpreter/IspnQL.g:234:6: DOUBLELITERAL
                    {
                    DOUBLELITERAL76=(Token)match(input,DOUBLELITERAL,FOLLOW_DOUBLELITERAL_in_jsonValue1157); 
                    DOUBLELITERAL76_tree = 
                    (Object)adaptor.create(DOUBLELITERAL76)
                    ;
                    adaptor.addChild(root_0, DOUBLELITERAL76_tree);


                    }
                    break;
                case 5 :
                    // org/infinispan/cli/interpreter/IspnQL.g:235:6: TRUE
                    {
                    TRUE77=(Token)match(input,TRUE,FOLLOW_TRUE_in_jsonValue1164); 
                    TRUE77_tree = 
                    (Object)adaptor.create(TRUE77)
                    ;
                    adaptor.addChild(root_0, TRUE77_tree);


                    }
                    break;
                case 6 :
                    // org/infinispan/cli/interpreter/IspnQL.g:235:13: FALSE
                    {
                    FALSE78=(Token)match(input,FALSE,FOLLOW_FALSE_in_jsonValue1168); 
                    FALSE78_tree = 
                    (Object)adaptor.create(FALSE78)
                    ;
                    adaptor.addChild(root_0, FALSE78_tree);


                    }
                    break;
                case 7 :
                    // org/infinispan/cli/interpreter/IspnQL.g:236:6: NULL
                    {
                    NULL79=(Token)match(input,NULL,FOLLOW_NULL_in_jsonValue1175); 
                    NULL79_tree = 
                    (Object)adaptor.create(NULL79)
                    ;
                    adaptor.addChild(root_0, NULL79_tree);


                    }
                    break;
                case 8 :
                    // org/infinispan/cli/interpreter/IspnQL.g:237:6: jsonString
                    {
                    pushFollow(FOLLOW_jsonString_in_jsonValue1182);
                    jsonString80=jsonString();

                    state._fsp--;

                    adaptor.addChild(root_0, jsonString80.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "jsonValue"


    public static class jsonArray_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "jsonArray"
    // org/infinispan/cli/interpreter/IspnQL.g:240:1: jsonArray : '[' jsonValue ( ',' jsonValue )* ']' ;
    public final IspnQLParser.jsonArray_return jsonArray() throws RecognitionException {
        IspnQLParser.jsonArray_return retval = new IspnQLParser.jsonArray_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token char_literal81=null;
        Token char_literal83=null;
        Token char_literal85=null;
        IspnQLParser.jsonValue_return jsonValue82 =null;

        IspnQLParser.jsonValue_return jsonValue84 =null;


        Object char_literal81_tree=null;
        Object char_literal83_tree=null;
        Object char_literal85_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:241:4: ( '[' jsonValue ( ',' jsonValue )* ']' )
            // org/infinispan/cli/interpreter/IspnQL.g:241:6: '[' jsonValue ( ',' jsonValue )* ']'
            {
            char_literal81=(Token)match(input,62,FOLLOW_62_in_jsonArray1197); 
            char_literal81_tree = 
            (Object)adaptor.create(char_literal81)
            ;
            adaptor.addChild(root_0, char_literal81_tree);


            pushFollow(FOLLOW_jsonValue_in_jsonArray1199);
            jsonValue82=jsonValue();

            state._fsp--;

            adaptor.addChild(root_0, jsonValue82.getTree());

            // org/infinispan/cli/interpreter/IspnQL.g:241:20: ( ',' jsonValue )*
            loop21:
            do {
                int alt21=2;
                switch ( input.LA(1) ) {
                case 58:
                    {
                    alt21=1;
                    }
                    break;

                }

                switch (alt21) {
            	case 1 :
            	    // org/infinispan/cli/interpreter/IspnQL.g:241:21: ',' jsonValue
            	    {
            	    char_literal83=(Token)match(input,58,FOLLOW_58_in_jsonArray1202); 
            	    char_literal83_tree = 
            	    (Object)adaptor.create(char_literal83)
            	    ;
            	    adaptor.addChild(root_0, char_literal83_tree);


            	    pushFollow(FOLLOW_jsonValue_in_jsonArray1204);
            	    jsonValue84=jsonValue();

            	    state._fsp--;

            	    adaptor.addChild(root_0, jsonValue84.getTree());

            	    }
            	    break;

            	default :
            	    break loop21;
                }
            } while (true);


            char_literal85=(Token)match(input,63,FOLLOW_63_in_jsonArray1208); 
            char_literal85_tree = 
            (Object)adaptor.create(char_literal85)
            ;
            adaptor.addChild(root_0, char_literal85_tree);


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "jsonArray"

    // Delegated rules


 

    public static final BitSet FOLLOW_statement_in_statements72 = new BitSet(new long[]{0x00007E02080E0790L});
    public static final BitSet FOLLOW_EOL_in_statements76 = new BitSet(new long[]{0x00007E02080E0790L});
    public static final BitSet FOLLOW_EOF_in_statements81 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_abortBatchStatement_in_statement100 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_beginTransactionStatement_in_statement109 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_cacheStatement_in_statement118 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_clearStatement_in_statement127 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_commitTransactionStatement_in_statement136 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_endBatchStatement_in_statement145 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_evictStatement_in_statement154 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_getStatement_in_statement163 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_locateStatement_in_statement172 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_putIfAbsentStatement_in_statement181 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_putStatement_in_statement190 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_removeStatement_in_statement199 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_replaceStatement_in_statement208 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rollbackTransactionStatement_in_statement217 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_startBatchStatement_in_statement226 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ABORT_in_abortBatchStatement248 = new BitSet(new long[]{0x2000800000040000L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_abortBatchStatement255 = new BitSet(new long[]{0x2000000000040000L});
    public static final BitSet FOLLOW_set_in_abortBatchStatement259 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_BEGIN_in_beginTransactionStatement287 = new BitSet(new long[]{0x2000800000040000L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_beginTransactionStatement294 = new BitSet(new long[]{0x2000000000040000L});
    public static final BitSet FOLLOW_set_in_beginTransactionStatement298 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_CACHE_in_cacheStatement326 = new BitSet(new long[]{0x2000800000040000L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_cacheStatement333 = new BitSet(new long[]{0x2000000000040000L});
    public static final BitSet FOLLOW_set_in_cacheStatement337 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_CLEAR_in_clearStatement365 = new BitSet(new long[]{0x2000000000040000L});
    public static final BitSet FOLLOW_set_in_clearStatement367 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_COMMIT_in_commitTransactionStatement395 = new BitSet(new long[]{0x2000800000040000L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_commitTransactionStatement402 = new BitSet(new long[]{0x2000000000040000L});
    public static final BitSet FOLLOW_set_in_commitTransactionStatement406 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_END_in_endBatchStatement434 = new BitSet(new long[]{0x2000800000040000L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_endBatchStatement441 = new BitSet(new long[]{0x2000000000040000L});
    public static final BitSet FOLLOW_set_in_endBatchStatement445 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_EVICT_in_evictStatement473 = new BitSet(new long[]{0x0028804483002000L,0x0000000000000001L});
    public static final BitSet FOLLOW_keyIdentifier_in_evictStatement479 = new BitSet(new long[]{0x2000000000040000L});
    public static final BitSet FOLLOW_set_in_evictStatement481 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_GET_in_getStatement509 = new BitSet(new long[]{0x0028804483002000L,0x0000000000000001L});
    public static final BitSet FOLLOW_keyIdentifier_in_getStatement515 = new BitSet(new long[]{0x2000000000040000L});
    public static final BitSet FOLLOW_set_in_getStatement517 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_LOCATE_in_locateStatement545 = new BitSet(new long[]{0x0028804483002000L,0x0000000000000001L});
    public static final BitSet FOLLOW_keyIdentifier_in_locateStatement551 = new BitSet(new long[]{0x2000000000040000L});
    public static final BitSet FOLLOW_set_in_locateStatement553 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_PUTIFABSENT_in_putIfAbsentStatement581 = new BitSet(new long[]{0x0028804483002000L,0x0000000000000001L});
    public static final BitSet FOLLOW_keyIdentifier_in_putIfAbsentStatement587 = new BitSet(new long[]{0x0028804483002000L,0x0000000000000001L});
    public static final BitSet FOLLOW_literal_in_putIfAbsentStatement593 = new BitSet(new long[]{0x2000000000140000L});
    public static final BitSet FOLLOW_expirationClause_in_putIfAbsentStatement600 = new BitSet(new long[]{0x2000000000040000L});
    public static final BitSet FOLLOW_set_in_putIfAbsentStatement604 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_PUT_in_putStatement632 = new BitSet(new long[]{0x0028804483002000L,0x0000000000000001L});
    public static final BitSet FOLLOW_keyIdentifier_in_putStatement638 = new BitSet(new long[]{0x0028804483002000L,0x0000000000000001L});
    public static final BitSet FOLLOW_literal_in_putStatement644 = new BitSet(new long[]{0x2000000000140000L});
    public static final BitSet FOLLOW_expirationClause_in_putStatement651 = new BitSet(new long[]{0x2000000000040000L});
    public static final BitSet FOLLOW_set_in_putStatement655 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_REMOVE_in_removeStatement683 = new BitSet(new long[]{0x0028804483002000L,0x0000000000000001L});
    public static final BitSet FOLLOW_keyIdentifier_in_removeStatement689 = new BitSet(new long[]{0x2028804483042000L,0x0000000000000001L});
    public static final BitSet FOLLOW_literal_in_removeStatement696 = new BitSet(new long[]{0x2000000000040000L});
    public static final BitSet FOLLOW_set_in_removeStatement700 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_REPLACE_in_replaceStatement728 = new BitSet(new long[]{0x0028804483002000L,0x0000000000000001L});
    public static final BitSet FOLLOW_keyIdentifier_in_replaceStatement734 = new BitSet(new long[]{0x0028804483002000L,0x0000000000000001L});
    public static final BitSet FOLLOW_literal_in_replaceStatement740 = new BitSet(new long[]{0x2028804483142000L,0x0000000000000001L});
    public static final BitSet FOLLOW_literal_in_replaceStatement747 = new BitSet(new long[]{0x2000000000140000L});
    public static final BitSet FOLLOW_expirationClause_in_replaceStatement756 = new BitSet(new long[]{0x2000000000040000L});
    public static final BitSet FOLLOW_set_in_replaceStatement760 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ROLLBACK_in_rollbackTransactionStatement788 = new BitSet(new long[]{0x2000800000040000L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_rollbackTransactionStatement795 = new BitSet(new long[]{0x2000000000040000L});
    public static final BitSet FOLLOW_set_in_rollbackTransactionStatement799 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_START_in_startBatchStatement827 = new BitSet(new long[]{0x2000800000040000L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_startBatchStatement834 = new BitSet(new long[]{0x2000000000040000L});
    public static final BitSet FOLLOW_set_in_startBatchStatement838 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_EXPIRES_in_expirationClause866 = new BitSet(new long[]{0x0004000000000000L});
    public static final BitSet FOLLOW_timeLiteral_in_expirationClause872 = new BitSet(new long[]{0x0000002000000002L});
    public static final BitSet FOLLOW_MAXIDLE_in_expirationClause875 = new BitSet(new long[]{0x0004000000000000L});
    public static final BitSet FOLLOW_timeLiteral_in_expirationClause881 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_keyIdentifier904 = new BitSet(new long[]{0x0800000000000000L});
    public static final BitSet FOLLOW_59_in_keyIdentifier906 = new BitSet(new long[]{0x0028804483002000L,0x0000000000000001L});
    public static final BitSet FOLLOW_literal_in_keyIdentifier908 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_literal_in_keyIdentifier917 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_INTLITERAL_in_literal938 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_LONGLITERAL_in_literal947 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_FLOATLITERAL_in_literal956 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_DOUBLELITERAL_in_literal965 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_NULL_in_literal974 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_literal983 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_UUIDLITERAL_in_literal992 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_literal1005 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_jsonLiteral_in_literal1022 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_TIMELITERAL_in_timeLiteral1059 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_64_in_jsonLiteral1076 = new BitSet(new long[]{0x0000800000000000L});
    public static final BitSet FOLLOW_jsonPair_in_jsonLiteral1078 = new BitSet(new long[]{0x0400000000000000L,0x0000000000000002L});
    public static final BitSet FOLLOW_58_in_jsonLiteral1081 = new BitSet(new long[]{0x0000800000000000L});
    public static final BitSet FOLLOW_jsonPair_in_jsonLiteral1083 = new BitSet(new long[]{0x0400000000000000L,0x0000000000000002L});
    public static final BitSet FOLLOW_65_in_jsonLiteral1087 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_jsonString_in_jsonPair1102 = new BitSet(new long[]{0x1000000000000000L});
    public static final BitSet FOLLOW_60_in_jsonPair1104 = new BitSet(new long[]{0x4008804081002000L,0x0000000000000001L});
    public static final BitSet FOLLOW_jsonValue_in_jsonPair1106 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_jsonString1121 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_jsonLiteral_in_jsonValue1136 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_jsonArray_in_jsonValue1143 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_INTLITERAL_in_jsonValue1150 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_DOUBLELITERAL_in_jsonValue1157 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_TRUE_in_jsonValue1164 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_FALSE_in_jsonValue1168 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_NULL_in_jsonValue1175 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_jsonString_in_jsonValue1182 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_62_in_jsonArray1197 = new BitSet(new long[]{0x4008804081002000L,0x0000000000000001L});
    public static final BitSet FOLLOW_jsonValue_in_jsonArray1199 = new BitSet(new long[]{0x8400000000000000L});
    public static final BitSet FOLLOW_58_in_jsonArray1202 = new BitSet(new long[]{0x4008804081002000L,0x0000000000000001L});
    public static final BitSet FOLLOW_jsonValue_in_jsonArray1204 = new BitSet(new long[]{0x8400000000000000L});
    public static final BitSet FOLLOW_63_in_jsonArray1208 = new BitSet(new long[]{0x0000000000000002L});

}