/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter.session;

import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.cli.interpreter.session.Session;
import org.infinispan.manager.EmbeddedCacheManager;

public class SessionImpl
implements Session {
    private final EmbeddedCacheManager cacheManager;
    private final String id;
    private Cache<?, ?> cache;
    private long timestamp;

    public SessionImpl(EmbeddedCacheManager cacheManager, String id) {
        this.cacheManager = cacheManager;
        this.id = id;
        this.timestamp = System.nanoTime();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Cache<?, ?> getCache() {
        if (this.cache == null) {
            this.cache = this.cacheManager.getCache();
        }
        return this.cache;
    }

    @Override
    public Cache<?, ?> getCache(String cacheName) {
        Cache c = this.cacheManager.getCache(cacheName, false);
        if (c == null) {
            throw new IllegalArgumentException("No cache named " + cacheName);
        }
        return c;
    }

    @Override
    public void setCacheName(String cacheName) {
        this.cache = this.getCache(cacheName);
    }

    @Override
    public void reset() {
        this.resetCache((Cache<Object, Object>)this.cacheManager.getCache());
        for (String cacheName : this.cacheManager.getCacheNames()) {
            this.resetCache((Cache<Object, Object>)this.cacheManager.getCache(cacheName));
        }
        this.timestamp = System.nanoTime();
    }

    private void resetCache(Cache<Object, Object> cache) {
        if (cache.getCacheConfiguration().invocationBatching().enabled()) {
            cache.endBatch(false);
        }
        TransactionManager tm = cache.getAdvancedCache().getTransactionManager();
        try {
            if (tm.getTransaction() != null) {
                tm.rollback();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }
}

