/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter.statement;

import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.cli.interpreter.result.EmptyResult;
import org.infinispan.cli.interpreter.result.Result;
import org.infinispan.cli.interpreter.session.Session;
import org.infinispan.cli.interpreter.statement.ExpirationData;
import org.infinispan.cli.interpreter.statement.KeyData;
import org.infinispan.cli.interpreter.statement.Statement;

public class ReplaceStatement
implements Statement {
    final KeyData keyData;
    final Object oldValue;
    final Object newValue;
    final Long expires;
    final Long maxIdle;

    public ReplaceStatement(KeyData key, Object newValue, ExpirationData exp) {
        this(key, null, newValue, exp);
    }

    public ReplaceStatement(KeyData key, Object oldValue, Object newValue, ExpirationData exp) {
        this.keyData = key;
        this.oldValue = oldValue;
        this.newValue = newValue;
        if (exp != null) {
            this.expires = exp.expires;
            this.maxIdle = exp.maxIdle;
        } else {
            this.expires = null;
            this.maxIdle = null;
        }
    }

    @Override
    public Result execute(Session session) {
        Cache cache = session.getCache(this.keyData.getCacheName());
        if (this.expires == null) {
            if (this.oldValue != null) {
                cache.replace(this.keyData.getKey(), this.oldValue, this.newValue);
            } else {
                cache.replace(this.keyData.getKey(), this.newValue);
            }
        } else if (this.maxIdle == null) {
            if (this.oldValue != null) {
                cache.replace(this.keyData.getKey(), this.oldValue, this.newValue, this.expires.longValue(), TimeUnit.MILLISECONDS);
            } else {
                cache.replace(this.keyData.getKey(), this.newValue, this.expires.longValue(), TimeUnit.MILLISECONDS);
            }
        } else if (this.oldValue != null) {
            cache.replace(this.keyData.getKey(), this.oldValue, this.newValue, this.expires.longValue(), TimeUnit.MILLISECONDS, this.maxIdle.longValue(), TimeUnit.MILLISECONDS);
        } else {
            cache.replace(this.keyData.getKey(), this.newValue, this.expires.longValue(), TimeUnit.MILLISECONDS, this.maxIdle.longValue(), TimeUnit.MILLISECONDS);
        }
        return EmptyResult.RESULT;
    }
}

