// $ANTLR 3.4 org/infinispan/cli/interpreter/IspnQL.g 2012-12-17 14:01:56

/*
 * JBoss, Home of Professional Open Source
 * Copyright 2012 Red Hat Inc. and/or its affiliates and other contributors
 * as indicated by the @author tags. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
package org.infinispan.cli.interpreter;

import java.io.IOException;
import java.util.Map;
import java.util.HashMap;
import java.util.Collections;
import java.util.List;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.annotate.JsonTypeInfo;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.ObjectMapper.DefaultTyping;

import org.infinispan.cli.interpreter.session.*;
import org.infinispan.cli.interpreter.statement.*;
import static org.infinispan.cli.interpreter.utils.ParserSupport.*;



import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

import org.antlr.runtime.tree.*;


@SuppressWarnings({"all", "warnings", "unchecked"})
public class IspnQLParser extends Parser {
    public static final String[] tokenNames = new String[] {
        "<invalid>", "<EOR>", "<DOWN>", "<UP>", "ABORT", "AlphaChar", "AlphaNumChar", "BEGIN", "CACHE", "CLEAR", "COMMIT", "CREATE", "CharacterEscapeSequence", "Comment", "DOUBLELITERAL", "DecimalDigit", "DoubleQuotedStringCharacter", "DoubleSuffix", "END", "EOL", "EVICT", "EXPIRES", "EscapeCharacter", "EscapeSequence", "Exponent", "FALSE", "FLOATLITERAL", "FloatSuffix", "GET", "HexDigit", "HexEscapeSequence", "HexPrefix", "INFO", "INTLITERAL", "IntegerNumber", "LIKE", "LOCATE", "LONGLITERAL", "LineComment", "LongSuffix", "MAXIDLE", "NULL", "NonEscapeCharacter", "NonIntegerNumber", "PING", "PUT", "PUTIFABSENT", "REMOVE", "REPLACE", "ROLLBACK", "START", "STATS", "STRINGLITERAL", "SingleEscapeCharacter", "SingleQuotedStringCharacter", "TIMELITERAL", "TRUE", "TimeSuffix", "UPGRADE", "UUIDLITERAL", "UnicodeEscapeSequence", "UnquotedStringCharacter", "UnquotedStringStart", "VERSION", "WhiteSpace", "','", "'--'", "'.'", "':'", "';'", "'='", "'['", "']'", "'{'", "'}'"
    };

    public static final int EOF=-1;
    public static final int T__65=65;
    public static final int T__66=66;
    public static final int T__67=67;
    public static final int T__68=68;
    public static final int T__69=69;
    public static final int T__70=70;
    public static final int T__71=71;
    public static final int T__72=72;
    public static final int T__73=73;
    public static final int T__74=74;
    public static final int ABORT=4;
    public static final int AlphaChar=5;
    public static final int AlphaNumChar=6;
    public static final int BEGIN=7;
    public static final int CACHE=8;
    public static final int CLEAR=9;
    public static final int COMMIT=10;
    public static final int CREATE=11;
    public static final int CharacterEscapeSequence=12;
    public static final int Comment=13;
    public static final int DOUBLELITERAL=14;
    public static final int DecimalDigit=15;
    public static final int DoubleQuotedStringCharacter=16;
    public static final int DoubleSuffix=17;
    public static final int END=18;
    public static final int EOL=19;
    public static final int EVICT=20;
    public static final int EXPIRES=21;
    public static final int EscapeCharacter=22;
    public static final int EscapeSequence=23;
    public static final int Exponent=24;
    public static final int FALSE=25;
    public static final int FLOATLITERAL=26;
    public static final int FloatSuffix=27;
    public static final int GET=28;
    public static final int HexDigit=29;
    public static final int HexEscapeSequence=30;
    public static final int HexPrefix=31;
    public static final int INFO=32;
    public static final int INTLITERAL=33;
    public static final int IntegerNumber=34;
    public static final int LIKE=35;
    public static final int LOCATE=36;
    public static final int LONGLITERAL=37;
    public static final int LineComment=38;
    public static final int LongSuffix=39;
    public static final int MAXIDLE=40;
    public static final int NULL=41;
    public static final int NonEscapeCharacter=42;
    public static final int NonIntegerNumber=43;
    public static final int PING=44;
    public static final int PUT=45;
    public static final int PUTIFABSENT=46;
    public static final int REMOVE=47;
    public static final int REPLACE=48;
    public static final int ROLLBACK=49;
    public static final int START=50;
    public static final int STATS=51;
    public static final int STRINGLITERAL=52;
    public static final int SingleEscapeCharacter=53;
    public static final int SingleQuotedStringCharacter=54;
    public static final int TIMELITERAL=55;
    public static final int TRUE=56;
    public static final int TimeSuffix=57;
    public static final int UPGRADE=58;
    public static final int UUIDLITERAL=59;
    public static final int UnicodeEscapeSequence=60;
    public static final int UnquotedStringCharacter=61;
    public static final int UnquotedStringStart=62;
    public static final int VERSION=63;
    public static final int WhiteSpace=64;

    // delegates
    public Parser[] getDelegates() {
        return new Parser[] {};
    }

    // delegators


    public IspnQLParser(TokenStream input) {
        this(input, new RecognizerSharedState());
    }
    public IspnQLParser(TokenStream input, RecognizerSharedState state) {
        super(input, state);
    }

protected TreeAdaptor adaptor = new CommonTreeAdaptor();

public void setTreeAdaptor(TreeAdaptor adaptor) {
    this.adaptor = adaptor;
}
public TreeAdaptor getTreeAdaptor() {
    return adaptor;
}
    public String[] getTokenNames() { return IspnQLParser.tokenNames; }
    public String getGrammarFileName() { return "org/infinispan/cli/interpreter/IspnQL.g"; }


       private List<String> parserErrors = new ArrayList<String>();
       protected List<Statement> statements = new ArrayList<Statement>();
       private ObjectMapper jsonMapper = new ObjectMapper().enableDefaultTyping(DefaultTyping.NON_FINAL, JsonTypeInfo.As.WRAPPER_OBJECT);

       public void displayRecognitionError(String[] tokenNames, RecognitionException e) {
         parserErrors.add(getErrorHeader(e)+" "+getErrorMessage(e, tokenNames));
       }

       public List<String> getParserErrors() {
         return parserErrors;
       }


    public static class statements_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "statements"
    // org/infinispan/cli/interpreter/IspnQL.g:106:1: statements : ( statement ( EOL )* )* EOF ;
    public final IspnQLParser.statements_return statements() throws RecognitionException {
        IspnQLParser.statements_return retval = new IspnQLParser.statements_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token EOL2=null;
        Token EOF3=null;
        IspnQLParser.statement_return statement1 =null;


        Object EOL2_tree=null;
        Object EOF3_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:107:4: ( ( statement ( EOL )* )* EOF )
            // org/infinispan/cli/interpreter/IspnQL.g:107:6: ( statement ( EOL )* )* EOF
            {
            // org/infinispan/cli/interpreter/IspnQL.g:107:6: ( statement ( EOL )* )*
            loop2:
            do {
                int alt2=2;
                switch ( input.LA(1) ) {
                case ABORT:
                case BEGIN:
                case CACHE:
                case CLEAR:
                case COMMIT:
                case CREATE:
                case END:
                case EVICT:
                case GET:
                case INFO:
                case LOCATE:
                case PING:
                case PUT:
                case PUTIFABSENT:
                case REMOVE:
                case REPLACE:
                case ROLLBACK:
                case START:
                case STATS:
                case UPGRADE:
                case VERSION:
                    {
                    alt2=1;
                    }
                    break;

                }

                switch (alt2) {
            	case 1 :
            	    // org/infinispan/cli/interpreter/IspnQL.g:107:7: statement ( EOL )*
            	    {
            	    pushFollow(FOLLOW_statement_in_statements72);
            	    statement1=statement();

            	    state._fsp--;

            	    adaptor.addChild(root_0, statement1.getTree());

            	     statements.add((statement1!=null?statement1.stmt:null)); 

            	    // org/infinispan/cli/interpreter/IspnQL.g:107:54: ( EOL )*
            	    loop1:
            	    do {
            	        int alt1=2;
            	        switch ( input.LA(1) ) {
            	        case EOL:
            	            {
            	            alt1=1;
            	            }
            	            break;

            	        }

            	        switch (alt1) {
            	    	case 1 :
            	    	    // org/infinispan/cli/interpreter/IspnQL.g:107:54: EOL
            	    	    {
            	    	    EOL2=(Token)match(input,EOL,FOLLOW_EOL_in_statements76); 
            	    	    EOL2_tree = 
            	    	    (Object)adaptor.create(EOL2)
            	    	    ;
            	    	    adaptor.addChild(root_0, EOL2_tree);


            	    	    }
            	    	    break;

            	    	default :
            	    	    break loop1;
            	        }
            	    } while (true);


            	    }
            	    break;

            	default :
            	    break loop2;
                }
            } while (true);


            EOF3=(Token)match(input,EOF,FOLLOW_EOF_in_statements81); 
            EOF3_tree = 
            (Object)adaptor.create(EOF3)
            ;
            adaptor.addChild(root_0, EOF3_tree);


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "statements"


    public static class statement_return extends ParserRuleReturnScope {
        public Statement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "statement"
    // org/infinispan/cli/interpreter/IspnQL.g:110:1: statement returns [Statement stmt] : ( abortBatchStatement | beginTransactionStatement | cacheStatement | clearStatement | commitTransactionStatement | createStatement | endBatchStatement | evictStatement | getStatement | infoStatement | locateStatement | pingStatement | putIfAbsentStatement | putStatement | removeStatement | replaceStatement | rollbackTransactionStatement | startBatchStatement | statsStatement | upgradeStatement | versionStatement );
    public final IspnQLParser.statement_return statement() throws RecognitionException {
        IspnQLParser.statement_return retval = new IspnQLParser.statement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        IspnQLParser.abortBatchStatement_return abortBatchStatement4 =null;

        IspnQLParser.beginTransactionStatement_return beginTransactionStatement5 =null;

        IspnQLParser.cacheStatement_return cacheStatement6 =null;

        IspnQLParser.clearStatement_return clearStatement7 =null;

        IspnQLParser.commitTransactionStatement_return commitTransactionStatement8 =null;

        IspnQLParser.createStatement_return createStatement9 =null;

        IspnQLParser.endBatchStatement_return endBatchStatement10 =null;

        IspnQLParser.evictStatement_return evictStatement11 =null;

        IspnQLParser.getStatement_return getStatement12 =null;

        IspnQLParser.infoStatement_return infoStatement13 =null;

        IspnQLParser.locateStatement_return locateStatement14 =null;

        IspnQLParser.pingStatement_return pingStatement15 =null;

        IspnQLParser.putIfAbsentStatement_return putIfAbsentStatement16 =null;

        IspnQLParser.putStatement_return putStatement17 =null;

        IspnQLParser.removeStatement_return removeStatement18 =null;

        IspnQLParser.replaceStatement_return replaceStatement19 =null;

        IspnQLParser.rollbackTransactionStatement_return rollbackTransactionStatement20 =null;

        IspnQLParser.startBatchStatement_return startBatchStatement21 =null;

        IspnQLParser.statsStatement_return statsStatement22 =null;

        IspnQLParser.upgradeStatement_return upgradeStatement23 =null;

        IspnQLParser.versionStatement_return versionStatement24 =null;



        try {
            // org/infinispan/cli/interpreter/IspnQL.g:111:4: ( abortBatchStatement | beginTransactionStatement | cacheStatement | clearStatement | commitTransactionStatement | createStatement | endBatchStatement | evictStatement | getStatement | infoStatement | locateStatement | pingStatement | putIfAbsentStatement | putStatement | removeStatement | replaceStatement | rollbackTransactionStatement | startBatchStatement | statsStatement | upgradeStatement | versionStatement )
            int alt3=21;
            switch ( input.LA(1) ) {
            case ABORT:
                {
                alt3=1;
                }
                break;
            case BEGIN:
                {
                alt3=2;
                }
                break;
            case CACHE:
                {
                alt3=3;
                }
                break;
            case CLEAR:
                {
                alt3=4;
                }
                break;
            case COMMIT:
                {
                alt3=5;
                }
                break;
            case CREATE:
                {
                alt3=6;
                }
                break;
            case END:
                {
                alt3=7;
                }
                break;
            case EVICT:
                {
                alt3=8;
                }
                break;
            case GET:
                {
                alt3=9;
                }
                break;
            case INFO:
                {
                alt3=10;
                }
                break;
            case LOCATE:
                {
                alt3=11;
                }
                break;
            case PING:
                {
                alt3=12;
                }
                break;
            case PUTIFABSENT:
                {
                alt3=13;
                }
                break;
            case PUT:
                {
                alt3=14;
                }
                break;
            case REMOVE:
                {
                alt3=15;
                }
                break;
            case REPLACE:
                {
                alt3=16;
                }
                break;
            case ROLLBACK:
                {
                alt3=17;
                }
                break;
            case START:
                {
                alt3=18;
                }
                break;
            case STATS:
                {
                alt3=19;
                }
                break;
            case UPGRADE:
                {
                alt3=20;
                }
                break;
            case VERSION:
                {
                alt3=21;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 3, 0, input);

                throw nvae;

            }

            switch (alt3) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:111:6: abortBatchStatement
                    {
                    pushFollow(FOLLOW_abortBatchStatement_in_statement100);
                    abortBatchStatement4=abortBatchStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, abortBatchStatement4.getTree());

                     retval.stmt = (abortBatchStatement4!=null?abortBatchStatement4.stmt:null); 

                    }
                    break;
                case 2 :
                    // org/infinispan/cli/interpreter/IspnQL.g:112:6: beginTransactionStatement
                    {
                    pushFollow(FOLLOW_beginTransactionStatement_in_statement109);
                    beginTransactionStatement5=beginTransactionStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, beginTransactionStatement5.getTree());

                     retval.stmt = (beginTransactionStatement5!=null?beginTransactionStatement5.stmt:null); 

                    }
                    break;
                case 3 :
                    // org/infinispan/cli/interpreter/IspnQL.g:113:6: cacheStatement
                    {
                    pushFollow(FOLLOW_cacheStatement_in_statement118);
                    cacheStatement6=cacheStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, cacheStatement6.getTree());

                     retval.stmt = (cacheStatement6!=null?cacheStatement6.stmt:null); 

                    }
                    break;
                case 4 :
                    // org/infinispan/cli/interpreter/IspnQL.g:114:6: clearStatement
                    {
                    pushFollow(FOLLOW_clearStatement_in_statement127);
                    clearStatement7=clearStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, clearStatement7.getTree());

                     retval.stmt = (clearStatement7!=null?clearStatement7.stmt:null); 

                    }
                    break;
                case 5 :
                    // org/infinispan/cli/interpreter/IspnQL.g:115:6: commitTransactionStatement
                    {
                    pushFollow(FOLLOW_commitTransactionStatement_in_statement136);
                    commitTransactionStatement8=commitTransactionStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, commitTransactionStatement8.getTree());

                     retval.stmt = (commitTransactionStatement8!=null?commitTransactionStatement8.stmt:null); 

                    }
                    break;
                case 6 :
                    // org/infinispan/cli/interpreter/IspnQL.g:116:6: createStatement
                    {
                    pushFollow(FOLLOW_createStatement_in_statement145);
                    createStatement9=createStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, createStatement9.getTree());

                     retval.stmt = (createStatement9!=null?createStatement9.stmt:null); 

                    }
                    break;
                case 7 :
                    // org/infinispan/cli/interpreter/IspnQL.g:117:6: endBatchStatement
                    {
                    pushFollow(FOLLOW_endBatchStatement_in_statement154);
                    endBatchStatement10=endBatchStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, endBatchStatement10.getTree());

                     retval.stmt = (endBatchStatement10!=null?endBatchStatement10.stmt:null); 

                    }
                    break;
                case 8 :
                    // org/infinispan/cli/interpreter/IspnQL.g:118:6: evictStatement
                    {
                    pushFollow(FOLLOW_evictStatement_in_statement163);
                    evictStatement11=evictStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, evictStatement11.getTree());

                     retval.stmt = (evictStatement11!=null?evictStatement11.stmt:null); 

                    }
                    break;
                case 9 :
                    // org/infinispan/cli/interpreter/IspnQL.g:119:6: getStatement
                    {
                    pushFollow(FOLLOW_getStatement_in_statement172);
                    getStatement12=getStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, getStatement12.getTree());

                     retval.stmt = (getStatement12!=null?getStatement12.stmt:null); 

                    }
                    break;
                case 10 :
                    // org/infinispan/cli/interpreter/IspnQL.g:120:6: infoStatement
                    {
                    pushFollow(FOLLOW_infoStatement_in_statement181);
                    infoStatement13=infoStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, infoStatement13.getTree());

                     retval.stmt = (infoStatement13!=null?infoStatement13.stmt:null); 

                    }
                    break;
                case 11 :
                    // org/infinispan/cli/interpreter/IspnQL.g:121:6: locateStatement
                    {
                    pushFollow(FOLLOW_locateStatement_in_statement190);
                    locateStatement14=locateStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, locateStatement14.getTree());

                     retval.stmt = (locateStatement14!=null?locateStatement14.stmt:null); 

                    }
                    break;
                case 12 :
                    // org/infinispan/cli/interpreter/IspnQL.g:122:6: pingStatement
                    {
                    pushFollow(FOLLOW_pingStatement_in_statement199);
                    pingStatement15=pingStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, pingStatement15.getTree());

                     retval.stmt = (pingStatement15!=null?pingStatement15.stmt:null); 

                    }
                    break;
                case 13 :
                    // org/infinispan/cli/interpreter/IspnQL.g:123:6: putIfAbsentStatement
                    {
                    pushFollow(FOLLOW_putIfAbsentStatement_in_statement208);
                    putIfAbsentStatement16=putIfAbsentStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, putIfAbsentStatement16.getTree());

                     retval.stmt = (putIfAbsentStatement16!=null?putIfAbsentStatement16.stmt:null); 

                    }
                    break;
                case 14 :
                    // org/infinispan/cli/interpreter/IspnQL.g:124:6: putStatement
                    {
                    pushFollow(FOLLOW_putStatement_in_statement217);
                    putStatement17=putStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, putStatement17.getTree());

                     retval.stmt = (putStatement17!=null?putStatement17.stmt:null); 

                    }
                    break;
                case 15 :
                    // org/infinispan/cli/interpreter/IspnQL.g:125:6: removeStatement
                    {
                    pushFollow(FOLLOW_removeStatement_in_statement226);
                    removeStatement18=removeStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, removeStatement18.getTree());

                     retval.stmt = (removeStatement18!=null?removeStatement18.stmt:null); 

                    }
                    break;
                case 16 :
                    // org/infinispan/cli/interpreter/IspnQL.g:126:6: replaceStatement
                    {
                    pushFollow(FOLLOW_replaceStatement_in_statement235);
                    replaceStatement19=replaceStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, replaceStatement19.getTree());

                     retval.stmt = (replaceStatement19!=null?replaceStatement19.stmt:null); 

                    }
                    break;
                case 17 :
                    // org/infinispan/cli/interpreter/IspnQL.g:127:6: rollbackTransactionStatement
                    {
                    pushFollow(FOLLOW_rollbackTransactionStatement_in_statement244);
                    rollbackTransactionStatement20=rollbackTransactionStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, rollbackTransactionStatement20.getTree());

                     retval.stmt = (rollbackTransactionStatement20!=null?rollbackTransactionStatement20.stmt:null); 

                    }
                    break;
                case 18 :
                    // org/infinispan/cli/interpreter/IspnQL.g:128:6: startBatchStatement
                    {
                    pushFollow(FOLLOW_startBatchStatement_in_statement253);
                    startBatchStatement21=startBatchStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, startBatchStatement21.getTree());

                     retval.stmt = (startBatchStatement21!=null?startBatchStatement21.stmt:null); 

                    }
                    break;
                case 19 :
                    // org/infinispan/cli/interpreter/IspnQL.g:129:6: statsStatement
                    {
                    pushFollow(FOLLOW_statsStatement_in_statement262);
                    statsStatement22=statsStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, statsStatement22.getTree());

                     retval.stmt = (statsStatement22!=null?statsStatement22.stmt:null); 

                    }
                    break;
                case 20 :
                    // org/infinispan/cli/interpreter/IspnQL.g:130:6: upgradeStatement
                    {
                    pushFollow(FOLLOW_upgradeStatement_in_statement271);
                    upgradeStatement23=upgradeStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, upgradeStatement23.getTree());

                     retval.stmt = (upgradeStatement23!=null?upgradeStatement23.stmt:null); 

                    }
                    break;
                case 21 :
                    // org/infinispan/cli/interpreter/IspnQL.g:131:6: versionStatement
                    {
                    pushFollow(FOLLOW_versionStatement_in_statement280);
                    versionStatement24=versionStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, versionStatement24.getTree());

                     retval.stmt = (versionStatement24!=null?versionStatement24.stmt:null); 

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "statement"


    public static class abortBatchStatement_return extends ParserRuleReturnScope {
        public EndBatchStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "abortBatchStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:135:1: abortBatchStatement returns [EndBatchStatement stmt] : ABORT (cacheName= STRINGLITERAL )? ( EOL | ';' ) !;
    public final IspnQLParser.abortBatchStatement_return abortBatchStatement() throws RecognitionException {
        IspnQLParser.abortBatchStatement_return retval = new IspnQLParser.abortBatchStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token cacheName=null;
        Token ABORT25=null;
        Token set26=null;

        Object cacheName_tree=null;
        Object ABORT25_tree=null;
        Object set26_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:136:4: ( ABORT (cacheName= STRINGLITERAL )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:136:6: ABORT (cacheName= STRINGLITERAL )? ( EOL | ';' ) !
            {
            ABORT25=(Token)match(input,ABORT,FOLLOW_ABORT_in_abortBatchStatement302); 
            ABORT25_tree = 
            (Object)adaptor.create(ABORT25)
            ;
            adaptor.addChild(root_0, ABORT25_tree);


            // org/infinispan/cli/interpreter/IspnQL.g:136:12: (cacheName= STRINGLITERAL )?
            int alt4=2;
            switch ( input.LA(1) ) {
                case STRINGLITERAL:
                    {
                    alt4=1;
                    }
                    break;
            }

            switch (alt4) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:136:13: cacheName= STRINGLITERAL
                    {
                    cacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_abortBatchStatement309); 
                    cacheName_tree = 
                    (Object)adaptor.create(cacheName)
                    ;
                    adaptor.addChild(root_0, cacheName_tree);


                    }
                    break;

            }


            set26=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==69 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new EndBatchStatement(unquote((cacheName!=null?cacheName.getText():null)), false); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "abortBatchStatement"


    public static class beginTransactionStatement_return extends ParserRuleReturnScope {
        public BeginTransactionStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "beginTransactionStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:139:1: beginTransactionStatement returns [BeginTransactionStatement stmt] : BEGIN (cacheName= STRINGLITERAL )? ( EOL | ';' ) !;
    public final IspnQLParser.beginTransactionStatement_return beginTransactionStatement() throws RecognitionException {
        IspnQLParser.beginTransactionStatement_return retval = new IspnQLParser.beginTransactionStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token cacheName=null;
        Token BEGIN27=null;
        Token set28=null;

        Object cacheName_tree=null;
        Object BEGIN27_tree=null;
        Object set28_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:140:4: ( BEGIN (cacheName= STRINGLITERAL )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:140:6: BEGIN (cacheName= STRINGLITERAL )? ( EOL | ';' ) !
            {
            BEGIN27=(Token)match(input,BEGIN,FOLLOW_BEGIN_in_beginTransactionStatement341); 
            BEGIN27_tree = 
            (Object)adaptor.create(BEGIN27)
            ;
            adaptor.addChild(root_0, BEGIN27_tree);


            // org/infinispan/cli/interpreter/IspnQL.g:140:12: (cacheName= STRINGLITERAL )?
            int alt5=2;
            switch ( input.LA(1) ) {
                case STRINGLITERAL:
                    {
                    alt5=1;
                    }
                    break;
            }

            switch (alt5) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:140:13: cacheName= STRINGLITERAL
                    {
                    cacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_beginTransactionStatement348); 
                    cacheName_tree = 
                    (Object)adaptor.create(cacheName)
                    ;
                    adaptor.addChild(root_0, cacheName_tree);


                    }
                    break;

            }


            set28=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==69 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new BeginTransactionStatement(unquote((cacheName!=null?cacheName.getText():null))); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "beginTransactionStatement"


    public static class cacheStatement_return extends ParserRuleReturnScope {
        public CacheStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "cacheStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:143:1: cacheStatement returns [CacheStatement stmt] : CACHE (cacheName= STRINGLITERAL )? ( EOL | ';' ) !;
    public final IspnQLParser.cacheStatement_return cacheStatement() throws RecognitionException {
        IspnQLParser.cacheStatement_return retval = new IspnQLParser.cacheStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token cacheName=null;
        Token CACHE29=null;
        Token set30=null;

        Object cacheName_tree=null;
        Object CACHE29_tree=null;
        Object set30_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:144:4: ( CACHE (cacheName= STRINGLITERAL )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:144:6: CACHE (cacheName= STRINGLITERAL )? ( EOL | ';' ) !
            {
            CACHE29=(Token)match(input,CACHE,FOLLOW_CACHE_in_cacheStatement380); 
            CACHE29_tree = 
            (Object)adaptor.create(CACHE29)
            ;
            adaptor.addChild(root_0, CACHE29_tree);


            // org/infinispan/cli/interpreter/IspnQL.g:144:12: (cacheName= STRINGLITERAL )?
            int alt6=2;
            switch ( input.LA(1) ) {
                case STRINGLITERAL:
                    {
                    alt6=1;
                    }
                    break;
            }

            switch (alt6) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:144:13: cacheName= STRINGLITERAL
                    {
                    cacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_cacheStatement387); 
                    cacheName_tree = 
                    (Object)adaptor.create(cacheName)
                    ;
                    adaptor.addChild(root_0, cacheName_tree);


                    }
                    break;

            }


            set30=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==69 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new CacheStatement(unquote((cacheName!=null?cacheName.getText():null))); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "cacheStatement"


    public static class clearStatement_return extends ParserRuleReturnScope {
        public ClearStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "clearStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:147:1: clearStatement returns [ClearStatement stmt] : CLEAR (cacheName= STRINGLITERAL )? ( EOL | ';' ) !;
    public final IspnQLParser.clearStatement_return clearStatement() throws RecognitionException {
        IspnQLParser.clearStatement_return retval = new IspnQLParser.clearStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token cacheName=null;
        Token CLEAR31=null;
        Token set32=null;

        Object cacheName_tree=null;
        Object CLEAR31_tree=null;
        Object set32_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:148:4: ( CLEAR (cacheName= STRINGLITERAL )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:148:6: CLEAR (cacheName= STRINGLITERAL )? ( EOL | ';' ) !
            {
            CLEAR31=(Token)match(input,CLEAR,FOLLOW_CLEAR_in_clearStatement419); 
            CLEAR31_tree = 
            (Object)adaptor.create(CLEAR31)
            ;
            adaptor.addChild(root_0, CLEAR31_tree);


            // org/infinispan/cli/interpreter/IspnQL.g:148:12: (cacheName= STRINGLITERAL )?
            int alt7=2;
            switch ( input.LA(1) ) {
                case STRINGLITERAL:
                    {
                    alt7=1;
                    }
                    break;
            }

            switch (alt7) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:148:13: cacheName= STRINGLITERAL
                    {
                    cacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_clearStatement426); 
                    cacheName_tree = 
                    (Object)adaptor.create(cacheName)
                    ;
                    adaptor.addChild(root_0, cacheName_tree);


                    }
                    break;

            }


            set32=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==69 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new ClearStatement(unquote((cacheName!=null?cacheName.getText():null))); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "clearStatement"


    public static class commitTransactionStatement_return extends ParserRuleReturnScope {
        public CommitTransactionStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "commitTransactionStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:151:1: commitTransactionStatement returns [CommitTransactionStatement stmt] : COMMIT (cacheName= STRINGLITERAL )? ( EOL | ';' ) !;
    public final IspnQLParser.commitTransactionStatement_return commitTransactionStatement() throws RecognitionException {
        IspnQLParser.commitTransactionStatement_return retval = new IspnQLParser.commitTransactionStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token cacheName=null;
        Token COMMIT33=null;
        Token set34=null;

        Object cacheName_tree=null;
        Object COMMIT33_tree=null;
        Object set34_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:152:4: ( COMMIT (cacheName= STRINGLITERAL )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:152:6: COMMIT (cacheName= STRINGLITERAL )? ( EOL | ';' ) !
            {
            COMMIT33=(Token)match(input,COMMIT,FOLLOW_COMMIT_in_commitTransactionStatement458); 
            COMMIT33_tree = 
            (Object)adaptor.create(COMMIT33)
            ;
            adaptor.addChild(root_0, COMMIT33_tree);


            // org/infinispan/cli/interpreter/IspnQL.g:152:13: (cacheName= STRINGLITERAL )?
            int alt8=2;
            switch ( input.LA(1) ) {
                case STRINGLITERAL:
                    {
                    alt8=1;
                    }
                    break;
            }

            switch (alt8) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:152:14: cacheName= STRINGLITERAL
                    {
                    cacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_commitTransactionStatement465); 
                    cacheName_tree = 
                    (Object)adaptor.create(cacheName)
                    ;
                    adaptor.addChild(root_0, cacheName_tree);


                    }
                    break;

            }


            set34=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==69 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new CommitTransactionStatement(unquote((cacheName!=null?cacheName.getText():null))); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "commitTransactionStatement"


    public static class createStatement_return extends ParserRuleReturnScope {
        public CreateStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "createStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:155:1: createStatement returns [CreateStatement stmt] : CREATE cacheName= STRINGLITERAL ( LIKE baseCacheName= STRINGLITERAL )? ( EOL | ';' ) !;
    public final IspnQLParser.createStatement_return createStatement() throws RecognitionException {
        IspnQLParser.createStatement_return retval = new IspnQLParser.createStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token cacheName=null;
        Token baseCacheName=null;
        Token CREATE35=null;
        Token LIKE36=null;
        Token set37=null;

        Object cacheName_tree=null;
        Object baseCacheName_tree=null;
        Object CREATE35_tree=null;
        Object LIKE36_tree=null;
        Object set37_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:156:4: ( CREATE cacheName= STRINGLITERAL ( LIKE baseCacheName= STRINGLITERAL )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:156:6: CREATE cacheName= STRINGLITERAL ( LIKE baseCacheName= STRINGLITERAL )? ( EOL | ';' ) !
            {
            CREATE35=(Token)match(input,CREATE,FOLLOW_CREATE_in_createStatement497); 
            CREATE35_tree = 
            (Object)adaptor.create(CREATE35)
            ;
            adaptor.addChild(root_0, CREATE35_tree);


            cacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_createStatement503); 
            cacheName_tree = 
            (Object)adaptor.create(cacheName)
            ;
            adaptor.addChild(root_0, cacheName_tree);


            // org/infinispan/cli/interpreter/IspnQL.g:156:39: ( LIKE baseCacheName= STRINGLITERAL )?
            int alt9=2;
            switch ( input.LA(1) ) {
                case LIKE:
                    {
                    alt9=1;
                    }
                    break;
            }

            switch (alt9) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:156:40: LIKE baseCacheName= STRINGLITERAL
                    {
                    LIKE36=(Token)match(input,LIKE,FOLLOW_LIKE_in_createStatement506); 
                    LIKE36_tree = 
                    (Object)adaptor.create(LIKE36)
                    ;
                    adaptor.addChild(root_0, LIKE36_tree);


                    baseCacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_createStatement512); 
                    baseCacheName_tree = 
                    (Object)adaptor.create(baseCacheName)
                    ;
                    adaptor.addChild(root_0, baseCacheName_tree);


                    }
                    break;

            }


            set37=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==69 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new CreateStatement(unquote((cacheName!=null?cacheName.getText():null)), unquote((baseCacheName!=null?baseCacheName.getText():null))); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "createStatement"


    public static class endBatchStatement_return extends ParserRuleReturnScope {
        public EndBatchStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "endBatchStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:159:1: endBatchStatement returns [EndBatchStatement stmt] : END (cacheName= STRINGLITERAL )? ( EOL | ';' ) !;
    public final IspnQLParser.endBatchStatement_return endBatchStatement() throws RecognitionException {
        IspnQLParser.endBatchStatement_return retval = new IspnQLParser.endBatchStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token cacheName=null;
        Token END38=null;
        Token set39=null;

        Object cacheName_tree=null;
        Object END38_tree=null;
        Object set39_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:160:4: ( END (cacheName= STRINGLITERAL )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:160:6: END (cacheName= STRINGLITERAL )? ( EOL | ';' ) !
            {
            END38=(Token)match(input,END,FOLLOW_END_in_endBatchStatement547); 
            END38_tree = 
            (Object)adaptor.create(END38)
            ;
            adaptor.addChild(root_0, END38_tree);


            // org/infinispan/cli/interpreter/IspnQL.g:160:10: (cacheName= STRINGLITERAL )?
            int alt10=2;
            switch ( input.LA(1) ) {
                case STRINGLITERAL:
                    {
                    alt10=1;
                    }
                    break;
            }

            switch (alt10) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:160:11: cacheName= STRINGLITERAL
                    {
                    cacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_endBatchStatement554); 
                    cacheName_tree = 
                    (Object)adaptor.create(cacheName)
                    ;
                    adaptor.addChild(root_0, cacheName_tree);


                    }
                    break;

            }


            set39=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==69 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new EndBatchStatement(unquote((cacheName!=null?cacheName.getText():null)), true); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "endBatchStatement"


    public static class evictStatement_return extends ParserRuleReturnScope {
        public EvictStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "evictStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:163:1: evictStatement returns [EvictStatement stmt] : EVICT key= keyIdentifier ( EOL | ';' ) !;
    public final IspnQLParser.evictStatement_return evictStatement() throws RecognitionException {
        IspnQLParser.evictStatement_return retval = new IspnQLParser.evictStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token EVICT40=null;
        Token set41=null;
        IspnQLParser.keyIdentifier_return key =null;


        Object EVICT40_tree=null;
        Object set41_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:164:4: ( EVICT key= keyIdentifier ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:164:6: EVICT key= keyIdentifier ( EOL | ';' ) !
            {
            EVICT40=(Token)match(input,EVICT,FOLLOW_EVICT_in_evictStatement586); 
            EVICT40_tree = 
            (Object)adaptor.create(EVICT40)
            ;
            adaptor.addChild(root_0, EVICT40_tree);


            pushFollow(FOLLOW_keyIdentifier_in_evictStatement592);
            key=keyIdentifier();

            state._fsp--;

            adaptor.addChild(root_0, key.getTree());

            set41=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==69 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new EvictStatement((key!=null?key.key:null)); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "evictStatement"


    public static class getStatement_return extends ParserRuleReturnScope {
        public GetStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "getStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:167:1: getStatement returns [GetStatement stmt] : GET key= keyIdentifier ( EOL | ';' ) !;
    public final IspnQLParser.getStatement_return getStatement() throws RecognitionException {
        IspnQLParser.getStatement_return retval = new IspnQLParser.getStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token GET42=null;
        Token set43=null;
        IspnQLParser.keyIdentifier_return key =null;


        Object GET42_tree=null;
        Object set43_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:168:4: ( GET key= keyIdentifier ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:168:6: GET key= keyIdentifier ( EOL | ';' ) !
            {
            GET42=(Token)match(input,GET,FOLLOW_GET_in_getStatement622); 
            GET42_tree = 
            (Object)adaptor.create(GET42)
            ;
            adaptor.addChild(root_0, GET42_tree);


            pushFollow(FOLLOW_keyIdentifier_in_getStatement628);
            key=keyIdentifier();

            state._fsp--;

            adaptor.addChild(root_0, key.getTree());

            set43=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==69 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new GetStatement((key!=null?key.key:null)); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "getStatement"


    public static class infoStatement_return extends ParserRuleReturnScope {
        public InfoStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "infoStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:171:1: infoStatement returns [InfoStatement stmt] : INFO (cacheName= STRINGLITERAL )? ( EOL | ';' ) !;
    public final IspnQLParser.infoStatement_return infoStatement() throws RecognitionException {
        IspnQLParser.infoStatement_return retval = new IspnQLParser.infoStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token cacheName=null;
        Token INFO44=null;
        Token set45=null;

        Object cacheName_tree=null;
        Object INFO44_tree=null;
        Object set45_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:172:4: ( INFO (cacheName= STRINGLITERAL )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:172:6: INFO (cacheName= STRINGLITERAL )? ( EOL | ';' ) !
            {
            INFO44=(Token)match(input,INFO,FOLLOW_INFO_in_infoStatement658); 
            INFO44_tree = 
            (Object)adaptor.create(INFO44)
            ;
            adaptor.addChild(root_0, INFO44_tree);


            // org/infinispan/cli/interpreter/IspnQL.g:172:11: (cacheName= STRINGLITERAL )?
            int alt11=2;
            switch ( input.LA(1) ) {
                case STRINGLITERAL:
                    {
                    alt11=1;
                    }
                    break;
            }

            switch (alt11) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:172:12: cacheName= STRINGLITERAL
                    {
                    cacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_infoStatement665); 
                    cacheName_tree = 
                    (Object)adaptor.create(cacheName)
                    ;
                    adaptor.addChild(root_0, cacheName_tree);


                    }
                    break;

            }


            set45=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==69 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new InfoStatement(unquote((cacheName!=null?cacheName.getText():null))); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "infoStatement"


    public static class locateStatement_return extends ParserRuleReturnScope {
        public LocateStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "locateStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:175:1: locateStatement returns [LocateStatement stmt] : LOCATE key= keyIdentifier ( EOL | ';' ) !;
    public final IspnQLParser.locateStatement_return locateStatement() throws RecognitionException {
        IspnQLParser.locateStatement_return retval = new IspnQLParser.locateStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token LOCATE46=null;
        Token set47=null;
        IspnQLParser.keyIdentifier_return key =null;


        Object LOCATE46_tree=null;
        Object set47_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:176:4: ( LOCATE key= keyIdentifier ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:176:6: LOCATE key= keyIdentifier ( EOL | ';' ) !
            {
            LOCATE46=(Token)match(input,LOCATE,FOLLOW_LOCATE_in_locateStatement697); 
            LOCATE46_tree = 
            (Object)adaptor.create(LOCATE46)
            ;
            adaptor.addChild(root_0, LOCATE46_tree);


            pushFollow(FOLLOW_keyIdentifier_in_locateStatement703);
            key=keyIdentifier();

            state._fsp--;

            adaptor.addChild(root_0, key.getTree());

            set47=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==69 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new LocateStatement((key!=null?key.key:null)); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "locateStatement"


    public static class pingStatement_return extends ParserRuleReturnScope {
        public PingStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "pingStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:179:1: pingStatement returns [PingStatement stmt] : PING ( EOL | ';' ) !;
    public final IspnQLParser.pingStatement_return pingStatement() throws RecognitionException {
        IspnQLParser.pingStatement_return retval = new IspnQLParser.pingStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token PING48=null;
        Token set49=null;

        Object PING48_tree=null;
        Object set49_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:180:4: ( PING ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:180:6: PING ( EOL | ';' ) !
            {
            PING48=(Token)match(input,PING,FOLLOW_PING_in_pingStatement733); 
            PING48_tree = 
            (Object)adaptor.create(PING48)
            ;
            adaptor.addChild(root_0, PING48_tree);


            set49=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==69 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new PingStatement(); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "pingStatement"


    public static class putIfAbsentStatement_return extends ParserRuleReturnScope {
        public PutIfAbsentStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "putIfAbsentStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:183:1: putIfAbsentStatement returns [PutIfAbsentStatement stmt] : PUTIFABSENT key= keyIdentifier value= literal (exp= expirationClause )? ( EOL | ';' ) !;
    public final IspnQLParser.putIfAbsentStatement_return putIfAbsentStatement() throws RecognitionException {
        IspnQLParser.putIfAbsentStatement_return retval = new IspnQLParser.putIfAbsentStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token PUTIFABSENT50=null;
        Token set51=null;
        IspnQLParser.keyIdentifier_return key =null;

        IspnQLParser.literal_return value =null;

        IspnQLParser.expirationClause_return exp =null;


        Object PUTIFABSENT50_tree=null;
        Object set51_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:184:4: ( PUTIFABSENT key= keyIdentifier value= literal (exp= expirationClause )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:184:6: PUTIFABSENT key= keyIdentifier value= literal (exp= expirationClause )? ( EOL | ';' ) !
            {
            PUTIFABSENT50=(Token)match(input,PUTIFABSENT,FOLLOW_PUTIFABSENT_in_putIfAbsentStatement763); 
            PUTIFABSENT50_tree = 
            (Object)adaptor.create(PUTIFABSENT50)
            ;
            adaptor.addChild(root_0, PUTIFABSENT50_tree);


            pushFollow(FOLLOW_keyIdentifier_in_putIfAbsentStatement769);
            key=keyIdentifier();

            state._fsp--;

            adaptor.addChild(root_0, key.getTree());

            pushFollow(FOLLOW_literal_in_putIfAbsentStatement775);
            value=literal();

            state._fsp--;

            adaptor.addChild(root_0, value.getTree());

            // org/infinispan/cli/interpreter/IspnQL.g:184:54: (exp= expirationClause )?
            int alt12=2;
            switch ( input.LA(1) ) {
                case EXPIRES:
                    {
                    alt12=1;
                    }
                    break;
            }

            switch (alt12) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:184:55: exp= expirationClause
                    {
                    pushFollow(FOLLOW_expirationClause_in_putIfAbsentStatement782);
                    exp=expirationClause();

                    state._fsp--;

                    adaptor.addChild(root_0, exp.getTree());

                    }
                    break;

            }


            set51=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==69 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new PutIfAbsentStatement((key!=null?key.key:null), (value!=null?value.o:null), (exp!=null?exp.exp:null)); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "putIfAbsentStatement"


    public static class putStatement_return extends ParserRuleReturnScope {
        public PutStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "putStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:187:1: putStatement returns [PutStatement stmt] : PUT key= keyIdentifier value= literal (exp= expirationClause )? ( EOL | ';' ) !;
    public final IspnQLParser.putStatement_return putStatement() throws RecognitionException {
        IspnQLParser.putStatement_return retval = new IspnQLParser.putStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token PUT52=null;
        Token set53=null;
        IspnQLParser.keyIdentifier_return key =null;

        IspnQLParser.literal_return value =null;

        IspnQLParser.expirationClause_return exp =null;


        Object PUT52_tree=null;
        Object set53_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:188:4: ( PUT key= keyIdentifier value= literal (exp= expirationClause )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:188:6: PUT key= keyIdentifier value= literal (exp= expirationClause )? ( EOL | ';' ) !
            {
            PUT52=(Token)match(input,PUT,FOLLOW_PUT_in_putStatement814); 
            PUT52_tree = 
            (Object)adaptor.create(PUT52)
            ;
            adaptor.addChild(root_0, PUT52_tree);


            pushFollow(FOLLOW_keyIdentifier_in_putStatement820);
            key=keyIdentifier();

            state._fsp--;

            adaptor.addChild(root_0, key.getTree());

            pushFollow(FOLLOW_literal_in_putStatement826);
            value=literal();

            state._fsp--;

            adaptor.addChild(root_0, value.getTree());

            // org/infinispan/cli/interpreter/IspnQL.g:188:46: (exp= expirationClause )?
            int alt13=2;
            switch ( input.LA(1) ) {
                case EXPIRES:
                    {
                    alt13=1;
                    }
                    break;
            }

            switch (alt13) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:188:47: exp= expirationClause
                    {
                    pushFollow(FOLLOW_expirationClause_in_putStatement833);
                    exp=expirationClause();

                    state._fsp--;

                    adaptor.addChild(root_0, exp.getTree());

                    }
                    break;

            }


            set53=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==69 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new PutStatement((key!=null?key.key:null), (value!=null?value.o:null), (exp!=null?exp.exp:null)); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "putStatement"


    public static class removeStatement_return extends ParserRuleReturnScope {
        public RemoveStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "removeStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:191:1: removeStatement returns [RemoveStatement stmt] : REMOVE key= keyIdentifier (value= literal )? ( EOL | ';' ) !;
    public final IspnQLParser.removeStatement_return removeStatement() throws RecognitionException {
        IspnQLParser.removeStatement_return retval = new IspnQLParser.removeStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token REMOVE54=null;
        Token set55=null;
        IspnQLParser.keyIdentifier_return key =null;

        IspnQLParser.literal_return value =null;


        Object REMOVE54_tree=null;
        Object set55_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:192:4: ( REMOVE key= keyIdentifier (value= literal )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:192:6: REMOVE key= keyIdentifier (value= literal )? ( EOL | ';' ) !
            {
            REMOVE54=(Token)match(input,REMOVE,FOLLOW_REMOVE_in_removeStatement865); 
            REMOVE54_tree = 
            (Object)adaptor.create(REMOVE54)
            ;
            adaptor.addChild(root_0, REMOVE54_tree);


            pushFollow(FOLLOW_keyIdentifier_in_removeStatement871);
            key=keyIdentifier();

            state._fsp--;

            adaptor.addChild(root_0, key.getTree());

            // org/infinispan/cli/interpreter/IspnQL.g:192:33: (value= literal )?
            int alt14=2;
            switch ( input.LA(1) ) {
                case DOUBLELITERAL:
                case FALSE:
                case FLOATLITERAL:
                case INTLITERAL:
                case LONGLITERAL:
                case NULL:
                case STRINGLITERAL:
                case TRUE:
                case UUIDLITERAL:
                case 73:
                    {
                    alt14=1;
                    }
                    break;
            }

            switch (alt14) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:192:34: value= literal
                    {
                    pushFollow(FOLLOW_literal_in_removeStatement878);
                    value=literal();

                    state._fsp--;

                    adaptor.addChild(root_0, value.getTree());

                    }
                    break;

            }


            set55=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==69 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new RemoveStatement((key!=null?key.key:null), (value!=null?value.o:null)); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "removeStatement"


    public static class replaceStatement_return extends ParserRuleReturnScope {
        public ReplaceStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "replaceStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:195:1: replaceStatement returns [ReplaceStatement stmt] : REPLACE key= keyIdentifier value1= literal (value2= literal )? (exp= expirationClause )? ( EOL | ';' ) !;
    public final IspnQLParser.replaceStatement_return replaceStatement() throws RecognitionException {
        IspnQLParser.replaceStatement_return retval = new IspnQLParser.replaceStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token REPLACE56=null;
        Token set57=null;
        IspnQLParser.keyIdentifier_return key =null;

        IspnQLParser.literal_return value1 =null;

        IspnQLParser.literal_return value2 =null;

        IspnQLParser.expirationClause_return exp =null;


        Object REPLACE56_tree=null;
        Object set57_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:196:4: ( REPLACE key= keyIdentifier value1= literal (value2= literal )? (exp= expirationClause )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:196:6: REPLACE key= keyIdentifier value1= literal (value2= literal )? (exp= expirationClause )? ( EOL | ';' ) !
            {
            REPLACE56=(Token)match(input,REPLACE,FOLLOW_REPLACE_in_replaceStatement910); 
            REPLACE56_tree = 
            (Object)adaptor.create(REPLACE56)
            ;
            adaptor.addChild(root_0, REPLACE56_tree);


            pushFollow(FOLLOW_keyIdentifier_in_replaceStatement916);
            key=keyIdentifier();

            state._fsp--;

            adaptor.addChild(root_0, key.getTree());

            pushFollow(FOLLOW_literal_in_replaceStatement922);
            value1=literal();

            state._fsp--;

            adaptor.addChild(root_0, value1.getTree());

            // org/infinispan/cli/interpreter/IspnQL.g:196:51: (value2= literal )?
            int alt15=2;
            switch ( input.LA(1) ) {
                case DOUBLELITERAL:
                case FALSE:
                case FLOATLITERAL:
                case INTLITERAL:
                case LONGLITERAL:
                case NULL:
                case STRINGLITERAL:
                case TRUE:
                case UUIDLITERAL:
                case 73:
                    {
                    alt15=1;
                    }
                    break;
            }

            switch (alt15) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:196:52: value2= literal
                    {
                    pushFollow(FOLLOW_literal_in_replaceStatement929);
                    value2=literal();

                    state._fsp--;

                    adaptor.addChild(root_0, value2.getTree());

                    }
                    break;

            }


            // org/infinispan/cli/interpreter/IspnQL.g:196:71: (exp= expirationClause )?
            int alt16=2;
            switch ( input.LA(1) ) {
                case EXPIRES:
                    {
                    alt16=1;
                    }
                    break;
            }

            switch (alt16) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:196:72: exp= expirationClause
                    {
                    pushFollow(FOLLOW_expirationClause_in_replaceStatement938);
                    exp=expirationClause();

                    state._fsp--;

                    adaptor.addChild(root_0, exp.getTree());

                    }
                    break;

            }


            set57=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==69 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             if ((value2!=null?value2.o:null)==null) retval.stmt = new ReplaceStatement((key!=null?key.key:null), (value1!=null?value1.o:null), (exp!=null?exp.exp:null)); else retval.stmt = new ReplaceStatement((key!=null?key.key:null), (value1!=null?value1.o:null), (value2!=null?value2.o:null), (exp!=null?exp.exp:null));

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "replaceStatement"


    public static class rollbackTransactionStatement_return extends ParserRuleReturnScope {
        public RollbackTransactionStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "rollbackTransactionStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:199:1: rollbackTransactionStatement returns [RollbackTransactionStatement stmt] : ROLLBACK (cacheName= STRINGLITERAL )? ( EOL | ';' ) !;
    public final IspnQLParser.rollbackTransactionStatement_return rollbackTransactionStatement() throws RecognitionException {
        IspnQLParser.rollbackTransactionStatement_return retval = new IspnQLParser.rollbackTransactionStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token cacheName=null;
        Token ROLLBACK58=null;
        Token set59=null;

        Object cacheName_tree=null;
        Object ROLLBACK58_tree=null;
        Object set59_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:200:4: ( ROLLBACK (cacheName= STRINGLITERAL )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:200:6: ROLLBACK (cacheName= STRINGLITERAL )? ( EOL | ';' ) !
            {
            ROLLBACK58=(Token)match(input,ROLLBACK,FOLLOW_ROLLBACK_in_rollbackTransactionStatement970); 
            ROLLBACK58_tree = 
            (Object)adaptor.create(ROLLBACK58)
            ;
            adaptor.addChild(root_0, ROLLBACK58_tree);


            // org/infinispan/cli/interpreter/IspnQL.g:200:15: (cacheName= STRINGLITERAL )?
            int alt17=2;
            switch ( input.LA(1) ) {
                case STRINGLITERAL:
                    {
                    alt17=1;
                    }
                    break;
            }

            switch (alt17) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:200:16: cacheName= STRINGLITERAL
                    {
                    cacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_rollbackTransactionStatement977); 
                    cacheName_tree = 
                    (Object)adaptor.create(cacheName)
                    ;
                    adaptor.addChild(root_0, cacheName_tree);


                    }
                    break;

            }


            set59=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==69 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new RollbackTransactionStatement(unquote((cacheName!=null?cacheName.getText():null))); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "rollbackTransactionStatement"


    public static class startBatchStatement_return extends ParserRuleReturnScope {
        public StartBatchStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "startBatchStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:203:1: startBatchStatement returns [StartBatchStatement stmt] : START (cacheName= STRINGLITERAL )? ( EOL | ';' ) !;
    public final IspnQLParser.startBatchStatement_return startBatchStatement() throws RecognitionException {
        IspnQLParser.startBatchStatement_return retval = new IspnQLParser.startBatchStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token cacheName=null;
        Token START60=null;
        Token set61=null;

        Object cacheName_tree=null;
        Object START60_tree=null;
        Object set61_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:204:4: ( START (cacheName= STRINGLITERAL )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:204:6: START (cacheName= STRINGLITERAL )? ( EOL | ';' ) !
            {
            START60=(Token)match(input,START,FOLLOW_START_in_startBatchStatement1009); 
            START60_tree = 
            (Object)adaptor.create(START60)
            ;
            adaptor.addChild(root_0, START60_tree);


            // org/infinispan/cli/interpreter/IspnQL.g:204:12: (cacheName= STRINGLITERAL )?
            int alt18=2;
            switch ( input.LA(1) ) {
                case STRINGLITERAL:
                    {
                    alt18=1;
                    }
                    break;
            }

            switch (alt18) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:204:13: cacheName= STRINGLITERAL
                    {
                    cacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_startBatchStatement1016); 
                    cacheName_tree = 
                    (Object)adaptor.create(cacheName)
                    ;
                    adaptor.addChild(root_0, cacheName_tree);


                    }
                    break;

            }


            set61=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==69 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new StartBatchStatement(unquote((cacheName!=null?cacheName.getText():null))); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "startBatchStatement"


    public static class statsStatement_return extends ParserRuleReturnScope {
        public StatsStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "statsStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:207:1: statsStatement returns [StatsStatement stmt] : STATS opts= statementOptions (cacheName= STRINGLITERAL )? ( EOL | ';' ) !;
    public final IspnQLParser.statsStatement_return statsStatement() throws RecognitionException {
        IspnQLParser.statsStatement_return retval = new IspnQLParser.statsStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token cacheName=null;
        Token STATS62=null;
        Token set63=null;
        IspnQLParser.statementOptions_return opts =null;


        Object cacheName_tree=null;
        Object STATS62_tree=null;
        Object set63_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:208:4: ( STATS opts= statementOptions (cacheName= STRINGLITERAL )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:208:6: STATS opts= statementOptions (cacheName= STRINGLITERAL )? ( EOL | ';' ) !
            {
            STATS62=(Token)match(input,STATS,FOLLOW_STATS_in_statsStatement1048); 
            STATS62_tree = 
            (Object)adaptor.create(STATS62)
            ;
            adaptor.addChild(root_0, STATS62_tree);


            pushFollow(FOLLOW_statementOptions_in_statsStatement1054);
            opts=statementOptions();

            state._fsp--;

            adaptor.addChild(root_0, opts.getTree());

            // org/infinispan/cli/interpreter/IspnQL.g:208:36: (cacheName= STRINGLITERAL )?
            int alt19=2;
            switch ( input.LA(1) ) {
                case STRINGLITERAL:
                    {
                    alt19=1;
                    }
                    break;
            }

            switch (alt19) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:208:37: cacheName= STRINGLITERAL
                    {
                    cacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_statsStatement1061); 
                    cacheName_tree = 
                    (Object)adaptor.create(cacheName)
                    ;
                    adaptor.addChild(root_0, cacheName_tree);


                    }
                    break;

            }


            set63=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==69 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new StatsStatement((opts!=null?opts.options:null), unquote((cacheName!=null?cacheName.getText():null))); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "statsStatement"


    public static class upgradeStatement_return extends ParserRuleReturnScope {
        public UpgradeStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "upgradeStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:211:1: upgradeStatement returns [UpgradeStatement stmt] : UPGRADE opts= statementOptions (cacheName= STRINGLITERAL )? ( EOL | ';' ) !;
    public final IspnQLParser.upgradeStatement_return upgradeStatement() throws RecognitionException {
        IspnQLParser.upgradeStatement_return retval = new IspnQLParser.upgradeStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token cacheName=null;
        Token UPGRADE64=null;
        Token set65=null;
        IspnQLParser.statementOptions_return opts =null;


        Object cacheName_tree=null;
        Object UPGRADE64_tree=null;
        Object set65_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:212:4: ( UPGRADE opts= statementOptions (cacheName= STRINGLITERAL )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:212:6: UPGRADE opts= statementOptions (cacheName= STRINGLITERAL )? ( EOL | ';' ) !
            {
            UPGRADE64=(Token)match(input,UPGRADE,FOLLOW_UPGRADE_in_upgradeStatement1093); 
            UPGRADE64_tree = 
            (Object)adaptor.create(UPGRADE64)
            ;
            adaptor.addChild(root_0, UPGRADE64_tree);


            pushFollow(FOLLOW_statementOptions_in_upgradeStatement1099);
            opts=statementOptions();

            state._fsp--;

            adaptor.addChild(root_0, opts.getTree());

            // org/infinispan/cli/interpreter/IspnQL.g:212:38: (cacheName= STRINGLITERAL )?
            int alt20=2;
            switch ( input.LA(1) ) {
                case STRINGLITERAL:
                    {
                    alt20=1;
                    }
                    break;
            }

            switch (alt20) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:212:39: cacheName= STRINGLITERAL
                    {
                    cacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_upgradeStatement1106); 
                    cacheName_tree = 
                    (Object)adaptor.create(cacheName)
                    ;
                    adaptor.addChild(root_0, cacheName_tree);


                    }
                    break;

            }


            set65=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==69 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new UpgradeStatement((opts!=null?opts.options:null), unquote((cacheName!=null?cacheName.getText():null))); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "upgradeStatement"


    public static class versionStatement_return extends ParserRuleReturnScope {
        public VersionStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "versionStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:215:1: versionStatement returns [VersionStatement stmt] : VERSION ( EOL | ';' ) !;
    public final IspnQLParser.versionStatement_return versionStatement() throws RecognitionException {
        IspnQLParser.versionStatement_return retval = new IspnQLParser.versionStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token VERSION66=null;
        Token set67=null;

        Object VERSION66_tree=null;
        Object set67_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:216:4: ( VERSION ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:216:6: VERSION ( EOL | ';' ) !
            {
            VERSION66=(Token)match(input,VERSION,FOLLOW_VERSION_in_versionStatement1138); 
            VERSION66_tree = 
            (Object)adaptor.create(VERSION66)
            ;
            adaptor.addChild(root_0, VERSION66_tree);


            set67=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==69 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new VersionStatement(); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "versionStatement"


    public static class expirationClause_return extends ParserRuleReturnScope {
        public ExpirationData exp;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "expirationClause"
    // org/infinispan/cli/interpreter/IspnQL.g:219:1: expirationClause returns [ExpirationData exp] : EXPIRES expires= timeLiteral ( MAXIDLE idle= timeLiteral )? ;
    public final IspnQLParser.expirationClause_return expirationClause() throws RecognitionException {
        IspnQLParser.expirationClause_return retval = new IspnQLParser.expirationClause_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token EXPIRES68=null;
        Token MAXIDLE69=null;
        IspnQLParser.timeLiteral_return expires =null;

        IspnQLParser.timeLiteral_return idle =null;


        Object EXPIRES68_tree=null;
        Object MAXIDLE69_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:220:4: ( EXPIRES expires= timeLiteral ( MAXIDLE idle= timeLiteral )? )
            // org/infinispan/cli/interpreter/IspnQL.g:220:6: EXPIRES expires= timeLiteral ( MAXIDLE idle= timeLiteral )?
            {
            EXPIRES68=(Token)match(input,EXPIRES,FOLLOW_EXPIRES_in_expirationClause1168); 
            EXPIRES68_tree = 
            (Object)adaptor.create(EXPIRES68)
            ;
            adaptor.addChild(root_0, EXPIRES68_tree);


            pushFollow(FOLLOW_timeLiteral_in_expirationClause1174);
            expires=timeLiteral();

            state._fsp--;

            adaptor.addChild(root_0, expires.getTree());

            // org/infinispan/cli/interpreter/IspnQL.g:220:36: ( MAXIDLE idle= timeLiteral )?
            int alt21=2;
            switch ( input.LA(1) ) {
                case MAXIDLE:
                    {
                    alt21=1;
                    }
                    break;
            }

            switch (alt21) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:220:37: MAXIDLE idle= timeLiteral
                    {
                    MAXIDLE69=(Token)match(input,MAXIDLE,FOLLOW_MAXIDLE_in_expirationClause1177); 
                    MAXIDLE69_tree = 
                    (Object)adaptor.create(MAXIDLE69)
                    ;
                    adaptor.addChild(root_0, MAXIDLE69_tree);


                    pushFollow(FOLLOW_timeLiteral_in_expirationClause1183);
                    idle=timeLiteral();

                    state._fsp--;

                    adaptor.addChild(root_0, idle.getTree());

                    }
                    break;

            }


             retval.exp = new ExpirationData((expires!=null?expires.l:null), (idle!=null?idle.l:null)); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "expirationClause"


    public static class keyIdentifier_return extends ParserRuleReturnScope {
        public KeyData key;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "keyIdentifier"
    // org/infinispan/cli/interpreter/IspnQL.g:223:1: keyIdentifier returns [KeyData key] : ( STRINGLITERAL '.' literal | literal );
    public final IspnQLParser.keyIdentifier_return keyIdentifier() throws RecognitionException {
        IspnQLParser.keyIdentifier_return retval = new IspnQLParser.keyIdentifier_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token STRINGLITERAL70=null;
        Token char_literal71=null;
        IspnQLParser.literal_return literal72 =null;

        IspnQLParser.literal_return literal73 =null;


        Object STRINGLITERAL70_tree=null;
        Object char_literal71_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:224:4: ( STRINGLITERAL '.' literal | literal )
            int alt22=2;
            switch ( input.LA(1) ) {
            case STRINGLITERAL:
                {
                switch ( input.LA(2) ) {
                case 67:
                    {
                    alt22=1;
                    }
                    break;
                case DOUBLELITERAL:
                case EOL:
                case FALSE:
                case FLOATLITERAL:
                case INTLITERAL:
                case LONGLITERAL:
                case NULL:
                case STRINGLITERAL:
                case TRUE:
                case UUIDLITERAL:
                case 69:
                case 73:
                    {
                    alt22=2;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 22, 1, input);

                    throw nvae;

                }

                }
                break;
            case DOUBLELITERAL:
            case FALSE:
            case FLOATLITERAL:
            case INTLITERAL:
            case LONGLITERAL:
            case NULL:
            case TRUE:
            case UUIDLITERAL:
            case 73:
                {
                alt22=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 22, 0, input);

                throw nvae;

            }

            switch (alt22) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:224:6: STRINGLITERAL '.' literal
                    {
                    STRINGLITERAL70=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_keyIdentifier1206); 
                    STRINGLITERAL70_tree = 
                    (Object)adaptor.create(STRINGLITERAL70)
                    ;
                    adaptor.addChild(root_0, STRINGLITERAL70_tree);


                    char_literal71=(Token)match(input,67,FOLLOW_67_in_keyIdentifier1208); 
                    char_literal71_tree = 
                    (Object)adaptor.create(char_literal71)
                    ;
                    adaptor.addChild(root_0, char_literal71_tree);


                    pushFollow(FOLLOW_literal_in_keyIdentifier1210);
                    literal72=literal();

                    state._fsp--;

                    adaptor.addChild(root_0, literal72.getTree());

                     retval.key = new KeyData(unquote((STRINGLITERAL70!=null?STRINGLITERAL70.getText():null)), (literal72!=null?literal72.o:null)); 

                    }
                    break;
                case 2 :
                    // org/infinispan/cli/interpreter/IspnQL.g:225:6: literal
                    {
                    pushFollow(FOLLOW_literal_in_keyIdentifier1219);
                    literal73=literal();

                    state._fsp--;

                    adaptor.addChild(root_0, literal73.getTree());

                     retval.key = new KeyData((literal73!=null?literal73.o:null)); 

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "keyIdentifier"


    public static class statementOptions_return extends ParserRuleReturnScope {
        public List<Option> options;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "statementOptions"
    // org/infinispan/cli/interpreter/IspnQL.g:228:1: statementOptions returns [List<Option> options] : ( statementOption )* ;
    public final IspnQLParser.statementOptions_return statementOptions() throws RecognitionException {
        IspnQLParser.statementOptions_return retval = new IspnQLParser.statementOptions_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        IspnQLParser.statementOption_return statementOption74 =null;




           retval.options = new ArrayList<Option>();

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:232:4: ( ( statementOption )* )
            // org/infinispan/cli/interpreter/IspnQL.g:232:6: ( statementOption )*
            {
            // org/infinispan/cli/interpreter/IspnQL.g:232:6: ( statementOption )*
            loop23:
            do {
                int alt23=2;
                switch ( input.LA(1) ) {
                case 66:
                    {
                    alt23=1;
                    }
                    break;

                }

                switch (alt23) {
            	case 1 :
            	    // org/infinispan/cli/interpreter/IspnQL.g:232:8: statementOption
            	    {
            	    pushFollow(FOLLOW_statementOption_in_statementOptions1247);
            	    statementOption74=statementOption();

            	    state._fsp--;

            	    adaptor.addChild(root_0, statementOption74.getTree());

            	     retval.options.add((statementOption74!=null?statementOption74.option:null)); 

            	    }
            	    break;

            	default :
            	    break loop23;
                }
            } while (true);


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "statementOptions"


    public static class statementOption_return extends ParserRuleReturnScope {
        public Option option;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "statementOption"
    // org/infinispan/cli/interpreter/IspnQL.g:235:1: statementOption returns [Option option] : '--' optionName= STRINGLITERAL ( '=' optionParameter= STRINGLITERAL )? ;
    public final IspnQLParser.statementOption_return statementOption() throws RecognitionException {
        IspnQLParser.statementOption_return retval = new IspnQLParser.statementOption_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token optionName=null;
        Token optionParameter=null;
        Token string_literal75=null;
        Token char_literal76=null;

        Object optionName_tree=null;
        Object optionParameter_tree=null;
        Object string_literal75_tree=null;
        Object char_literal76_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:236:4: ( '--' optionName= STRINGLITERAL ( '=' optionParameter= STRINGLITERAL )? )
            // org/infinispan/cli/interpreter/IspnQL.g:236:6: '--' optionName= STRINGLITERAL ( '=' optionParameter= STRINGLITERAL )?
            {
            string_literal75=(Token)match(input,66,FOLLOW_66_in_statementOption1271); 
            string_literal75_tree = 
            (Object)adaptor.create(string_literal75)
            ;
            adaptor.addChild(root_0, string_literal75_tree);


            optionName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_statementOption1277); 
            optionName_tree = 
            (Object)adaptor.create(optionName)
            ;
            adaptor.addChild(root_0, optionName_tree);


            // org/infinispan/cli/interpreter/IspnQL.g:236:38: ( '=' optionParameter= STRINGLITERAL )?
            int alt24=2;
            switch ( input.LA(1) ) {
                case 70:
                    {
                    alt24=1;
                    }
                    break;
            }

            switch (alt24) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:236:39: '=' optionParameter= STRINGLITERAL
                    {
                    char_literal76=(Token)match(input,70,FOLLOW_70_in_statementOption1280); 
                    char_literal76_tree = 
                    (Object)adaptor.create(char_literal76)
                    ;
                    adaptor.addChild(root_0, char_literal76_tree);


                    optionParameter=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_statementOption1286); 
                    optionParameter_tree = 
                    (Object)adaptor.create(optionParameter)
                    ;
                    adaptor.addChild(root_0, optionParameter_tree);


                    }
                    break;

            }


             retval.option = new Option(unquote((optionName!=null?optionName.getText():null)), unquote((optionParameter!=null?optionParameter.getText():null))); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "statementOption"


    public static class literal_return extends ParserRuleReturnScope {
        public Object o;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "literal"
    // org/infinispan/cli/interpreter/IspnQL.g:239:1: literal returns [Object o] : ( INTLITERAL | LONGLITERAL | FLOATLITERAL | DOUBLELITERAL | NULL | STRINGLITERAL | UUIDLITERAL |b= ( TRUE | FALSE ) | jsonLiteral );
    public final IspnQLParser.literal_return literal() throws RecognitionException {
        IspnQLParser.literal_return retval = new IspnQLParser.literal_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token b=null;
        Token INTLITERAL77=null;
        Token LONGLITERAL78=null;
        Token FLOATLITERAL79=null;
        Token DOUBLELITERAL80=null;
        Token NULL81=null;
        Token STRINGLITERAL82=null;
        Token UUIDLITERAL83=null;
        IspnQLParser.jsonLiteral_return jsonLiteral84 =null;


        Object b_tree=null;
        Object INTLITERAL77_tree=null;
        Object LONGLITERAL78_tree=null;
        Object FLOATLITERAL79_tree=null;
        Object DOUBLELITERAL80_tree=null;
        Object NULL81_tree=null;
        Object STRINGLITERAL82_tree=null;
        Object UUIDLITERAL83_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:240:4: ( INTLITERAL | LONGLITERAL | FLOATLITERAL | DOUBLELITERAL | NULL | STRINGLITERAL | UUIDLITERAL |b= ( TRUE | FALSE ) | jsonLiteral )
            int alt25=9;
            switch ( input.LA(1) ) {
            case INTLITERAL:
                {
                alt25=1;
                }
                break;
            case LONGLITERAL:
                {
                alt25=2;
                }
                break;
            case FLOATLITERAL:
                {
                alt25=3;
                }
                break;
            case DOUBLELITERAL:
                {
                alt25=4;
                }
                break;
            case NULL:
                {
                alt25=5;
                }
                break;
            case STRINGLITERAL:
                {
                alt25=6;
                }
                break;
            case UUIDLITERAL:
                {
                alt25=7;
                }
                break;
            case FALSE:
            case TRUE:
                {
                alt25=8;
                }
                break;
            case 73:
                {
                alt25=9;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 25, 0, input);

                throw nvae;

            }

            switch (alt25) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:240:6: INTLITERAL
                    {
                    INTLITERAL77=(Token)match(input,INTLITERAL,FOLLOW_INTLITERAL_in_literal1309); 
                    INTLITERAL77_tree = 
                    (Object)adaptor.create(INTLITERAL77)
                    ;
                    adaptor.addChild(root_0, INTLITERAL77_tree);


                     retval.o = Integer.valueOf((INTLITERAL77!=null?INTLITERAL77.getText():null)); 

                    }
                    break;
                case 2 :
                    // org/infinispan/cli/interpreter/IspnQL.g:241:6: LONGLITERAL
                    {
                    LONGLITERAL78=(Token)match(input,LONGLITERAL,FOLLOW_LONGLITERAL_in_literal1318); 
                    LONGLITERAL78_tree = 
                    (Object)adaptor.create(LONGLITERAL78)
                    ;
                    adaptor.addChild(root_0, LONGLITERAL78_tree);


                     retval.o = Long.valueOf((LONGLITERAL78!=null?LONGLITERAL78.getText():null)); 

                    }
                    break;
                case 3 :
                    // org/infinispan/cli/interpreter/IspnQL.g:242:6: FLOATLITERAL
                    {
                    FLOATLITERAL79=(Token)match(input,FLOATLITERAL,FOLLOW_FLOATLITERAL_in_literal1327); 
                    FLOATLITERAL79_tree = 
                    (Object)adaptor.create(FLOATLITERAL79)
                    ;
                    adaptor.addChild(root_0, FLOATLITERAL79_tree);


                     retval.o = Float.valueOf((FLOATLITERAL79!=null?FLOATLITERAL79.getText():null)); 

                    }
                    break;
                case 4 :
                    // org/infinispan/cli/interpreter/IspnQL.g:243:6: DOUBLELITERAL
                    {
                    DOUBLELITERAL80=(Token)match(input,DOUBLELITERAL,FOLLOW_DOUBLELITERAL_in_literal1336); 
                    DOUBLELITERAL80_tree = 
                    (Object)adaptor.create(DOUBLELITERAL80)
                    ;
                    adaptor.addChild(root_0, DOUBLELITERAL80_tree);


                     retval.o = Double.valueOf((DOUBLELITERAL80!=null?DOUBLELITERAL80.getText():null)); 

                    }
                    break;
                case 5 :
                    // org/infinispan/cli/interpreter/IspnQL.g:244:6: NULL
                    {
                    NULL81=(Token)match(input,NULL,FOLLOW_NULL_in_literal1345); 
                    NULL81_tree = 
                    (Object)adaptor.create(NULL81)
                    ;
                    adaptor.addChild(root_0, NULL81_tree);


                     retval.o = null; 

                    }
                    break;
                case 6 :
                    // org/infinispan/cli/interpreter/IspnQL.g:245:6: STRINGLITERAL
                    {
                    STRINGLITERAL82=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_literal1354); 
                    STRINGLITERAL82_tree = 
                    (Object)adaptor.create(STRINGLITERAL82)
                    ;
                    adaptor.addChild(root_0, STRINGLITERAL82_tree);


                     retval.o = unquote((STRINGLITERAL82!=null?STRINGLITERAL82.getText():null)); 

                    }
                    break;
                case 7 :
                    // org/infinispan/cli/interpreter/IspnQL.g:246:6: UUIDLITERAL
                    {
                    UUIDLITERAL83=(Token)match(input,UUIDLITERAL,FOLLOW_UUIDLITERAL_in_literal1363); 
                    UUIDLITERAL83_tree = 
                    (Object)adaptor.create(UUIDLITERAL83)
                    ;
                    adaptor.addChild(root_0, UUIDLITERAL83_tree);


                     retval.o = UUID.fromString((UUIDLITERAL83!=null?UUIDLITERAL83.getText():null)); 

                    }
                    break;
                case 8 :
                    // org/infinispan/cli/interpreter/IspnQL.g:247:6: b= ( TRUE | FALSE )
                    {
                    b=(Token)input.LT(1);

                    if ( input.LA(1)==FALSE||input.LA(1)==TRUE ) {
                        input.consume();
                        adaptor.addChild(root_0, 
                        (Object)adaptor.create(b)
                        );
                        state.errorRecovery=false;
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        throw mse;
                    }


                     retval.o = Boolean.valueOf((b!=null?b.getText():null)); 

                    }
                    break;
                case 9 :
                    // org/infinispan/cli/interpreter/IspnQL.g:248:6: jsonLiteral
                    {
                    pushFollow(FOLLOW_jsonLiteral_in_literal1393);
                    jsonLiteral84=jsonLiteral();

                    state._fsp--;

                    adaptor.addChild(root_0, jsonLiteral84.getTree());


                           retval.o = jsonMapper.readValue((jsonLiteral84!=null?input.toString(jsonLiteral84.start,jsonLiteral84.stop):null), Object.class);
                       

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (JsonProcessingException jpe) {
             throw new RecognitionException(input); 
        }
        catch (IOException ioe) {
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "literal"


    public static class timeLiteral_return extends ParserRuleReturnScope {
        public Long l;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "timeLiteral"
    // org/infinispan/cli/interpreter/IspnQL.g:255:1: timeLiteral returns [Long l] : TIMELITERAL ;
    public final IspnQLParser.timeLiteral_return timeLiteral() throws RecognitionException {
        IspnQLParser.timeLiteral_return retval = new IspnQLParser.timeLiteral_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token TIMELITERAL85=null;

        Object TIMELITERAL85_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:256:4: ( TIMELITERAL )
            // org/infinispan/cli/interpreter/IspnQL.g:256:6: TIMELITERAL
            {
            TIMELITERAL85=(Token)match(input,TIMELITERAL,FOLLOW_TIMELITERAL_in_timeLiteral1430); 
            TIMELITERAL85_tree = 
            (Object)adaptor.create(TIMELITERAL85)
            ;
            adaptor.addChild(root_0, TIMELITERAL85_tree);


             retval.l = millis((TIMELITERAL85!=null?TIMELITERAL85.getText():null)); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "timeLiteral"


    public static class jsonLiteral_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "jsonLiteral"
    // org/infinispan/cli/interpreter/IspnQL.g:259:1: jsonLiteral : '{' jsonPair ( ',' jsonPair )* '}' ;
    public final IspnQLParser.jsonLiteral_return jsonLiteral() throws RecognitionException {
        IspnQLParser.jsonLiteral_return retval = new IspnQLParser.jsonLiteral_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token char_literal86=null;
        Token char_literal88=null;
        Token char_literal90=null;
        IspnQLParser.jsonPair_return jsonPair87 =null;

        IspnQLParser.jsonPair_return jsonPair89 =null;


        Object char_literal86_tree=null;
        Object char_literal88_tree=null;
        Object char_literal90_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:260:4: ( '{' jsonPair ( ',' jsonPair )* '}' )
            // org/infinispan/cli/interpreter/IspnQL.g:260:6: '{' jsonPair ( ',' jsonPair )* '}'
            {
            char_literal86=(Token)match(input,73,FOLLOW_73_in_jsonLiteral1447); 
            char_literal86_tree = 
            (Object)adaptor.create(char_literal86)
            ;
            adaptor.addChild(root_0, char_literal86_tree);


            pushFollow(FOLLOW_jsonPair_in_jsonLiteral1449);
            jsonPair87=jsonPair();

            state._fsp--;

            adaptor.addChild(root_0, jsonPair87.getTree());

            // org/infinispan/cli/interpreter/IspnQL.g:260:19: ( ',' jsonPair )*
            loop26:
            do {
                int alt26=2;
                switch ( input.LA(1) ) {
                case 65:
                    {
                    alt26=1;
                    }
                    break;

                }

                switch (alt26) {
            	case 1 :
            	    // org/infinispan/cli/interpreter/IspnQL.g:260:20: ',' jsonPair
            	    {
            	    char_literal88=(Token)match(input,65,FOLLOW_65_in_jsonLiteral1452); 
            	    char_literal88_tree = 
            	    (Object)adaptor.create(char_literal88)
            	    ;
            	    adaptor.addChild(root_0, char_literal88_tree);


            	    pushFollow(FOLLOW_jsonPair_in_jsonLiteral1454);
            	    jsonPair89=jsonPair();

            	    state._fsp--;

            	    adaptor.addChild(root_0, jsonPair89.getTree());

            	    }
            	    break;

            	default :
            	    break loop26;
                }
            } while (true);


            char_literal90=(Token)match(input,74,FOLLOW_74_in_jsonLiteral1458); 
            char_literal90_tree = 
            (Object)adaptor.create(char_literal90)
            ;
            adaptor.addChild(root_0, char_literal90_tree);


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "jsonLiteral"


    public static class jsonPair_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "jsonPair"
    // org/infinispan/cli/interpreter/IspnQL.g:263:1: jsonPair : jsonString ':' jsonValue ;
    public final IspnQLParser.jsonPair_return jsonPair() throws RecognitionException {
        IspnQLParser.jsonPair_return retval = new IspnQLParser.jsonPair_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token char_literal92=null;
        IspnQLParser.jsonString_return jsonString91 =null;

        IspnQLParser.jsonValue_return jsonValue93 =null;


        Object char_literal92_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:264:4: ( jsonString ':' jsonValue )
            // org/infinispan/cli/interpreter/IspnQL.g:264:6: jsonString ':' jsonValue
            {
            pushFollow(FOLLOW_jsonString_in_jsonPair1473);
            jsonString91=jsonString();

            state._fsp--;

            adaptor.addChild(root_0, jsonString91.getTree());

            char_literal92=(Token)match(input,68,FOLLOW_68_in_jsonPair1475); 
            char_literal92_tree = 
            (Object)adaptor.create(char_literal92)
            ;
            adaptor.addChild(root_0, char_literal92_tree);


            pushFollow(FOLLOW_jsonValue_in_jsonPair1477);
            jsonValue93=jsonValue();

            state._fsp--;

            adaptor.addChild(root_0, jsonValue93.getTree());

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "jsonPair"


    public static class jsonString_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "jsonString"
    // org/infinispan/cli/interpreter/IspnQL.g:267:1: jsonString : STRINGLITERAL ;
    public final IspnQLParser.jsonString_return jsonString() throws RecognitionException {
        IspnQLParser.jsonString_return retval = new IspnQLParser.jsonString_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token STRINGLITERAL94=null;

        Object STRINGLITERAL94_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:268:4: ( STRINGLITERAL )
            // org/infinispan/cli/interpreter/IspnQL.g:268:6: STRINGLITERAL
            {
            STRINGLITERAL94=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_jsonString1492); 
            STRINGLITERAL94_tree = 
            (Object)adaptor.create(STRINGLITERAL94)
            ;
            adaptor.addChild(root_0, STRINGLITERAL94_tree);


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "jsonString"


    public static class jsonValue_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "jsonValue"
    // org/infinispan/cli/interpreter/IspnQL.g:271:1: jsonValue : ( jsonLiteral | jsonArray | INTLITERAL | DOUBLELITERAL | TRUE | FALSE | NULL | jsonString );
    public final IspnQLParser.jsonValue_return jsonValue() throws RecognitionException {
        IspnQLParser.jsonValue_return retval = new IspnQLParser.jsonValue_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token INTLITERAL97=null;
        Token DOUBLELITERAL98=null;
        Token TRUE99=null;
        Token FALSE100=null;
        Token NULL101=null;
        IspnQLParser.jsonLiteral_return jsonLiteral95 =null;

        IspnQLParser.jsonArray_return jsonArray96 =null;

        IspnQLParser.jsonString_return jsonString102 =null;


        Object INTLITERAL97_tree=null;
        Object DOUBLELITERAL98_tree=null;
        Object TRUE99_tree=null;
        Object FALSE100_tree=null;
        Object NULL101_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:272:4: ( jsonLiteral | jsonArray | INTLITERAL | DOUBLELITERAL | TRUE | FALSE | NULL | jsonString )
            int alt27=8;
            switch ( input.LA(1) ) {
            case 73:
                {
                alt27=1;
                }
                break;
            case 71:
                {
                alt27=2;
                }
                break;
            case INTLITERAL:
                {
                alt27=3;
                }
                break;
            case DOUBLELITERAL:
                {
                alt27=4;
                }
                break;
            case TRUE:
                {
                alt27=5;
                }
                break;
            case FALSE:
                {
                alt27=6;
                }
                break;
            case NULL:
                {
                alt27=7;
                }
                break;
            case STRINGLITERAL:
                {
                alt27=8;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 27, 0, input);

                throw nvae;

            }

            switch (alt27) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:272:6: jsonLiteral
                    {
                    pushFollow(FOLLOW_jsonLiteral_in_jsonValue1507);
                    jsonLiteral95=jsonLiteral();

                    state._fsp--;

                    adaptor.addChild(root_0, jsonLiteral95.getTree());

                    }
                    break;
                case 2 :
                    // org/infinispan/cli/interpreter/IspnQL.g:273:6: jsonArray
                    {
                    pushFollow(FOLLOW_jsonArray_in_jsonValue1514);
                    jsonArray96=jsonArray();

                    state._fsp--;

                    adaptor.addChild(root_0, jsonArray96.getTree());

                    }
                    break;
                case 3 :
                    // org/infinispan/cli/interpreter/IspnQL.g:274:6: INTLITERAL
                    {
                    INTLITERAL97=(Token)match(input,INTLITERAL,FOLLOW_INTLITERAL_in_jsonValue1521); 
                    INTLITERAL97_tree = 
                    (Object)adaptor.create(INTLITERAL97)
                    ;
                    adaptor.addChild(root_0, INTLITERAL97_tree);


                    }
                    break;
                case 4 :
                    // org/infinispan/cli/interpreter/IspnQL.g:275:6: DOUBLELITERAL
                    {
                    DOUBLELITERAL98=(Token)match(input,DOUBLELITERAL,FOLLOW_DOUBLELITERAL_in_jsonValue1528); 
                    DOUBLELITERAL98_tree = 
                    (Object)adaptor.create(DOUBLELITERAL98)
                    ;
                    adaptor.addChild(root_0, DOUBLELITERAL98_tree);


                    }
                    break;
                case 5 :
                    // org/infinispan/cli/interpreter/IspnQL.g:276:6: TRUE
                    {
                    TRUE99=(Token)match(input,TRUE,FOLLOW_TRUE_in_jsonValue1535); 
                    TRUE99_tree = 
                    (Object)adaptor.create(TRUE99)
                    ;
                    adaptor.addChild(root_0, TRUE99_tree);


                    }
                    break;
                case 6 :
                    // org/infinispan/cli/interpreter/IspnQL.g:276:13: FALSE
                    {
                    FALSE100=(Token)match(input,FALSE,FOLLOW_FALSE_in_jsonValue1539); 
                    FALSE100_tree = 
                    (Object)adaptor.create(FALSE100)
                    ;
                    adaptor.addChild(root_0, FALSE100_tree);


                    }
                    break;
                case 7 :
                    // org/infinispan/cli/interpreter/IspnQL.g:277:6: NULL
                    {
                    NULL101=(Token)match(input,NULL,FOLLOW_NULL_in_jsonValue1546); 
                    NULL101_tree = 
                    (Object)adaptor.create(NULL101)
                    ;
                    adaptor.addChild(root_0, NULL101_tree);


                    }
                    break;
                case 8 :
                    // org/infinispan/cli/interpreter/IspnQL.g:278:6: jsonString
                    {
                    pushFollow(FOLLOW_jsonString_in_jsonValue1553);
                    jsonString102=jsonString();

                    state._fsp--;

                    adaptor.addChild(root_0, jsonString102.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "jsonValue"


    public static class jsonArray_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "jsonArray"
    // org/infinispan/cli/interpreter/IspnQL.g:281:1: jsonArray : '[' jsonValue ( ',' jsonValue )* ']' ;
    public final IspnQLParser.jsonArray_return jsonArray() throws RecognitionException {
        IspnQLParser.jsonArray_return retval = new IspnQLParser.jsonArray_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token char_literal103=null;
        Token char_literal105=null;
        Token char_literal107=null;
        IspnQLParser.jsonValue_return jsonValue104 =null;

        IspnQLParser.jsonValue_return jsonValue106 =null;


        Object char_literal103_tree=null;
        Object char_literal105_tree=null;
        Object char_literal107_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:282:4: ( '[' jsonValue ( ',' jsonValue )* ']' )
            // org/infinispan/cli/interpreter/IspnQL.g:282:6: '[' jsonValue ( ',' jsonValue )* ']'
            {
            char_literal103=(Token)match(input,71,FOLLOW_71_in_jsonArray1568); 
            char_literal103_tree = 
            (Object)adaptor.create(char_literal103)
            ;
            adaptor.addChild(root_0, char_literal103_tree);


            pushFollow(FOLLOW_jsonValue_in_jsonArray1570);
            jsonValue104=jsonValue();

            state._fsp--;

            adaptor.addChild(root_0, jsonValue104.getTree());

            // org/infinispan/cli/interpreter/IspnQL.g:282:20: ( ',' jsonValue )*
            loop28:
            do {
                int alt28=2;
                switch ( input.LA(1) ) {
                case 65:
                    {
                    alt28=1;
                    }
                    break;

                }

                switch (alt28) {
            	case 1 :
            	    // org/infinispan/cli/interpreter/IspnQL.g:282:21: ',' jsonValue
            	    {
            	    char_literal105=(Token)match(input,65,FOLLOW_65_in_jsonArray1573); 
            	    char_literal105_tree = 
            	    (Object)adaptor.create(char_literal105)
            	    ;
            	    adaptor.addChild(root_0, char_literal105_tree);


            	    pushFollow(FOLLOW_jsonValue_in_jsonArray1575);
            	    jsonValue106=jsonValue();

            	    state._fsp--;

            	    adaptor.addChild(root_0, jsonValue106.getTree());

            	    }
            	    break;

            	default :
            	    break loop28;
                }
            } while (true);


            char_literal107=(Token)match(input,72,FOLLOW_72_in_jsonArray1579); 
            char_literal107_tree = 
            (Object)adaptor.create(char_literal107)
            ;
            adaptor.addChild(root_0, char_literal107_tree);


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "jsonArray"

    // Delegated rules


 

    public static final BitSet FOLLOW_statement_in_statements72 = new BitSet(new long[]{0x840FF011101C0F90L});
    public static final BitSet FOLLOW_EOL_in_statements76 = new BitSet(new long[]{0x840FF011101C0F90L});
    public static final BitSet FOLLOW_EOF_in_statements81 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_abortBatchStatement_in_statement100 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_beginTransactionStatement_in_statement109 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_cacheStatement_in_statement118 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_clearStatement_in_statement127 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_commitTransactionStatement_in_statement136 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_createStatement_in_statement145 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_endBatchStatement_in_statement154 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_evictStatement_in_statement163 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_getStatement_in_statement172 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_infoStatement_in_statement181 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_locateStatement_in_statement190 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_pingStatement_in_statement199 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_putIfAbsentStatement_in_statement208 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_putStatement_in_statement217 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_removeStatement_in_statement226 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_replaceStatement_in_statement235 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rollbackTransactionStatement_in_statement244 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_startBatchStatement_in_statement253 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_statsStatement_in_statement262 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_upgradeStatement_in_statement271 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_versionStatement_in_statement280 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ABORT_in_abortBatchStatement302 = new BitSet(new long[]{0x0010000000080000L,0x0000000000000020L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_abortBatchStatement309 = new BitSet(new long[]{0x0000000000080000L,0x0000000000000020L});
    public static final BitSet FOLLOW_set_in_abortBatchStatement313 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_BEGIN_in_beginTransactionStatement341 = new BitSet(new long[]{0x0010000000080000L,0x0000000000000020L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_beginTransactionStatement348 = new BitSet(new long[]{0x0000000000080000L,0x0000000000000020L});
    public static final BitSet FOLLOW_set_in_beginTransactionStatement352 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_CACHE_in_cacheStatement380 = new BitSet(new long[]{0x0010000000080000L,0x0000000000000020L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_cacheStatement387 = new BitSet(new long[]{0x0000000000080000L,0x0000000000000020L});
    public static final BitSet FOLLOW_set_in_cacheStatement391 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_CLEAR_in_clearStatement419 = new BitSet(new long[]{0x0010000000080000L,0x0000000000000020L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_clearStatement426 = new BitSet(new long[]{0x0000000000080000L,0x0000000000000020L});
    public static final BitSet FOLLOW_set_in_clearStatement430 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_COMMIT_in_commitTransactionStatement458 = new BitSet(new long[]{0x0010000000080000L,0x0000000000000020L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_commitTransactionStatement465 = new BitSet(new long[]{0x0000000000080000L,0x0000000000000020L});
    public static final BitSet FOLLOW_set_in_commitTransactionStatement469 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_CREATE_in_createStatement497 = new BitSet(new long[]{0x0010000000000000L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_createStatement503 = new BitSet(new long[]{0x0000000800080000L,0x0000000000000020L});
    public static final BitSet FOLLOW_LIKE_in_createStatement506 = new BitSet(new long[]{0x0010000000000000L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_createStatement512 = new BitSet(new long[]{0x0000000000080000L,0x0000000000000020L});
    public static final BitSet FOLLOW_set_in_createStatement516 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_END_in_endBatchStatement547 = new BitSet(new long[]{0x0010000000080000L,0x0000000000000020L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_endBatchStatement554 = new BitSet(new long[]{0x0000000000080000L,0x0000000000000020L});
    public static final BitSet FOLLOW_set_in_endBatchStatement558 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_EVICT_in_evictStatement586 = new BitSet(new long[]{0x0910022206004000L,0x0000000000000200L});
    public static final BitSet FOLLOW_keyIdentifier_in_evictStatement592 = new BitSet(new long[]{0x0000000000080000L,0x0000000000000020L});
    public static final BitSet FOLLOW_set_in_evictStatement594 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_GET_in_getStatement622 = new BitSet(new long[]{0x0910022206004000L,0x0000000000000200L});
    public static final BitSet FOLLOW_keyIdentifier_in_getStatement628 = new BitSet(new long[]{0x0000000000080000L,0x0000000000000020L});
    public static final BitSet FOLLOW_set_in_getStatement630 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_INFO_in_infoStatement658 = new BitSet(new long[]{0x0010000000080000L,0x0000000000000020L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_infoStatement665 = new BitSet(new long[]{0x0000000000080000L,0x0000000000000020L});
    public static final BitSet FOLLOW_set_in_infoStatement669 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_LOCATE_in_locateStatement697 = new BitSet(new long[]{0x0910022206004000L,0x0000000000000200L});
    public static final BitSet FOLLOW_keyIdentifier_in_locateStatement703 = new BitSet(new long[]{0x0000000000080000L,0x0000000000000020L});
    public static final BitSet FOLLOW_set_in_locateStatement705 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_PING_in_pingStatement733 = new BitSet(new long[]{0x0000000000080000L,0x0000000000000020L});
    public static final BitSet FOLLOW_set_in_pingStatement735 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_PUTIFABSENT_in_putIfAbsentStatement763 = new BitSet(new long[]{0x0910022206004000L,0x0000000000000200L});
    public static final BitSet FOLLOW_keyIdentifier_in_putIfAbsentStatement769 = new BitSet(new long[]{0x0910022206004000L,0x0000000000000200L});
    public static final BitSet FOLLOW_literal_in_putIfAbsentStatement775 = new BitSet(new long[]{0x0000000000280000L,0x0000000000000020L});
    public static final BitSet FOLLOW_expirationClause_in_putIfAbsentStatement782 = new BitSet(new long[]{0x0000000000080000L,0x0000000000000020L});
    public static final BitSet FOLLOW_set_in_putIfAbsentStatement786 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_PUT_in_putStatement814 = new BitSet(new long[]{0x0910022206004000L,0x0000000000000200L});
    public static final BitSet FOLLOW_keyIdentifier_in_putStatement820 = new BitSet(new long[]{0x0910022206004000L,0x0000000000000200L});
    public static final BitSet FOLLOW_literal_in_putStatement826 = new BitSet(new long[]{0x0000000000280000L,0x0000000000000020L});
    public static final BitSet FOLLOW_expirationClause_in_putStatement833 = new BitSet(new long[]{0x0000000000080000L,0x0000000000000020L});
    public static final BitSet FOLLOW_set_in_putStatement837 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_REMOVE_in_removeStatement865 = new BitSet(new long[]{0x0910022206004000L,0x0000000000000200L});
    public static final BitSet FOLLOW_keyIdentifier_in_removeStatement871 = new BitSet(new long[]{0x0910022206084000L,0x0000000000000220L});
    public static final BitSet FOLLOW_literal_in_removeStatement878 = new BitSet(new long[]{0x0000000000080000L,0x0000000000000020L});
    public static final BitSet FOLLOW_set_in_removeStatement882 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_REPLACE_in_replaceStatement910 = new BitSet(new long[]{0x0910022206004000L,0x0000000000000200L});
    public static final BitSet FOLLOW_keyIdentifier_in_replaceStatement916 = new BitSet(new long[]{0x0910022206004000L,0x0000000000000200L});
    public static final BitSet FOLLOW_literal_in_replaceStatement922 = new BitSet(new long[]{0x0910022206284000L,0x0000000000000220L});
    public static final BitSet FOLLOW_literal_in_replaceStatement929 = new BitSet(new long[]{0x0000000000280000L,0x0000000000000020L});
    public static final BitSet FOLLOW_expirationClause_in_replaceStatement938 = new BitSet(new long[]{0x0000000000080000L,0x0000000000000020L});
    public static final BitSet FOLLOW_set_in_replaceStatement942 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ROLLBACK_in_rollbackTransactionStatement970 = new BitSet(new long[]{0x0010000000080000L,0x0000000000000020L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_rollbackTransactionStatement977 = new BitSet(new long[]{0x0000000000080000L,0x0000000000000020L});
    public static final BitSet FOLLOW_set_in_rollbackTransactionStatement981 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_START_in_startBatchStatement1009 = new BitSet(new long[]{0x0010000000080000L,0x0000000000000020L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_startBatchStatement1016 = new BitSet(new long[]{0x0000000000080000L,0x0000000000000020L});
    public static final BitSet FOLLOW_set_in_startBatchStatement1020 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_STATS_in_statsStatement1048 = new BitSet(new long[]{0x0010000000080000L,0x0000000000000024L});
    public static final BitSet FOLLOW_statementOptions_in_statsStatement1054 = new BitSet(new long[]{0x0010000000080000L,0x0000000000000020L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_statsStatement1061 = new BitSet(new long[]{0x0000000000080000L,0x0000000000000020L});
    public static final BitSet FOLLOW_set_in_statsStatement1065 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_UPGRADE_in_upgradeStatement1093 = new BitSet(new long[]{0x0010000000080000L,0x0000000000000024L});
    public static final BitSet FOLLOW_statementOptions_in_upgradeStatement1099 = new BitSet(new long[]{0x0010000000080000L,0x0000000000000020L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_upgradeStatement1106 = new BitSet(new long[]{0x0000000000080000L,0x0000000000000020L});
    public static final BitSet FOLLOW_set_in_upgradeStatement1110 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_VERSION_in_versionStatement1138 = new BitSet(new long[]{0x0000000000080000L,0x0000000000000020L});
    public static final BitSet FOLLOW_set_in_versionStatement1140 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_EXPIRES_in_expirationClause1168 = new BitSet(new long[]{0x0080000000000000L});
    public static final BitSet FOLLOW_timeLiteral_in_expirationClause1174 = new BitSet(new long[]{0x0000010000000002L});
    public static final BitSet FOLLOW_MAXIDLE_in_expirationClause1177 = new BitSet(new long[]{0x0080000000000000L});
    public static final BitSet FOLLOW_timeLiteral_in_expirationClause1183 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_keyIdentifier1206 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000008L});
    public static final BitSet FOLLOW_67_in_keyIdentifier1208 = new BitSet(new long[]{0x0910022206004000L,0x0000000000000200L});
    public static final BitSet FOLLOW_literal_in_keyIdentifier1210 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_literal_in_keyIdentifier1219 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_statementOption_in_statementOptions1247 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000004L});
    public static final BitSet FOLLOW_66_in_statementOption1271 = new BitSet(new long[]{0x0010000000000000L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_statementOption1277 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000040L});
    public static final BitSet FOLLOW_70_in_statementOption1280 = new BitSet(new long[]{0x0010000000000000L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_statementOption1286 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_INTLITERAL_in_literal1309 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_LONGLITERAL_in_literal1318 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_FLOATLITERAL_in_literal1327 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_DOUBLELITERAL_in_literal1336 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_NULL_in_literal1345 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_literal1354 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_UUIDLITERAL_in_literal1363 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_literal1376 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_jsonLiteral_in_literal1393 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_TIMELITERAL_in_timeLiteral1430 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_73_in_jsonLiteral1447 = new BitSet(new long[]{0x0010000000000000L});
    public static final BitSet FOLLOW_jsonPair_in_jsonLiteral1449 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000402L});
    public static final BitSet FOLLOW_65_in_jsonLiteral1452 = new BitSet(new long[]{0x0010000000000000L});
    public static final BitSet FOLLOW_jsonPair_in_jsonLiteral1454 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000402L});
    public static final BitSet FOLLOW_74_in_jsonLiteral1458 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_jsonString_in_jsonPair1473 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000010L});
    public static final BitSet FOLLOW_68_in_jsonPair1475 = new BitSet(new long[]{0x0110020202004000L,0x0000000000000280L});
    public static final BitSet FOLLOW_jsonValue_in_jsonPair1477 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_jsonString1492 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_jsonLiteral_in_jsonValue1507 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_jsonArray_in_jsonValue1514 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_INTLITERAL_in_jsonValue1521 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_DOUBLELITERAL_in_jsonValue1528 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_TRUE_in_jsonValue1535 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_FALSE_in_jsonValue1539 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_NULL_in_jsonValue1546 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_jsonString_in_jsonValue1553 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_71_in_jsonArray1568 = new BitSet(new long[]{0x0110020202004000L,0x0000000000000280L});
    public static final BitSet FOLLOW_jsonValue_in_jsonArray1570 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000102L});
    public static final BitSet FOLLOW_65_in_jsonArray1573 = new BitSet(new long[]{0x0110020202004000L,0x0000000000000280L});
    public static final BitSet FOLLOW_jsonValue_in_jsonArray1575 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000102L});
    public static final BitSet FOLLOW_72_in_jsonArray1579 = new BitSet(new long[]{0x0000000000000002L});

}